/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.azure;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.HostFileNameParser;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.VfsComponentContext;
import org.apache.hop.vfs.azure.AzureFileName;
import org.apache.hop.vfs.azure.config.AzureConfig;
import org.apache.hop.vfs.azure.config.AzureConfigSingleton;

public class AzureFileNameParser
extends HostFileNameParser {
    private static final AzureFileNameParser instance = new AzureFileNameParser();

    public static AzureFileNameParser getInstance() {
        return instance;
    }

    public AzureFileNameParser() {
        super(443);
    }

    public FileName parseUri(VfsComponentContext context, FileName base, String uri) throws FileSystemException {
        StringBuilder sb = new StringBuilder(uri);
        UriParser.normalisePath((StringBuilder)sb);
        String normalizedUri = sb.toString();
        String scheme = normalizedUri.substring(0, normalizedUri.indexOf(58));
        UriParser.normalisePath((StringBuilder)sb);
        Object absPath = "/";
        FileType fileType = FileType.IMAGINARY;
        String[] s = normalizedUri.split("/");
        if (s.length > 1) {
            if (scheme.equals("azure")) {
                String container = s[1];
                for (int i = 1; i < s.length; ++i) {
                    absPath = (String)absPath + s[i];
                    if (s.length <= 1 || i == s.length - 1) continue;
                    absPath = (String)absPath + "/";
                }
                fileType = this.getFileType(uri);
            } else if (scheme.equals("azfs")) {
                fileType = this.getFileType(uri);
                String path = normalizedUri.substring(normalizedUri.indexOf(47, 1), normalizedUri.length());
                AzureConfig azureConfig = AzureConfigSingleton.getConfig();
                absPath = AzureFileNameParser.stripFirstFolder(path);
            }
        }
        return new AzureFileName(scheme, (String)absPath, fileType);
    }

    private FileType getFileType(String uri) {
        if (uri.endsWith("/")) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    public static String stripFirstFolder(String path) {
        String normalizedPath = FilenameUtils.normalizeNoEndSeparator((String)path, (boolean)true);
        String withoutLeadingSlash = normalizedPath.startsWith("/") ? normalizedPath.substring(1) : normalizedPath;
        int index = withoutLeadingSlash.indexOf("/");
        if (index != -1) {
            return "/" + withoutLeadingSlash.substring(index + 1);
        }
        return "";
    }
}

