/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import org.apache.beam.sdk.metrics.MetricsSink;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public interface MetricsOptions
extends PipelineOptions {
    @Description(value="The beam sink class to which the metrics will be pushed")
    @Default.InstanceFactory(value=NoOpMetricsSink.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MetricsSink> getMetricsSink();

    public void setMetricsSink(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MetricsSink> var1);

    @Description(value="The metrics push period in seconds")
    @Default.Long(value=5L)
    public @UnknownKeyFor @NonNull @Initialized Long getMetricsPushPeriod();

    public void setMetricsPushPeriod(@UnknownKeyFor @NonNull @Initialized Long var1);

    @Description(value="MetricsHttpSink url")
    public @UnknownKeyFor @NonNull @Initialized String getMetricsHttpSinkUrl();

    public void setMetricsHttpSinkUrl(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The graphite metrics host")
    public @UnknownKeyFor @NonNull @Initialized String getMetricsGraphiteHost();

    public void setMetricsGraphiteHost(@UnknownKeyFor @NonNull @Initialized String var1);

    @Description(value="The graphite metrics port")
    @Default.Integer(value=2003)
    public @UnknownKeyFor @NonNull @Initialized Integer getMetricsGraphitePort();

    public void setMetricsGraphitePort(@UnknownKeyFor @NonNull @Initialized Integer var1);

    public static class NoOpMetricsSink
    implements DefaultValueFactory<Class<? extends MetricsSink>> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MetricsSink> create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            try {
                Class<?> noOpMetricsSinkClass = Class.forName("org.apache.beam.runners.core.metrics.NoOpMetricsSink", true, ReflectHelpers.findClassLoader());
                return noOpMetricsSinkClass;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(String.format("NoOpMetricsSink was not found on classpath", new Object[0]));
            }
        }
    }
}

