/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pipeline.transform.jdbcmetadata;

import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.pipeline.transform.jdbcmetadata.JdbcMetadata;
import org.apache.pipeline.transform.jdbcmetadata.JdbcMetadataData;
import org.apache.pipeline.transform.jdbcmetadata.OutputField;

@Transform(id="JdbcMetadata", image="jdbcmetadata.svg", name="i18n::JdbcMetadata.Name", description="i18n::JdbcMetaData.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", keywords={"i18n::JdbcMetaData.keyword"}, documentationUrl="/pipeline/transforms/jdbcmetadata.html")
public class JdbcMetadataMeta
extends BaseTransformMeta<JdbcMetadata, JdbcMetadataData> {
    public static Class<DatabaseMetaData> databaseMetaDataClass;
    private static final Map<Integer, String> OPTIONS_SCOPE;
    public static final String CONST_TABLE_CAT = "TABLE_CAT";
    private static final IValueMeta COL_TABLE_CAT;
    private static final IValueMeta COL_PKTABLE_CAT;
    private static final IValueMeta COL_FKTABLE_CAT;
    private static final IValueMeta COL_TABLE_CATALOG;
    private static final IValueMeta COL_TABLE_SCHEM;
    private static final IValueMeta COL_PKTABLE_SCHEM;
    private static final IValueMeta COL_FKTABLE_SCHEM;
    private static final IValueMeta COL_TABLE_NAME;
    private static final IValueMeta COL_PKTABLE_NAME;
    private static final IValueMeta COL_FKTABLE_NAME;
    private static final IValueMeta COL_TABLE_TYPE;
    private static final IValueMeta COL_COLUMN_NAME;
    private static final IValueMeta COL_PKCOLUMN_NAME;
    private static final IValueMeta COL_FKCOLUMN_NAME;
    private static final IValueMeta COL_PK_NAME;
    private static final IValueMeta COL_FK_NAME;
    private static final IValueMeta COL_KEY_SEQ;
    private static final IValueMeta COL_UPDATE_RULE;
    private static final IValueMeta COL_DELETE_RULE;
    private static final IValueMeta COL_DEFERRABILITY;
    private static final IValueMeta COL_TYPE_NAME;
    private static final IValueMeta COL_DATA_TYPE;
    private static final IValueMeta COL_PRECISION;
    private static final IValueMeta COL_COLUMN_SIZE;
    private static final IValueMeta COL_BUFFER_LENGTH;
    private static final IValueMeta COL_LITERAL_PREFIX;
    private static final IValueMeta COL_LITERAL_SUFFIX;
    private static final IValueMeta COL_CREATE_PARAMS;
    private static final IValueMeta COL_NULLABLE;
    private static final IValueMeta COL_CASE_SENSITIVE;
    private static final IValueMeta COL_SEARCHABLE;
    private static final IValueMeta COL_UNSIGNED_ATTRIBUTE;
    private static final IValueMeta COL_FIXED_PREC_SCALE;
    private static final IValueMeta COL_AUTO_INCREMENT;
    private static final IValueMeta COL_LOCAL_TYPE_NAME;
    private static final IValueMeta COL_MINIMUM_SCALE;
    private static final IValueMeta COL_MAXIMUM_SCALE;
    private static final IValueMeta COL_DECIMAL_DIGITS;
    private static final IValueMeta COL_SQL_DATA_TYPE;
    private static final IValueMeta COL_SQL_DATETIME_SUB;
    private static final IValueMeta COL_SOURCE_DATA_TYPE;
    private static final IValueMeta COL_NUM_PREC_RADIX;
    private static final IValueMeta COL_REMARKS;
    private static final IValueMeta COL_TYPE_CAT;
    private static final IValueMeta COL_TYPE_SCHEM;
    private static final IValueMeta COL_SELF_REFERENCING_COL_NAME;
    private static final IValueMeta COL_REF_GENERATION;
    private static final IValueMeta COL_SCOPE;
    private static final IValueMeta COL_PSEUDO_COLUMN;
    private static final IValueMeta COL_GRANTOR;
    private static final IValueMeta COL_GRANTEE;
    private static final IValueMeta COL_PRIVILEGE;
    private static final IValueMeta COL_IS_GRANTABLE;
    private static final IValueMeta COL_COLUMN_DEF;
    private static final IValueMeta COL_CHAR_OCTET_LENGTH;
    private static final IValueMeta COL_ORDINAL_POSITION;
    private static final IValueMeta COL_IS_NULLABLE;
    private static final IValueMeta COL_SCOPE_CATALOG;
    private static final IValueMeta COL_SCOPE_SCHEMA;
    private static final IValueMeta COL_SCOPE_TABLE;
    private static final IValueMeta COL_IS_AUTOINCREMENT;
    private static final IValueMeta COL_IS_GENERATEDCOLUMN;
    private static final Object[] ARG_CATALOG;
    private static final Object[] ARG_SCHEMA;
    private static final Object[] ARG_TABLE;
    private static final Object[] ARG_COLUMN_NAME_PATTERN;
    private static final Object[] ARG_NULLABLE;
    private static final Object[] ARG_SCHEMA_PATTERN;
    private static final Object[] ARG_SCOPE;
    private static final Object[] ARG_TABLE_TYPES;
    private static final Object[] ARG_TABLE_NAME_PATTERN;
    private static final Object[] ARG_PARENT_CATALOG;
    private static final Object[] ARG_PARENT_SCHEMA;
    private static final Object[] ARG_PARENT_TABLE;
    private static final Object[] ARG_FOREIGN_CATALOG;
    private static final Object[] ARG_FOREIGN_SCHEMA;
    private static final Object[] ARG_FOREIGN_TABLE;
    public static final Object[] methodDescriptors;
    @HopMetadataProperty
    private String connection;
    @HopMetadataProperty
    private boolean alwaysPassInputRow;
    @HopMetadataProperty
    private String methodName;
    @HopMetadataProperty
    private boolean argumentSourceFields;
    @HopMetadataProperty
    private boolean removeArgumentFields;
    @HopMetadataProperty(groupKey="arguments", key="argument")
    private List<String> arguments;
    @HopMetadataProperty(groupKey="outputFields", key="outputField")
    private List<OutputField> outputFields;

    public JdbcMetadataMeta() {
        if (databaseMetaDataClass == null) {
            try {
                databaseMetaDataClass = Class.forName("java.sql.DatabaseMetaData");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(exception);
            }
        }
    }

    public void setDefault() {
        this.methodName = "getCatalogs";
        this.argumentSourceFields = false;
        this.outputFields = new ArrayList<OutputField>();
        this.outputFields.add(new OutputField(CONST_TABLE_CAT, CONST_TABLE_CAT));
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public boolean isAlwaysPassInputRow() {
        return this.alwaysPassInputRow;
    }

    public void setAlwaysPassInputRow(boolean alwaysPassInputRow) {
        this.alwaysPassInputRow = alwaysPassInputRow;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    private static Object[] getMethodDescriptor(String methodName) {
        for (Object o : methodDescriptors) {
            Object[] oo = (Object[])o;
            if (!oo[0].toString().equals(methodName)) continue;
            return oo;
        }
        return null;
    }

    public static Object[] getMethodDescriptor(int index) {
        return (Object[])methodDescriptors[index];
    }

    public Object[] getMethodDescriptor() {
        return JdbcMetadataMeta.getMethodDescriptor(this.getMethodName());
    }

    public IValueMeta[] getMethodResultSetDescriptor() {
        Object[] methodDescriptor = this.getMethodDescriptor();
        return (IValueMeta[])methodDescriptor[2];
    }

    public static int getMethodDescriptorIndex(String methodName) {
        Object[] methods = methodDescriptors;
        int n = methods.length;
        for (int i = 0; i < n; ++i) {
            Object[] methodDescriptor = (Object[])methods[i];
            String name = (String)methodDescriptor[0];
            if (!name.equals(methodName)) continue;
            return i;
        }
        return -1;
    }

    public static String getMethodName(int methodDescriptorIndex) {
        Object[] methodDescriptor = (Object[])methodDescriptors[methodDescriptorIndex];
        return (String)methodDescriptor[0];
    }

    public static Class<?>[] getMethodParameterTypes(Object[] methodDescriptor) {
        Object[] parameters = (Object[])methodDescriptor[1];
        int n = parameters.length;
        Class[] parameterTypes = new Class[n];
        for (int i = 0; i < n; ++i) {
            Object[] parameter = (Object[])parameters[i];
            parameterTypes[i] = (Class)parameter[1];
        }
        return parameterTypes;
    }

    public static Method getMethod(String methodName) throws Exception {
        Object[] methodDescriptor = JdbcMetadataMeta.getMethodDescriptor(methodName);
        Method method = (Method)methodDescriptor[3];
        if (method != null) {
            return method;
        }
        Class<?> dbmd = Class.forName("java.sql.DatabaseMetaData");
        Class<?>[] parameterTypes = JdbcMetadataMeta.getMethodParameterTypes(methodDescriptor);
        method = dbmd.getDeclaredMethod(methodName, parameterTypes);
        methodDescriptor[3] = method;
        return method;
    }

    public Method getMethod() throws Exception {
        return JdbcMetadataMeta.getMethod(this.methodName);
    }

    public boolean isArgumentSourceFields() {
        return this.argumentSourceFields;
    }

    public void setArgumentSourceFields(boolean argumentSourceFields) {
        this.argumentSourceFields = argumentSourceFields;
    }

    public boolean isRemoveArgumentFields() {
        return this.removeArgumentFields;
    }

    public void setRemoveArgumentFields(boolean removeArgumentFields) {
        this.removeArgumentFields = removeArgumentFields;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public List<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(List<OutputField> outputFields) {
        this.outputFields = outputFields;
    }

    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.argumentSourceFields && this.removeArgumentFields) {
            for (int i = 0; i < this.arguments.size(); ++i) {
                try {
                    rowMeta.removeValueMeta(this.arguments.get(i));
                    continue;
                }
                catch (HopValueException hopValueException) {
                    // empty catch block
                }
            }
        }
        List<OutputField> outputFields = this.getOutputFields();
        int n = outputFields.size();
        Object[] methodDescriptor = this.getMethodDescriptor();
        IValueMeta[] fields = (IValueMeta[])methodDescriptor[2];
        int m = fields.length;
        block3: for (int i = 0; i < n; ++i) {
            OutputField outputField = outputFields.get(i);
            for (int j = 0; j < m; ++j) {
                IValueMeta field = fields[j];
                String fieldName = field.getName();
                if (!fieldName.equals(outputField.getName())) continue;
                field = new ValueMetaBase(outputField.getRename() == null ? fieldName : outputField.getRename(), field.getType());
                field.setOrigin(origin);
                rowMeta.addValueMeta(field);
                continue block3;
            }
        }
    }

    static {
        OPTIONS_SCOPE = new HashMap<Integer, String>();
        OPTIONS_SCOPE.put(2, "bestRowSession");
        OPTIONS_SCOPE.put(0, "bestRowTemporary");
        OPTIONS_SCOPE.put(1, "bestRowTransaction");
        COL_TABLE_CAT = new ValueMetaString(CONST_TABLE_CAT);
        COL_PKTABLE_CAT = new ValueMetaString("PKTABLE_CAT");
        COL_FKTABLE_CAT = new ValueMetaString("FKTABLE_CAT");
        COL_TABLE_CATALOG = new ValueMetaString("TABLE_CATALOG");
        COL_TABLE_SCHEM = new ValueMetaString("TABLE_SCHEM");
        COL_PKTABLE_SCHEM = new ValueMetaString("PKTABLE_SCHEM");
        COL_FKTABLE_SCHEM = new ValueMetaString("FKTABLE_SCHEM");
        COL_TABLE_NAME = new ValueMetaString("TABLE_NAME");
        COL_PKTABLE_NAME = new ValueMetaString("PKTABLE_NAME");
        COL_FKTABLE_NAME = new ValueMetaString("FKTABLE_NAME");
        COL_TABLE_TYPE = new ValueMetaString("TABLE_TYPE");
        COL_COLUMN_NAME = new ValueMetaString("COLUMN_NAME");
        COL_PKCOLUMN_NAME = new ValueMetaString("PKCOLUMN_NAME");
        COL_FKCOLUMN_NAME = new ValueMetaString("FKCOLUMN_NAME");
        COL_PK_NAME = new ValueMetaString("PK_NAME");
        COL_FK_NAME = new ValueMetaString("FK_NAME");
        COL_KEY_SEQ = new ValueMetaInteger("KEY_SEQ");
        COL_UPDATE_RULE = new ValueMetaInteger("UPDATE_RULE");
        COL_DELETE_RULE = new ValueMetaInteger("DELETE_RULE");
        COL_DEFERRABILITY = new ValueMetaInteger("DEFERRABILITY");
        COL_TYPE_NAME = new ValueMetaString("TYPE_NAME");
        COL_DATA_TYPE = new ValueMetaInteger("DATA_TYPE");
        COL_PRECISION = new ValueMetaInteger("PRECISION");
        COL_COLUMN_SIZE = new ValueMetaInteger("COLUMN_SIZE");
        COL_BUFFER_LENGTH = new ValueMetaString("BUFFER_LENGTH");
        COL_LITERAL_PREFIX = new ValueMetaString("LITERAL_PREFIX");
        COL_LITERAL_SUFFIX = new ValueMetaString("LITERAL_SUFFIX");
        COL_CREATE_PARAMS = new ValueMetaString("CREATE_PARAMS");
        COL_NULLABLE = new ValueMetaInteger("NULLABLE");
        COL_CASE_SENSITIVE = new ValueMetaBoolean("CASE_SENSITIVE");
        COL_SEARCHABLE = new ValueMetaInteger("SEARCHABLE");
        COL_UNSIGNED_ATTRIBUTE = new ValueMetaBoolean("UNSIGNED_ATTRIBUTE");
        COL_FIXED_PREC_SCALE = new ValueMetaBoolean("FIXED_PREC_SCALE");
        COL_AUTO_INCREMENT = new ValueMetaBoolean("AUTO_INCREMENT");
        COL_LOCAL_TYPE_NAME = new ValueMetaString("LOCAL_TYPE_NAME");
        COL_MINIMUM_SCALE = new ValueMetaInteger("MINIMUM_SCALE");
        COL_MAXIMUM_SCALE = new ValueMetaInteger("MAXIMUM_SCALE");
        COL_DECIMAL_DIGITS = new ValueMetaInteger("DECIMAL_DIGITS");
        COL_SQL_DATA_TYPE = new ValueMetaInteger("SQL_DATA_TYPE");
        COL_SQL_DATETIME_SUB = new ValueMetaInteger("SQL_DATETIME_SUB");
        COL_SOURCE_DATA_TYPE = new ValueMetaInteger("SOURCE_DATA_TYPE");
        COL_NUM_PREC_RADIX = new ValueMetaInteger("NUM_PREC_RADIX");
        COL_REMARKS = new ValueMetaString("REMARKS");
        COL_TYPE_CAT = new ValueMetaString("TYPE_CAT");
        COL_TYPE_SCHEM = new ValueMetaString("TYPE_SCHEM");
        COL_SELF_REFERENCING_COL_NAME = new ValueMetaString("SELF_REFERENCING_COL_NAME");
        COL_REF_GENERATION = new ValueMetaString("REF_GENERATION");
        COL_SCOPE = new ValueMetaInteger("SCOPE");
        COL_PSEUDO_COLUMN = new ValueMetaInteger("COL_PSEUDO_COLUMN");
        COL_GRANTOR = new ValueMetaString("GRANTOR");
        COL_GRANTEE = new ValueMetaString("GRANTEE");
        COL_PRIVILEGE = new ValueMetaString("PRIVILEGE");
        COL_IS_GRANTABLE = new ValueMetaString("IS_GRANTABLE");
        COL_COLUMN_DEF = new ValueMetaString("COLUMN_DEF");
        COL_CHAR_OCTET_LENGTH = new ValueMetaInteger("CHAR_OCTET_LENGTH");
        COL_ORDINAL_POSITION = new ValueMetaInteger("ORDINAL_POSITION");
        COL_IS_NULLABLE = new ValueMetaString("IS_NULLABLE");
        COL_SCOPE_CATALOG = new ValueMetaString("SCOPE_CATALOG");
        COL_SCOPE_SCHEMA = new ValueMetaString("SCOPE_SCHEMA");
        COL_SCOPE_TABLE = new ValueMetaString("SCOPE_TABLE");
        COL_IS_AUTOINCREMENT = new ValueMetaString("IS_AUTOINCREMENT");
        COL_IS_GENERATEDCOLUMN = new ValueMetaString("IS_GENERATEDCOLUMN");
        ARG_CATALOG = new Object[]{"catalog", String.class};
        ARG_SCHEMA = new Object[]{"schema", String.class};
        ARG_TABLE = new Object[]{"table", String.class};
        ARG_COLUMN_NAME_PATTERN = new Object[]{"columnNamePattern", String.class};
        ARG_NULLABLE = new Object[]{"nullable", Boolean.class, new Object[0]};
        ARG_SCHEMA_PATTERN = new Object[]{"schemaPattern", String.class};
        ARG_SCOPE = new Object[]{"scope", Integer.class, OPTIONS_SCOPE};
        ARG_TABLE_TYPES = new Object[]{"tableTypes", String[].class};
        ARG_TABLE_NAME_PATTERN = new Object[]{"tableNamePattern", String.class};
        ARG_PARENT_CATALOG = new Object[]{"parentCatalog", String.class};
        ARG_PARENT_SCHEMA = new Object[]{"parentSchema", String.class};
        ARG_PARENT_TABLE = new Object[]{"parentTable", String.class};
        ARG_FOREIGN_CATALOG = new Object[]{"foreignCatalog", String.class};
        ARG_FOREIGN_SCHEMA = new Object[]{"foreignSchema", String.class};
        ARG_FOREIGN_TABLE = new Object[]{"foreignTable", String.class};
        methodDescriptors = new Object[]{new Object[]{"getCatalogs", new Object[0], new IValueMeta[]{COL_TABLE_CAT}, null}, new Object[]{"getBestRowIdentifier", new Object[]{ARG_CATALOG, ARG_SCHEMA, ARG_TABLE, ARG_SCOPE, ARG_NULLABLE}, new IValueMeta[]{COL_SCOPE, COL_COLUMN_NAME, COL_DATA_TYPE, COL_TYPE_NAME, COL_COLUMN_SIZE, COL_BUFFER_LENGTH, COL_DECIMAL_DIGITS, COL_PSEUDO_COLUMN}, null}, new Object[]{"getColumnPrivileges", new Object[]{ARG_CATALOG, ARG_SCHEMA, ARG_TABLE, ARG_COLUMN_NAME_PATTERN}, new IValueMeta[]{COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_COLUMN_NAME, COL_GRANTOR, COL_GRANTEE, COL_PRIVILEGE, COL_IS_GRANTABLE}, null}, new Object[]{"getColumns", new Object[]{ARG_CATALOG, ARG_SCHEMA_PATTERN, ARG_TABLE_NAME_PATTERN, ARG_COLUMN_NAME_PATTERN}, new IValueMeta[]{COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_COLUMN_NAME, COL_DATA_TYPE, COL_TYPE_NAME, COL_COLUMN_SIZE, COL_BUFFER_LENGTH, COL_DECIMAL_DIGITS, COL_NUM_PREC_RADIX, COL_NULLABLE, COL_REMARKS, COL_COLUMN_DEF, COL_SQL_DATA_TYPE, COL_SQL_DATETIME_SUB, COL_CHAR_OCTET_LENGTH, COL_ORDINAL_POSITION, COL_IS_NULLABLE, COL_SCOPE_CATALOG, COL_SCOPE_SCHEMA, COL_SCOPE_TABLE, COL_SOURCE_DATA_TYPE, COL_IS_AUTOINCREMENT, COL_IS_GENERATEDCOLUMN}, null}, new Object[]{"getCrossReference", new Object[]{ARG_PARENT_CATALOG, ARG_PARENT_SCHEMA, ARG_PARENT_TABLE, ARG_FOREIGN_CATALOG, ARG_FOREIGN_SCHEMA, ARG_FOREIGN_TABLE}, new IValueMeta[]{COL_PKTABLE_CAT, COL_PKTABLE_SCHEM, COL_PKTABLE_NAME, COL_PKCOLUMN_NAME, COL_FKTABLE_CAT, COL_FKTABLE_SCHEM, COL_FKTABLE_NAME, COL_FKCOLUMN_NAME, COL_KEY_SEQ, COL_UPDATE_RULE, COL_DELETE_RULE, COL_FK_NAME, COL_PK_NAME, COL_DEFERRABILITY}, null}, new Object[]{"getExportedKeys", new Object[]{ARG_CATALOG, ARG_SCHEMA, ARG_TABLE}, new IValueMeta[]{COL_PKTABLE_CAT, COL_PKTABLE_SCHEM, COL_PKTABLE_NAME, COL_PKCOLUMN_NAME, COL_FKTABLE_CAT, COL_FKTABLE_SCHEM, COL_FKTABLE_NAME, COL_FKCOLUMN_NAME, COL_KEY_SEQ, COL_UPDATE_RULE, COL_DELETE_RULE, COL_FK_NAME, COL_PK_NAME, COL_DEFERRABILITY}, null}, new Object[]{"getImportedKeys", new Object[]{ARG_CATALOG, ARG_SCHEMA, ARG_TABLE}, new IValueMeta[]{COL_PKTABLE_CAT, COL_PKTABLE_SCHEM, COL_PKTABLE_NAME, COL_PKCOLUMN_NAME, COL_FKTABLE_CAT, COL_FKTABLE_SCHEM, COL_FKTABLE_NAME, COL_FKCOLUMN_NAME, COL_KEY_SEQ, COL_UPDATE_RULE, COL_DELETE_RULE, COL_FK_NAME, COL_PK_NAME, COL_DEFERRABILITY}, null}, new Object[]{"getPrimaryKeys", new Object[]{ARG_CATALOG, ARG_SCHEMA, ARG_TABLE}, new IValueMeta[]{COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_COLUMN_NAME, COL_KEY_SEQ, COL_PK_NAME}, null}, new Object[]{"getSchemas", new Object[0], new IValueMeta[]{COL_TABLE_SCHEM, COL_TABLE_CATALOG}, null}, new Object[]{"getTablePrivileges", new Object[]{ARG_CATALOG, ARG_SCHEMA_PATTERN, ARG_TABLE_NAME_PATTERN}, new IValueMeta[]{COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_GRANTOR, COL_GRANTEE, COL_PRIVILEGE, COL_IS_GRANTABLE}, null}, new Object[]{"getTableTypes", new Object[0], new IValueMeta[]{COL_TABLE_TYPE}, null}, new Object[]{"getTables", new Object[]{ARG_CATALOG, ARG_SCHEMA_PATTERN, ARG_TABLE_NAME_PATTERN, ARG_TABLE_TYPES}, new IValueMeta[]{COL_TABLE_CAT, COL_TABLE_SCHEM, COL_TABLE_NAME, COL_TABLE_TYPE, COL_REMARKS, COL_TYPE_CAT, COL_TYPE_SCHEM, COL_TYPE_NAME, COL_SELF_REFERENCING_COL_NAME, COL_REF_GENERATION}, null}, new Object[]{"getTypeInfo", new Object[0], new IValueMeta[]{COL_TYPE_NAME, COL_DATA_TYPE, COL_PRECISION, COL_LITERAL_PREFIX, COL_LITERAL_SUFFIX, COL_CREATE_PARAMS, COL_NULLABLE, COL_CASE_SENSITIVE, COL_SEARCHABLE, COL_UNSIGNED_ATTRIBUTE, COL_FIXED_PREC_SCALE, COL_AUTO_INCREMENT, COL_LOCAL_TYPE_NAME, COL_MINIMUM_SCALE, COL_MAXIMUM_SCALE, COL_SQL_DATA_TYPE, COL_SQL_DATETIME_SUB, COL_NUM_PREC_RADIX}, null}, new Object[]{"getVersionColumns", new Object[]{ARG_CATALOG, ARG_SCHEMA, ARG_TABLE}, new IValueMeta[]{COL_SCOPE, COL_COLUMN_NAME, COL_DATA_TYPE, COL_TYPE_NAME, COL_COLUMN_SIZE, COL_BUFFER_LENGTH, COL_DECIMAL_DIGITS, COL_PSEUDO_COLUMN}, null}};
    }
}

