/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.workflow;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.annotations.ActionTransformType;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.INamedParameterDefinitions;
import org.apache.hop.core.parameters.NamedParameters;
import org.apache.hop.core.util.CurrentDirectoryResolver;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataPropertyType;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.workflow.ActionWorkflowRunner;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;

@Action(id="WORKFLOW", image="ui/images/workflow.svg", name="i18n::ActionWorkflow.Name", description="i18n::ActionWorkflow.Description", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.General", keywords={"i18n::ActionWorkflow.keyword"}, documentationUrl="/workflow/actions/workflow.html", actionTransformTypes={ActionTransformType.HOP_FILE, ActionTransformType.HOP_WORKFLOW})
public class ActionWorkflow
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWorkflow.class;
    @HopMetadataProperty(key="filename", hopMetadataPropertyType=HopMetadataPropertyType.WORKFLOW_FILE)
    private String filename;
    @HopMetadataProperty(key="params_from_previous")
    private boolean paramsFromPrevious;
    @HopMetadataProperty(key="exec_per_row")
    private boolean execPerRow;
    @HopMetadataProperty(key="set_logfile")
    private boolean setLogfile;
    @HopMetadataProperty(key="logfile")
    private String logfile;
    @HopMetadataProperty(key="logext")
    private String logext;
    @HopMetadataProperty(key="add_date")
    private boolean addDate;
    @HopMetadataProperty(key="add_time")
    private boolean addTime;
    @HopMetadataProperty(key="loglevel", storeWithCode=true)
    private LogLevel logFileLevel;
    @HopMetadataProperty(key="set_append_logfile")
    private boolean setAppendLogfile;
    @HopMetadataProperty(key="create_parent_folder")
    private boolean createParentFolder;
    @HopMetadataProperty(key="wait_until_finished")
    private boolean waitingToFinish = true;
    @HopMetadataProperty(key="parameters")
    private ParameterDefinition parameterDefinition = new ParameterDefinition();
    @HopMetadataProperty(key="run_configuration")
    private String runConfiguration;
    public static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.NOTHING;
    private IWorkflowEngine<WorkflowMeta> workflow;

    public ActionWorkflow(String name) {
        super(name, "");
    }

    public ActionWorkflow() {
        this("");
        this.clear();
    }

    public void setFileName(String name) {
        this.filename = name;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    public String getRunConfiguration() {
        return this.runConfiguration;
    }

    public void setRunConfiguration(String runConfiguration) {
        this.runConfiguration = runConfiguration;
    }

    public String getLogFilename() {
        Object retval = "";
        if (this.setLogfile) {
            SimpleDateFormat sdf;
            retval = (String)retval + (this.logfile == null ? "" : this.logfile);
            Calendar cal = Calendar.getInstance();
            if (this.addDate) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.addTime) {
                sdf = new SimpleDateFormat("HHmmss");
                retval = (String)retval + "_" + sdf.format(cal.getTime());
            }
            if (this.logext != null && this.logext.length() > 0) {
                retval = (String)retval + "." + this.logext;
            }
        }
        return retval;
    }

    public ParameterDefinition getParameterDefinition() {
        return this.parameterDefinition;
    }

    public void setParameterDefinition(ParameterDefinition parameterDefinition) {
        this.parameterDefinition = parameterDefinition;
    }

    public Result execute(Result result, int nr) throws HopException {
        result.setEntryNr((long)nr);
        LogChannelFileWriter logChannelFileWriter = null;
        LogLevel workflowLogLevel = this.parentWorkflow.getLogLevel();
        if (this.setLogfile) {
            String realLogFilename = this.resolve(this.getLogFilename());
            if (Utils.isEmpty((CharSequence)realLogFilename)) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionWorkflow.Exception.LogFilenameMissing", (String[])new String[0]));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            if (!this.createParentFolder(realLogFilename)) {
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            try {
                logChannelFileWriter = new LogChannelFileWriter(this.getLogChannelId(), HopVfs.getFileObject((String)realLogFilename), this.setAppendLogfile);
                logChannelFileWriter.startLogging();
            }
            catch (HopException e) {
                this.logError("Unable to open file appender for file [" + this.getLogFilename() + "] : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
            workflowLogLevel = this.logFileLevel;
        }
        try {
            if (this.parentWorkflow.getWorkflowMeta() != null) {
                this.parentWorkflow.getWorkflowMeta().setInternalHopVariables((IVariables)this);
            }
            this.logDetailed("Loading workflow from XML file : [" + this.resolve(this.filename) + "]");
            WorkflowMeta workflowMeta = this.getWorkflowMeta(this.getMetadataProvider(), (IVariables)this);
            if (workflowMeta == null) {
                throw new HopException("Unable to load the workflow: please specify a filename");
            }
            this.verifyRecursiveExecution((IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, workflowMeta);
            this.copyFrom((IVariables)this.parentWorkflow);
            this.setParentVariables((IVariables)this.parentWorkflow);
            RowMetaAndData resultRow = null;
            boolean first = true;
            ArrayList rows = new ArrayList(result.getRows());
            for (int iteration = 0; first && !this.execPerRow || this.execPerRow && rows != null && iteration < rows.size() && result.getNrErrors() == 0L; ++iteration) {
                first = false;
                if (this.execPerRow) {
                    result.getRows().clear();
                }
                resultRow = rows != null && this.execPerRow ? (RowMetaAndData)rows.get(iteration) : null;
                NamedParameters namedParam = new NamedParameters();
                if (this.paramsFromPrevious) {
                    String[] parentParameters = this.parentWorkflow.listParameters();
                    for (int idx = 0; idx < parentParameters.length; ++idx) {
                        Object par = parentParameters[idx];
                        String def = this.parentWorkflow.getParameterDefault((String)par);
                        String val = this.parentWorkflow.getParameterValue((String)par);
                        String des = this.parentWorkflow.getParameterDescription((String)par);
                        namedParam.addParameterDefinition((String)par, def, des);
                        namedParam.setParameterValue((String)par, val);
                    }
                }
                for (Parameter parameter : this.parameterDefinition.getParameters()) {
                    if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                    if (Const.indexOfString((String)parameter.getName(), (String[])namedParam.listParameters()) < 0) {
                        try {
                            namedParam.addParameterDefinition(parameter.getName(), "", "Action runtime");
                        }
                        catch (DuplicateParamException e) {
                            this.logError("Duplicate parameter definition for " + parameter.getName());
                        }
                    }
                    if (Utils.isEmpty((CharSequence)Const.trim((String)parameter.getField()))) {
                        namedParam.setParameterValue(parameter.getName(), Const.NVL((String)this.resolve(parameter.getValue()), (String)""));
                        continue;
                    }
                    String value = "";
                    if (resultRow != null) {
                        value = resultRow.getString(parameter.getField(), "");
                    }
                    namedParam.setParameterValue(parameter.getName(), value);
                }
                Result oneResult = new Result();
                ArrayList<RowMetaAndData> sourceRows = null;
                if (this.execPerRow) {
                    ArrayList<RowMetaAndData> newList = new ArrayList<RowMetaAndData>();
                    newList.add(resultRow);
                    sourceRows = newList;
                    if (this.paramsFromPrevious) {
                        for (Parameter parameter : this.parameterDefinition.getParameters()) {
                            if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                            if (Utils.isEmpty((CharSequence)Const.trim((String)parameter.getField()))) {
                                namedParam.setParameterValue(parameter.getName(), Const.NVL((String)this.resolve(parameter.getValue()), (String)""));
                                continue;
                            }
                            String fieldValue = "";
                            if (resultRow != null) {
                                fieldValue = resultRow.getString(parameter.getField(), "");
                            }
                            namedParam.setParameterValue(parameter.getName(), Const.NVL((String)fieldValue, (String)""));
                        }
                    }
                } else {
                    sourceRows = result.getRows();
                    if (this.paramsFromPrevious) {
                        for (Parameter parameter : this.parameterDefinition.getParameters()) {
                            if (Utils.isEmpty((CharSequence)parameter.getName())) continue;
                            if (Utils.isEmpty((CharSequence)Const.trim((String)parameter.getField()))) {
                                namedParam.setParameterValue(parameter.getName(), Const.NVL((String)this.resolve(parameter.getValue()), (String)""));
                                continue;
                            }
                            String fieldValue = "";
                            if (resultRow != null) {
                                fieldValue = resultRow.getString(parameter.getField(), "");
                            }
                            namedParam.setParameterValue(parameter.getName(), Const.NVL((String)fieldValue, (String)""));
                        }
                    }
                }
                this.workflow = WorkflowEngineFactory.createWorkflowEngine((IVariables)this, (String)this.resolve(this.runConfiguration), (IHopMetadataProvider)this.getMetadataProvider(), (WorkflowMeta)workflowMeta, (ILoggingObject)this);
                this.workflow.setParentWorkflow(this.parentWorkflow);
                this.workflow.setLogLevel(workflowLogLevel);
                this.workflow.shareWith((IVariables)this);
                this.workflow.setResult(result);
                this.workflow.setInternalHopVariables();
                this.workflow.copyParametersFromDefinitions((INamedParameterDefinitions)workflowMeta);
                this.workflow.getActionListeners().addAll(this.parentWorkflow.getActionListeners());
                this.workflow.clearParameterValues();
                String[] parameterNames = this.workflow.listParameters();
                for (int idx = 0; idx < parameterNames.length; ++idx) {
                    String parentValue;
                    String thisValue = namedParam.getParameterValue(parameterNames[idx]);
                    if (!Utils.isEmpty((CharSequence)thisValue)) {
                        this.workflow.setParameterValue(parameterNames[idx], thisValue);
                        continue;
                    }
                    if (!this.parameterDefinition.isPassingAllParameters() || Utils.isEmpty((CharSequence)(parentValue = this.parentWorkflow.getParameterValue(parameterNames[idx])))) continue;
                    this.workflow.setParameterValue(parameterNames[idx], parentValue);
                }
                this.workflow.activateParameters(this.workflow);
                this.workflow.setSourceRows(sourceRows);
                this.parentWorkflow.getWorkflowTracker().addWorkflowTracker(this.workflow.getWorkflowTracker());
                this.workflow.getWorkflowTracker().setParentWorkflowTracker(this.parentWorkflow.getWorkflowTracker());
                ActionWorkflowRunner runner = new ActionWorkflowRunner(this.workflow, result, nr, this.getLogChannel());
                Thread workflowRunnerThread = new Thread(runner);
                workflowRunnerThread.setName(Const.NVL((String)this.workflow.getWorkflowMeta().getName(), (String)this.workflow.getWorkflowMeta().getFilename()) + " UUID: " + UUID.randomUUID().toString());
                workflowRunnerThread.start();
                if (!this.isWaitingToFinish()) continue;
                while (!runner.isFinished() && !this.parentWorkflow.isStopped()) {
                    try {
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.parentWorkflow.isStopped()) {
                    this.workflow.stopExecution();
                    runner.waitUntilFinished();
                }
                oneResult = runner.getResult();
                result.clear();
                result.add(oneResult);
                if (!Utils.isEmpty((List)oneResult.getRows())) {
                    result.setRows(new ArrayList(oneResult.getRows()));
                }
                if (oneResult.getResult()) continue;
                result.setNrErrors(result.getNrErrors() + 1L);
            }
        }
        catch (HopException ke) {
            this.logError("Error running action 'workflow' : ", ke);
            result.setResult(false);
            result.setNrErrors(1L);
        }
        if (this.setLogfile && logChannelFileWriter != null) {
            logChannelFileWriter.stopLogging();
            ResultFile resultFile = new ResultFile(1, logChannelFileWriter.getLogFile(), this.parentWorkflow.getWorkflowName(), this.getName());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (logChannelFileWriter.getException() != null) {
                this.logError("Unable to open log file [" + this.getLogFilename() + "] : ");
                this.logError(Const.getStackTracker((Throwable)logChannelFileWriter.getException()));
                result.setNrErrors(1L);
                result.setResult(false);
                return result;
            }
        }
        if (result.getNrErrors() > 0L) {
            result.setResult(false);
        } else {
            result.setResult(true);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createParentFolder(String filename) {
        FileObject parentfolder = null;
        boolean resultat = true;
        try {
            parentfolder = HopVfs.getFileObject((String)filename).getParent();
            if (!parentfolder.exists()) {
                if (this.createParentFolder) {
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                    parentfolder.createFolder();
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderCreated", (String[])new String[]{parentfolder.getName().toString()}));
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderNotExist", (String[])new String[]{parentfolder.getName().toString()}));
                    resultat = false;
                }
            } else if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionWorkflow.Log.ParentLogFolderExists", (String[])new String[]{parentfolder.getName().toString()}));
            }
        }
        catch (Exception e) {
            resultat = false;
            this.logError(BaseMessages.getString(PKG, (String)"ActionWorkflow.Error.ChekingParentLogFolderTitle", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"ActionWorkflow.Error.ChekingParentLogFolder", (String[])new String[]{parentfolder.getName().toString()}), e});
        }
        finally {
            if (parentfolder != null) {
                try {
                    parentfolder.close();
                    parentfolder = null;
                }
                catch (Exception exception) {}
            }
        }
        return resultat;
    }

    private void verifyRecursiveExecution(IWorkflowEngine<WorkflowMeta> parentWorkflow, WorkflowMeta workflowMeta) throws HopException {
        if (parentWorkflow == null) {
            return;
        }
        WorkflowMeta parentWorkflowMeta = parentWorkflow.getWorkflowMeta();
        if (parentWorkflowMeta.getName() == null && workflowMeta.getName() != null) {
            return;
        }
        if (parentWorkflowMeta.getName() != null && workflowMeta.getName() == null) {
            return;
        }
        if (workflowMeta.getFilename() != null && workflowMeta.getFilename().equals(parentWorkflowMeta.getFilename())) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionWorkflowError.Recursive", (String[])new String[]{workflowMeta.getFilename()}));
        }
        this.verifyRecursiveExecution((IWorkflowEngine<WorkflowMeta>)parentWorkflow.getParentWorkflow(), workflowMeta);
    }

    public void clear() {
        super.clear();
        this.filename = null;
        this.addDate = false;
        this.addTime = false;
        this.logfile = null;
        this.logext = null;
        this.setLogfile = false;
        this.setAppendLogfile = false;
        this.runConfiguration = null;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<SqlStatement> getSqlStatements(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        this.copyFrom(variables);
        WorkflowMeta workflowMeta = this.getWorkflowMeta(metadataProvider, variables);
        return workflowMeta.getSqlStatements(metadataProvider, null, variables);
    }

    public WorkflowMeta getWorkflowMeta(IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        WorkflowMeta workflowMeta = null;
        try {
            CurrentDirectoryResolver r = new CurrentDirectoryResolver();
            IVariables tmpSpace = r.resolveCurrentDirectory(variables, this.parentWorkflow, this.getFilename());
            String realFilename = tmpSpace.resolve(this.getFilename());
            workflowMeta = new WorkflowMeta(tmpSpace, realFilename, metadataProvider);
            if (workflowMeta != null) {
                workflowMeta.setMetadataProvider(metadataProvider);
            }
            return workflowMeta;
        }
        catch (Exception e) {
            throw new HopException("Unexpected error during workflow metadata load", (Throwable)e);
        }
    }

    public boolean isExecPerRow() {
        return this.execPerRow;
    }

    public void setExecPerRow(boolean runEveryResultRow) {
        this.execPerRow = runEveryResultRow;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = this.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.ACTIONFILE));
            references.add(reference);
        }
        return references;
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming namingInterface, IHopMetadataProvider metadataProvider) throws HopException {
        this.copyFrom(variables);
        WorkflowMeta workflowMeta = this.getWorkflowMeta(metadataProvider, variables);
        String proposedNewFilename = workflowMeta.exportResources((IVariables)this, definitions, namingInterface, metadataProvider);
        String newFilename = "${Internal.Entry.Current.Folder}/" + proposedNewFilename;
        workflowMeta.setFilename(newFilename);
        this.filename = newFilename;
        return proposedNewFilename;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (this.setLogfile) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "logfile", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
    }

    public String getLogfile() {
        return this.logfile;
    }

    public boolean isWaitingToFinish() {
        return this.waitingToFinish;
    }

    public void setWaitingToFinish(boolean waitingToFinish) {
        this.waitingToFinish = waitingToFinish;
    }

    public IWorkflowEngine<WorkflowMeta> getWorkflow() {
        return this.workflow;
    }

    private boolean isWorkflowDefined() {
        return !Utils.isEmpty((CharSequence)this.filename);
    }

    public boolean[] isReferencedObjectEnabled() {
        return new boolean[]{this.isWorkflowDefined()};
    }

    public String[] getReferencedObjectDescriptions() {
        return new String[]{BaseMessages.getString(PKG, (String)"ActionWorkflow.ReferencedObject.Description", (String[])new String[0])};
    }

    public IHasFilename loadReferencedObject(int index, IHopMetadataProvider metadataProvider, IVariables variables) throws HopException {
        return this.getWorkflowMeta(metadataProvider, variables);
    }

    public boolean isAddDate() {
        return this.addDate;
    }

    public boolean isAddTime() {
        return this.addTime;
    }

    public void setAddDate(boolean addDate) {
        this.addDate = addDate;
    }

    public void setAddTime(boolean addTime) {
        this.addTime = addTime;
    }

    public String getLogext() {
        return this.logext;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setLogfile(String logfile) {
        this.logfile = logfile;
    }

    public void setLogext(String logext) {
        this.logext = logext;
    }

    public boolean isSetLogfile() {
        return this.setLogfile;
    }

    public LogLevel getLogFileLevel() {
        return this.logFileLevel;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public void setSetLogfile(boolean setLogfile) {
        this.setLogfile = setLogfile;
    }

    public void setLogFileLevel(LogLevel logFileLevel) {
        this.logFileLevel = logFileLevel;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public boolean isParamsFromPrevious() {
        return this.paramsFromPrevious;
    }

    public boolean isSetAppendLogfile() {
        return this.setAppendLogfile;
    }

    public void setParamsFromPrevious(boolean paramsFromPrevious) {
        this.paramsFromPrevious = paramsFromPrevious;
    }

    public void setSetAppendLogfile(boolean setAppendLogfile) {
        this.setAppendLogfile = setAppendLogfile;
    }

    public static final class ParameterDefinition {
        @HopMetadataProperty(key="pass_all_parameters")
        private boolean passingAllParameters = true;
        @HopMetadataProperty(key="parameter")
        private List<Parameter> parameters = new ArrayList<Parameter>();

        public boolean isPassingAllParameters() {
            return this.passingAllParameters;
        }

        public void setPassingAllParameters(boolean passingAllParameters) {
            this.passingAllParameters = passingAllParameters;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public void setParameters(List<Parameter> parameters) {
            this.parameters = parameters;
        }
    }

    public static final class Parameter {
        @HopMetadataProperty
        public String name;
        @HopMetadataProperty
        public String value;
        @HopMetadataProperty(key="stream_name")
        public String field;

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String getField() {
            return this.field;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public void setField(String field) {
            this.field = field;
        }
    }
}

