/*
 * Decompiled with CFR 0.152.
 */
package org.duckdb;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.time.LocalDateTime;
import org.duckdb.DuckDBConnection;
import org.duckdb.DuckDBNative;
import org.duckdb.DuckDBTimestamp;

public class DuckDBAppender
implements AutoCloseable {
    protected ByteBuffer appender_ref = null;

    public DuckDBAppender(DuckDBConnection con, String schemaName, String tableName) throws SQLException {
        if (con == null) {
            throw new SQLException("Invalid connection");
        }
        this.appender_ref = DuckDBNative.duckdb_jdbc_create_appender(con.connRef, schemaName.getBytes(StandardCharsets.UTF_8), tableName.getBytes(StandardCharsets.UTF_8));
    }

    public void beginRow() throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_begin_row(this.appender_ref);
    }

    public void endRow() throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_end_row(this.appender_ref);
    }

    public void flush() throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_flush(this.appender_ref);
    }

    public void append(boolean value) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_boolean(this.appender_ref, value);
    }

    public void append(byte value) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_byte(this.appender_ref, value);
    }

    public void append(short value) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_short(this.appender_ref, value);
    }

    public void append(int value) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_int(this.appender_ref, value);
    }

    public void append(long value) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_long(this.appender_ref, value);
    }

    public void appendLocalDateTime(LocalDateTime value) throws SQLException {
        if (value == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            long timeInMicros = DuckDBTimestamp.localDateTime2Micros(value);
            DuckDBNative.duckdb_jdbc_appender_append_timestamp(this.appender_ref, timeInMicros);
        }
    }

    public void appendBigDecimal(BigDecimal value) throws SQLException {
        if (value == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            DuckDBNative.duckdb_jdbc_appender_append_decimal(this.appender_ref, value);
        }
    }

    public void append(float value) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_float(this.appender_ref, value);
    }

    public void append(double value) throws SQLException {
        DuckDBNative.duckdb_jdbc_appender_append_double(this.appender_ref, value);
    }

    public void append(String value) throws SQLException {
        if (value == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            DuckDBNative.duckdb_jdbc_appender_append_string(this.appender_ref, value.getBytes(StandardCharsets.UTF_8));
        }
    }

    public void append(byte[] value) throws SQLException {
        if (value == null) {
            DuckDBNative.duckdb_jdbc_appender_append_null(this.appender_ref);
        } else {
            DuckDBNative.duckdb_jdbc_appender_append_bytes(this.appender_ref, value);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.appender_ref != null) {
            DuckDBNative.duckdb_jdbc_appender_close(this.appender_ref);
            this.appender_ref = null;
        }
    }
}

