/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.file.workflow.context;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.file.IHasFilename;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.gui.plugin.IGuiRefresher;
import org.apache.hop.core.gui.plugin.action.GuiAction;
import org.apache.hop.core.gui.plugin.action.GuiActionLambdaBuilder;
import org.apache.hop.core.gui.plugin.action.GuiActionType;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.context.BaseGuiContextHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.dataorch.HopDataOrchestrationPerspective;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;

public class HopGuiWorkflowActionContext
extends BaseGuiContextHandler
implements IGuiContextHandler {
    public static final Class<?> PKG = HopGuiWorkflowActionContext.class;
    public static final String CONTEXT_ID = "HopGuiWorkflowActionContext";
    private WorkflowMeta workflowMeta;
    private ActionMeta actionMeta;
    private HopGuiWorkflowGraph workflowGraph;
    private Point click;
    private GuiActionLambdaBuilder<HopGuiWorkflowActionContext> lambdaBuilder;

    public HopGuiWorkflowActionContext(WorkflowMeta workflowMeta, ActionMeta actionMeta, HopGuiWorkflowGraph workflowGraph, Point click) {
        this.workflowMeta = workflowMeta;
        this.actionMeta = actionMeta;
        this.workflowGraph = workflowGraph;
        this.click = click;
        this.lambdaBuilder = new GuiActionLambdaBuilder();
    }

    @Override
    public String getContextId() {
        return CONTEXT_ID;
    }

    @Override
    public List<GuiAction> getSupportedActions() {
        ArrayList<GuiAction> actions = new ArrayList<GuiAction>();
        IAction action = this.actionMeta.getAction();
        String[] objectDescriptions = action.getReferencedObjectDescriptions();
        for (int i = 0; objectDescriptions != null && i < objectDescriptions.length; ++i) {
            String objectDescription = objectDescriptions[i];
            if (!action.isReferencedObjectEnabled()[i]) continue;
            int index = i;
            GuiAction openReferencedAction = new GuiAction("action-open-referenced-" + objectDescription, GuiActionType.Info, BaseMessages.getString(PKG, (String)"HopGuiWorkflowTransformContext.OpenReferencedAction.Name", (String[])new String[]{objectDescription}), BaseMessages.getString(PKG, (String)"HopGuiWorkflowTransformContext.OpenReferencedAction.Tooltip", (String[])new String[0]), "ui/images/open.svg", (shiftAction, controlAction, t) -> HopGuiWorkflowActionContext.openReferencedObject(this.workflowMeta, this.workflowGraph.getVariables(), action, objectDescription, index));
            openReferencedAction.setCategory("Basic");
            openReferencedAction.setCategoryOrder("1");
            actions.add(openReferencedAction);
        }
        List<GuiAction> pluginActions = this.getPluginActions(true);
        if (pluginActions != null) {
            for (GuiAction pluginAction : pluginActions) {
                actions.add(this.lambdaBuilder.createLambda(pluginAction, (Object)this, (IGuiRefresher)this.workflowGraph));
            }
        }
        return actions;
    }

    public static final void openReferencedObject(WorkflowMeta workflowMeta, IVariables variables, IAction action, String objectDescription, int index) {
        HopGui hopGui = HopGui.getInstance();
        try {
            IHasFilename hasFilename = action.loadReferencedObject(index, workflowMeta.getMetadataProvider(), variables);
            if (hasFilename != null) {
                String filename = variables.resolve(hasFilename.getFilename());
                HopDataOrchestrationPerspective perspective = HopGui.getDataOrchestrationPerspective();
                TabItemHandler tabItemHandler = perspective.findTabItemHandlerWithFilename(filename);
                if (tabItemHandler != null) {
                    perspective.switchToTab(tabItemHandler);
                } else {
                    hopGui.fileDelegate.fileOpen(filename);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(hopGui.getShell(), "Error", "Error opening referenced object '" + objectDescription + "'", e);
        }
    }

    public WorkflowMeta getWorkflowMeta() {
        return this.workflowMeta;
    }

    public void setWorkflowMeta(WorkflowMeta workflowMeta) {
        this.workflowMeta = workflowMeta;
    }

    public ActionMeta getActionMeta() {
        return this.actionMeta;
    }

    public void setActionMeta(ActionMeta actionMeta) {
        this.actionMeta = actionMeta;
    }

    public HopGuiWorkflowGraph getWorkflowGraph() {
        return this.workflowGraph;
    }

    public void setWorkflowGraph(HopGuiWorkflowGraph workflowGraph) {
        this.workflowGraph = workflowGraph;
    }

    public Point getClick() {
        return this.click;
    }

    public void setClick(Point click) {
        this.click = click;
    }

    public GuiActionLambdaBuilder<HopGuiWorkflowActionContext> getLambdaBuilder() {
        return this.lambdaBuilder;
    }

    public void setLambdaBuilder(GuiActionLambdaBuilder<HopGuiWorkflowActionContext> lambdaBuilder) {
        this.lambdaBuilder = lambdaBuilder;
    }
}

