/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.workflow.dialog;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.base.AbstractMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.parameters.DuplicateParamException;
import org.apache.hop.core.parameters.UnknownParamException;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.HelpUtils;
import org.apache.hop.ui.workflow.dialog.IWorkflowDialogPlugin;
import org.apache.hop.ui.workflow.dialog.WorkflowDialogPluginType;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class WorkflowDialog
extends Dialog {
    private static final Class<?> PKG = WorkflowDialog.class;
    private CTabFolder wTabFolder;
    private final PropsUi props;
    private Text wWorkflowName;
    private Button wNameFilenameSync;
    private Text wFilename;
    protected Button wOk;
    protected Button wCancel;
    private final IVariables variables;
    private WorkflowMeta workflowMeta;
    private Shell shell;
    private ModifyListener lsMod;
    private boolean changed;
    private TableView wParamFields;
    private Text wDescription;
    private Text wExtendedDescription;
    private Combo wWorkflowStatus;
    private Text wVersion;
    private int middle;
    private int margin;
    private Text wCreateUser;
    private Text wCreateDate;
    private Text wModUser;
    private Text wModDate;
    private ArrayList<IWorkflowDialogPlugin> extraTabs;

    public WorkflowDialog(Shell parent, int style, IVariables variables, WorkflowMeta workflowMeta) {
        super(parent, style);
        this.variables = variables;
        this.workflowMeta = workflowMeta;
        this.props = PropsUi.getInstance();
    }

    public WorkflowMeta open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 68848);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageWorkflow());
        this.lsMod = e -> {
            this.changed = true;
        };
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.WorkflowProperties.ShellText", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, 4);
        this.addWorkflowTab();
        this.addParamTab();
        this.extraTabs = new ArrayList();
        List jobDialogPlugins = PluginRegistry.getInstance().getPlugins(WorkflowDialogPluginType.class);
        for (IPlugin jobDialogPlugin : jobDialogPlugins) {
            try {
                IWorkflowDialogPlugin extraTab = (IWorkflowDialogPlugin)PluginRegistry.getInstance().loadClass(jobDialogPlugin);
                extraTab.addTab(this.workflowMeta, parent, this.wTabFolder);
                this.extraTabs.add(extraTab);
            }
            catch (Exception e2) {
                new ErrorDialog(this.shell, "Error", "Error loading workflow dialog plugin with id " + jobDialogPlugin.getIds()[0], e2);
            }
        }
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment(0, 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOk, this.wCancel}, this.margin, null);
        this.wTabFolder.setSelection(0);
        this.getData();
        this.changed = false;
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
        return this.workflowMeta;
    }

    public String[] listParameterNames() {
        int count = this.wParamFields.nrNonEmpty();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wParamFields.getNonEmpty(i);
            String parameterName = item.getText(1);
            if (Utils.isEmpty((CharSequence)parameterName) || list.contains(parameterName)) continue;
            list.add(parameterName);
        }
        return list.toArray(new String[list.size()]);
    }

    private void addWorkflowTab() {
        CTabItem wWorkflowTab = new CTabItem(this.wTabFolder, 0);
        wWorkflowTab.setFont(GuiResource.getInstance().getFontDefault());
        wWorkflowTab.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.WorkflowTab.Label", (String[])new String[0]));
        Composite wWorkflowComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wWorkflowComp);
        FormLayout workflowLayout = new FormLayout();
        workflowLayout.marginWidth = PropsUi.getMargin();
        workflowLayout.marginHeight = PropsUi.getMargin();
        wWorkflowComp.setLayout((Layout)workflowLayout);
        Label wlWorkflowName = new Label(wWorkflowComp, 131072);
        wlWorkflowName.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.WorkflowName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWorkflowName);
        FormData fdlWorkflowName = new FormData();
        fdlWorkflowName.left = new FormAttachment(0, 0);
        fdlWorkflowName.right = new FormAttachment(this.middle, -this.margin);
        fdlWorkflowName.top = new FormAttachment(0, this.margin);
        wlWorkflowName.setLayoutData((Object)fdlWorkflowName);
        this.wWorkflowName = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wWorkflowName);
        this.wWorkflowName.addModifyListener(this.lsMod);
        FormData fdWorkflowName = new FormData();
        fdWorkflowName.left = new FormAttachment(this.middle, 0);
        fdWorkflowName.top = new FormAttachment(0, this.margin);
        fdWorkflowName.right = new FormAttachment(100, 0);
        this.wWorkflowName.setLayoutData((Object)fdWorkflowName);
        Text lastControl = this.wWorkflowName;
        Label wlNameFilenameSync = new Label(wWorkflowComp, 131072);
        wlNameFilenameSync.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.NameFilenameSync.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNameFilenameSync);
        FormData fdlNameFilenameSync = new FormData();
        fdlNameFilenameSync.left = new FormAttachment(0, 0);
        fdlNameFilenameSync.right = new FormAttachment(this.middle, -this.margin);
        fdlNameFilenameSync.top = new FormAttachment((Control)lastControl, this.margin);
        wlNameFilenameSync.setLayoutData((Object)fdlNameFilenameSync);
        this.wNameFilenameSync = new Button(wWorkflowComp, 32);
        PropsUi.setLook((Widget)this.wNameFilenameSync);
        FormData fdNameFilenameSync = new FormData();
        fdNameFilenameSync.left = new FormAttachment(this.middle, 0);
        fdNameFilenameSync.top = new FormAttachment((Control)wlNameFilenameSync, 0, 0x1000000);
        fdNameFilenameSync.right = new FormAttachment(100, 0);
        this.wNameFilenameSync.setLayoutData((Object)fdNameFilenameSync);
        this.wNameFilenameSync.addListener(13, this::updateNameFilenameSync);
        lastControl = this.wNameFilenameSync;
        Label wlFilename = new Label(wWorkflowComp, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        fdlFilename.top = new FormAttachment((Control)lastControl, this.margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.wFilename = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(this.middle, 0);
        fdFilename.top = new FormAttachment((Control)wlFilename, 0, 0x1000000);
        fdFilename.right = new FormAttachment(100, 0);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.setEditable(false);
        this.wFilename.setBackground(GuiResource.getInstance().getColorLightGray());
        Label wlDescription = new Label(wWorkflowComp, 131072);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.Description.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDescription);
        FormData fdlDescription = new FormData();
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(this.middle, -this.margin);
        fdlDescription.top = new FormAttachment((Control)this.wFilename, this.margin);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wDescription);
        this.wDescription.addModifyListener(this.lsMod);
        FormData fdDescription = new FormData();
        fdDescription.left = new FormAttachment(this.middle, 0);
        fdDescription.top = new FormAttachment((Control)this.wFilename, this.margin);
        fdDescription.right = new FormAttachment(100, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        Label wlExtendedDescription = new Label(wWorkflowComp, 131072);
        wlExtendedDescription.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.Extendeddescription.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlExtendedDescription);
        FormData fdlExtendedDescription = new FormData();
        fdlExtendedDescription.left = new FormAttachment(0, 0);
        fdlExtendedDescription.top = new FormAttachment((Control)this.wDescription, this.margin);
        fdlExtendedDescription.right = new FormAttachment(this.middle, -this.margin);
        wlExtendedDescription.setLayoutData((Object)fdlExtendedDescription);
        this.wExtendedDescription = new Text(wWorkflowComp, 19202);
        PropsUi.setLook((Widget)this.wExtendedDescription, 1);
        this.wExtendedDescription.addModifyListener(this.lsMod);
        FormData fdExtendedDescription = new FormData();
        fdExtendedDescription.left = new FormAttachment(this.middle, 0);
        fdExtendedDescription.top = new FormAttachment((Control)this.wDescription, this.margin);
        fdExtendedDescription.right = new FormAttachment(100, 0);
        fdExtendedDescription.bottom = new FormAttachment(50, -this.margin);
        this.wExtendedDescription.setLayoutData((Object)fdExtendedDescription);
        Label wlWorkflowStatus = new Label(wWorkflowComp, 131072);
        wlWorkflowStatus.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.WorkflowStatus.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlWorkflowStatus);
        FormData fdlWorkflowStatus = new FormData();
        fdlWorkflowStatus.left = new FormAttachment(0, 0);
        fdlWorkflowStatus.right = new FormAttachment(this.middle, -this.margin);
        fdlWorkflowStatus.top = new FormAttachment((Control)this.wExtendedDescription, this.margin * 2);
        wlWorkflowStatus.setLayoutData((Object)fdlWorkflowStatus);
        this.wWorkflowStatus = new Combo(wWorkflowComp, 2060);
        this.wWorkflowStatus.add(BaseMessages.getString(PKG, (String)"WorkflowDialog.Draft_WorkflowStatus.Label", (String[])new String[0]));
        this.wWorkflowStatus.add(BaseMessages.getString(PKG, (String)"WorkflowDialog.Production_WorkflowStatus.Label", (String[])new String[0]));
        this.wWorkflowStatus.add("");
        this.wWorkflowStatus.select(-1);
        PropsUi.setLook((Widget)this.wWorkflowStatus);
        FormData fdWorkflowStatus = new FormData();
        fdWorkflowStatus.left = new FormAttachment(this.middle, 0);
        fdWorkflowStatus.top = new FormAttachment((Control)this.wExtendedDescription, this.margin * 2);
        fdWorkflowStatus.right = new FormAttachment(100, 0);
        this.wWorkflowStatus.setLayoutData((Object)fdWorkflowStatus);
        Label wlVersion = new Label(wWorkflowComp, 131072);
        wlVersion.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.Version.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlVersion);
        FormData fdlVersion = new FormData();
        fdlVersion.left = new FormAttachment(0, 0);
        fdlVersion.right = new FormAttachment(this.middle, -this.margin);
        fdlVersion.top = new FormAttachment((Control)this.wWorkflowStatus, this.margin);
        wlVersion.setLayoutData((Object)fdlVersion);
        this.wVersion = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wVersion);
        this.wVersion.addModifyListener(this.lsMod);
        FormData fdVersion = new FormData();
        fdVersion.left = new FormAttachment(this.middle, 0);
        fdVersion.top = new FormAttachment((Control)this.wWorkflowStatus, this.margin);
        fdVersion.right = new FormAttachment(100, 0);
        this.wVersion.setLayoutData((Object)fdVersion);
        Label wlCreateUser = new Label(wWorkflowComp, 131072);
        wlCreateUser.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.CreateUser.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateUser);
        FormData fdlCreateUser = new FormData();
        fdlCreateUser.left = new FormAttachment(0, 0);
        fdlCreateUser.right = new FormAttachment(this.middle, -this.margin);
        fdlCreateUser.top = new FormAttachment((Control)this.wVersion, this.margin);
        wlCreateUser.setLayoutData((Object)fdlCreateUser);
        this.wCreateUser = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wCreateUser);
        this.wCreateUser.setEditable(false);
        this.wCreateUser.addModifyListener(this.lsMod);
        FormData fdCreateUser = new FormData();
        fdCreateUser.left = new FormAttachment(this.middle, 0);
        fdCreateUser.top = new FormAttachment((Control)this.wVersion, this.margin);
        fdCreateUser.right = new FormAttachment(100, 0);
        this.wCreateUser.setLayoutData((Object)fdCreateUser);
        Label wlCreateDate = new Label(wWorkflowComp, 131072);
        wlCreateDate.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.CreateDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCreateDate);
        FormData fdlCreateDate = new FormData();
        fdlCreateDate.left = new FormAttachment(0, 0);
        fdlCreateDate.right = new FormAttachment(this.middle, -this.margin);
        fdlCreateDate.top = new FormAttachment((Control)this.wCreateUser, this.margin);
        wlCreateDate.setLayoutData((Object)fdlCreateDate);
        this.wCreateDate = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wCreateDate);
        this.wCreateDate.setEditable(false);
        this.wCreateDate.addModifyListener(this.lsMod);
        FormData fdCreateDate = new FormData();
        fdCreateDate.left = new FormAttachment(this.middle, 0);
        fdCreateDate.top = new FormAttachment((Control)this.wCreateUser, this.margin);
        fdCreateDate.right = new FormAttachment(100, 0);
        this.wCreateDate.setLayoutData((Object)fdCreateDate);
        Label wlModUser = new Label(wWorkflowComp, 131072);
        wlModUser.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.LastModifiedUser.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlModUser);
        FormData fdlModUser = new FormData();
        fdlModUser.left = new FormAttachment(0, 0);
        fdlModUser.right = new FormAttachment(this.middle, -this.margin);
        fdlModUser.top = new FormAttachment((Control)this.wCreateDate, this.margin);
        wlModUser.setLayoutData((Object)fdlModUser);
        this.wModUser = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wModUser);
        this.wModUser.setEditable(false);
        this.wModUser.addModifyListener(this.lsMod);
        FormData fdModUser = new FormData();
        fdModUser.left = new FormAttachment(this.middle, 0);
        fdModUser.top = new FormAttachment((Control)this.wCreateDate, this.margin);
        fdModUser.right = new FormAttachment(100, 0);
        this.wModUser.setLayoutData((Object)fdModUser);
        Label wlModDate = new Label(wWorkflowComp, 131072);
        wlModDate.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.LastModifiedDate.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlModDate);
        FormData fdlModDate = new FormData();
        fdlModDate.left = new FormAttachment(0, 0);
        fdlModDate.right = new FormAttachment(this.middle, -this.margin);
        fdlModDate.top = new FormAttachment((Control)this.wModUser, this.margin);
        wlModDate.setLayoutData((Object)fdlModDate);
        this.wModDate = new Text(wWorkflowComp, 18436);
        PropsUi.setLook((Widget)this.wModDate);
        this.wModDate.setEditable(false);
        this.wModDate.addModifyListener(this.lsMod);
        FormData fdModDate = new FormData();
        fdModDate.left = new FormAttachment(this.middle, 0);
        fdModDate.top = new FormAttachment((Control)this.wModUser, this.margin);
        fdModDate.right = new FormAttachment(100, 0);
        this.wModDate.setLayoutData((Object)fdModDate);
        FormData fdWorkflowComp = new FormData();
        fdWorkflowComp.left = new FormAttachment(0, 0);
        fdWorkflowComp.top = new FormAttachment(0, 0);
        fdWorkflowComp.right = new FormAttachment(100, 0);
        fdWorkflowComp.bottom = new FormAttachment(100, 0);
        wWorkflowComp.setLayoutData((Object)fdWorkflowComp);
        wWorkflowTab.setControl((Control)wWorkflowComp);
    }

    private void updateNameFilenameSync(Event event) {
        String name = this.wWorkflowName.getText();
        String filename = this.wFilename.getText();
        boolean sync = this.wNameFilenameSync.getSelection();
        String actualName = AbstractMeta.extractNameFromFilename((boolean)sync, (String)name, (String)filename, (String)".hwf");
        this.wWorkflowName.setEnabled(!sync);
        this.wWorkflowName.setEditable(!sync);
        this.wWorkflowName.setText(Const.NVL((String)actualName, (String)""));
    }

    private void addParamTab() {
        CTabItem wParamTab = new CTabItem(this.wTabFolder, 0);
        wParamTab.setFont(GuiResource.getInstance().getFontDefault());
        wParamTab.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.ParamTab.Label", (String[])new String[0]));
        FormLayout paramLayout = new FormLayout();
        paramLayout.marginWidth = PropsUi.getMargin();
        paramLayout.marginHeight = PropsUi.getMargin();
        Composite wParamComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wParamComp);
        wParamComp.setLayout((Layout)paramLayout);
        Label wlFields = new Label(wParamComp, 131072);
        wlFields.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.Parameters.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment(0, 0);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.workflowMeta.listParameters().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowDialog.ColumnInfo.Parameter.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowDialog.ColumnInfo.Default.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WorkflowDialog.ColumnInfo.Description.Label", (String[])new String[0]), 1, false)};
        this.wParamFields = new TableView(this.variables, wParamComp, 67586, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wParamFields.setLayoutData(fdFields);
        FormData fdDepComp = new FormData();
        fdDepComp.left = new FormAttachment(0, 0);
        fdDepComp.top = new FormAttachment(0, 0);
        fdDepComp.right = new FormAttachment(100, 0);
        fdDepComp.bottom = new FormAttachment(100, 0);
        wParamComp.setLayoutData((Object)fdDepComp);
        wParamComp.layout();
        wParamTab.setControl((Control)wParamComp);
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wWorkflowName.setText(Const.NVL((String)this.workflowMeta.getName(), (String)""));
        this.wNameFilenameSync.setSelection(this.workflowMeta.isNameSynchronizedWithFilename());
        this.wFilename.setText(Const.NVL((String)this.workflowMeta.getFilename(), (String)""));
        this.updateNameFilenameSync(null);
        this.wDescription.setText(Const.NVL((String)this.workflowMeta.getDescription(), (String)""));
        this.wExtendedDescription.setText(Const.NVL((String)this.workflowMeta.getExtendedDescription(), (String)""));
        this.wVersion.setText(Const.NVL((String)this.workflowMeta.getWorkflowVersion(), (String)""));
        this.wWorkflowStatus.select(this.workflowMeta.getWorkflowStatus() - 1);
        if (this.workflowMeta.getCreatedUser() != null) {
            this.wCreateUser.setText(this.workflowMeta.getCreatedUser());
        }
        if (this.workflowMeta.getCreatedDate() != null) {
            this.wCreateDate.setText(this.workflowMeta.getCreatedDate().toString());
        }
        if (this.workflowMeta.getModifiedUser() != null) {
            this.wModUser.setText(this.workflowMeta.getModifiedUser());
        }
        if (this.workflowMeta.getModifiedDate() != null) {
            this.wModDate.setText(this.workflowMeta.getModifiedDate().toString());
        }
        String[] parameters = this.workflowMeta.listParameters();
        for (int idx = 0; idx < parameters.length; ++idx) {
            String defValue;
            String description;
            TableItem item = this.wParamFields.table.getItem(idx);
            try {
                description = this.workflowMeta.getParameterDescription(parameters[idx]);
            }
            catch (UnknownParamException e) {
                description = "";
            }
            try {
                defValue = this.workflowMeta.getParameterDefault(parameters[idx]);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            item.setText(1, parameters[idx]);
            item.setText(2, Const.NVL((String)defValue, (String)""));
            item.setText(3, Const.NVL((String)description, (String)""));
        }
        this.wParamFields.setRowNums();
        this.wParamFields.optWidth(true);
        for (IWorkflowDialogPlugin extraTab : this.extraTabs) {
            extraTab.getData(this.workflowMeta);
        }
    }

    private void cancel() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.workflowMeta = null;
        this.dispose();
    }

    private void ok() {
        boolean allGood = true;
        this.workflowMeta.setName(this.wWorkflowName.getText());
        this.workflowMeta.setNameSynchronizedWithFilename(this.wNameFilenameSync.getSelection());
        this.workflowMeta.setDescription(this.wDescription.getText());
        this.workflowMeta.setExtendedDescription(this.wExtendedDescription.getText());
        this.workflowMeta.setWorkflowVersion(this.wVersion.getText());
        if (this.wWorkflowStatus.getSelectionIndex() != 2) {
            this.workflowMeta.setWorkflowStatus(this.wWorkflowStatus.getSelectionIndex() + 1);
        } else {
            this.workflowMeta.setWorkflowStatus(-1);
        }
        this.workflowMeta.removeAllParameters();
        int nrNonEmptyFields = this.wParamFields.nrNonEmpty();
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wParamFields.getNonEmpty(i);
            try {
                if (!(!StringUtils.isEmpty((String)item.getText(1)) || StringUtils.isEmpty((String)item.getText(2)) && StringUtils.isEmpty((String)item.getText(3)))) {
                    allGood = false;
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setText(BaseMessages.getString(PKG, (String)"WorkflowDialog.NoUnnamedParameters.DialogTitle", (String[])new String[0]));
                    mb.setMessage(BaseMessages.getString(PKG, (String)"WorkflowDialog.NoUnnamedParameters.DialogMessage", (String[])new String[0]));
                    mb.open();
                    continue;
                }
                this.workflowMeta.addParameterDefinition(item.getText(1), item.getText(2), item.getText(3));
                continue;
            }
            catch (DuplicateParamException duplicateParamException) {
                // empty catch block
            }
        }
        for (IWorkflowDialogPlugin extraTab : this.extraTabs) {
            extraTab.ok(this.workflowMeta);
        }
        this.workflowMeta.setChanged(this.changed || this.workflowMeta.hasChanged());
        if (allGood) {
            this.dispose();
        }
    }

    public static final Button setShellImage(Shell shell, IAction action) {
        Button helpButton = null;
        try {
            IPlugin plugin = WorkflowDialog.getPlugin(action);
            Deprecated deprecated = action.getClass().getDeclaredAnnotation(Deprecated.class);
            if (deprecated != null) {
                WorkflowDialog.addDeprecation(shell);
            }
            helpButton = HelpUtils.createHelpButton((Composite)shell, plugin);
            shell.setImage(WorkflowDialog.getImage(shell, plugin));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return helpButton;
    }

    private static void addDeprecation(final Shell shell) {
        if (shell == null) {
            return;
        }
        shell.addShellListener((ShellListener)new ShellAdapter(){
            private boolean deprecation = false;

            public void shellActivated(ShellEvent shellEvent) {
                super.shellActivated(shellEvent);
                if (this.deprecation) {
                    return;
                }
                String deprecated = BaseMessages.getString(PKG, (String)"System.Deprecated", (String[])new String[0]).toLowerCase();
                shell.setText(shell.getText() + " (" + deprecated + ")");
                this.deprecation = true;
            }
        });
    }

    public static IPlugin getPlugin(IAction action) {
        return PluginRegistry.getInstance().getPlugin(ActionPluginType.class, (Object)action);
    }

    public static Image getImage(Shell shell, IPlugin plugin) {
        String id = plugin.getIds()[0];
        if (id != null) {
            return GuiResource.getInstance().getSwtImageAction(id).getAsBitmapForSize((Device)shell.getDisplay(), 32, 32);
        }
        return null;
    }
}

