/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.caching;

import java.text.SimpleDateFormat;
import java.util.Date;
import lombok.Generated;
import org.apache.hop.execution.caching.CacheEntry;

public class EntrySummary {
    private String startDate;
    private String endDate;
    private long durationMs;

    EntrySummary() {
    }

    public EntrySummary(EntrySummary s) {
        this();
        this.startDate = s.startDate;
        this.endDate = s.endDate;
        this.durationMs = s.durationMs;
    }

    public void calculateSummary(CacheEntry entry) {
        if (entry.getExecution() == null) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        Date start = entry.getExecution().getExecutionStartDate();
        if (entry.getExecutionState() == null) {
            return;
        }
        Date end = entry.getExecutionState().getExecutionEndDate();
        if (start != null) {
            this.startDate = sdf.format(start);
            if (end != null) {
                this.endDate = sdf.format(end);
                this.durationMs = end.getTime() - start.getTime();
            }
        }
    }

    @Generated
    public String getStartDate() {
        return this.startDate;
    }

    @Generated
    public String getEndDate() {
        return this.endDate;
    }

    @Generated
    public long getDurationMs() {
        return this.durationMs;
    }

    @Generated
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @Generated
    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    @Generated
    public void setDurationMs(long durationMs) {
        this.durationMs = durationMs;
    }
}

