/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hop.core.Const;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannelFileWriter;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.util.FileUtil;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebResult;

@HopServerServlet(id="addPipeline", name="Add a pipeline for execution")
public class AddPipelineServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    private static final long serialVersionUID = -6850701762586992604L;
    public static final String CONTEXT_PATH = "/hop/addPipeline";

    public AddPipelineServlet() {
    }

    public AddPipelineServlet(PipelineMap pipelineMap) {
        super(pipelineMap);
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Addition of pipeline requested");
        }
        boolean useXML = "Y".equalsIgnoreCase(request.getParameter("xml"));
        PrintWriter out = response.getWriter();
        BufferedReader in = request.getReader();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        if (useXML) {
            response.setContentType("text/xml");
            out.print(XmlHandler.getXmlHeader());
        } else {
            response.setContentType("text/html");
            out.println("<HTML>");
            out.println("<HEAD><TITLE>Add pipeline</TITLE></HEAD>");
            out.println("<BODY>");
        }
        response.setStatus(200);
        String realLogFilename = null;
        PipelineExecutionConfiguration pipelineExecutionConfiguration = null;
        try {
            int c;
            StringBuilder xml = new StringBuilder(request.getContentLength());
            while ((c = in.read()) != -1) {
                xml.append((char)c);
            }
            PipelineConfiguration pipelineConfiguration = PipelineConfiguration.fromXml(xml.toString());
            PipelineMeta pipelineMeta = pipelineConfiguration.getPipelineMeta();
            pipelineExecutionConfiguration = pipelineConfiguration.getPipelineExecutionConfiguration();
            if (this.log.isDetailed()) {
                this.logDetailed("Logging level set to " + this.log.getLogLevel().getDescription());
            }
            String serverObjectId = UUID.randomUUID().toString();
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            servletLoggingObject.setContainerObjectId(serverObjectId);
            servletLoggingObject.setLogLevel(pipelineExecutionConfiguration.getLogLevel());
            MultiMetadataProvider metadataProvider = new MultiMetadataProvider(this.variables, new IHopMetadataProvider[]{this.getServerConfig().getMetadataProvider(), pipelineConfiguration.getMetadataProvider()});
            String runConfigurationName = pipelineExecutionConfiguration.getRunConfiguration();
            IPipelineEngine<PipelineMeta> pipeline = PipelineEngineFactory.createPipelineEngine(this.variables, this.variables.resolve(runConfigurationName), (IHopMetadataProvider)metadataProvider, pipelineMeta);
            pipeline.setParent((ILoggingObject)servletLoggingObject);
            if (pipelineExecutionConfiguration.isSetLogfile()) {
                realLogFilename = pipelineExecutionConfiguration.getLogFileName();
                try {
                    FileUtil.createParentFolder(AddPipelineServlet.class, realLogFilename, pipelineExecutionConfiguration.isCreateParentFolder(), pipeline.getLogChannel());
                    LogChannelFileWriter logChannelFileWriter = new LogChannelFileWriter(servletLoggingObject.getLogChannelId(), HopVfs.getFileObject((String)realLogFilename), pipelineExecutionConfiguration.isSetAppendLogfile());
                    logChannelFileWriter.startLogging();
                    pipeline.addExecutionFinishedListener(pipelineEngine -> {
                        if (logChannelFileWriter != null) {
                            logChannelFileWriter.stopLogging();
                        }
                    });
                }
                catch (HopException e) {
                    this.logError(Const.getStackTracker((Throwable)e));
                }
            }
            this.getPipelineMap().addPipeline(pipelineMeta.getName(), serverObjectId, pipeline, pipelineConfiguration);
            pipeline.setContainerId(serverObjectId);
            String message = "Pipeline '" + pipeline.getPipelineMeta().getName() + "' was added to HopServer with id " + serverObjectId;
            if (useXML) {
                out.println(new WebResult("OK", message, serverObjectId));
            } else {
                out.println("<H1>" + message + "</H1>");
                out.println("<p><a href=\"" + this.convertContextPath("/hop/pipelineStatus") + "?name=" + pipeline.getPipelineMeta().getName() + "&id=" + serverObjectId + "\">Go to the pipeline status page</a><p>");
            }
        }
        catch (Exception ex) {
            if (useXML) {
                out.println(new WebResult("ERROR", Const.getStackTracker((Throwable)ex)));
            }
            out.println("<p>");
            out.println("<pre>");
            ex.printStackTrace(out);
            out.println("</pre>");
        }
        if (!useXML) {
            out.println("<p>");
            out.println("</BODY>");
            out.println("</HTML>");
        }
    }

    public String toString() {
        return "Add Pipeline";
    }

    @Override
    public String getService() {
        return "/hop/addPipeline (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

