/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.api.internal;

import com.clickhouse.client.api.internal.ClickHouseLZ4InputStream;
import com.clickhouse.client.internal.jpountz.lz4.LZ4Compressor;
import com.clickhouse.data.ClickHouseCityHash;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickHouseLZ4OutputStream
extends OutputStream {
    private static Logger LOG = LoggerFactory.getLogger(ClickHouseLZ4OutputStream.class);
    public static final int UNCOMPRESSED_BUFF_SIZE = 65536;
    private final ByteBuffer inBuffer;
    private final OutputStream out;
    private final LZ4Compressor compressor;
    private byte[] tmpBuffer = new byte[1];
    private final ByteBuffer compressedBuffer;
    private static int HEADER_LEN = 15;

    public ClickHouseLZ4OutputStream(OutputStream out, LZ4Compressor compressor, int bufferSize) {
        LOG.debug("Using compressor {}", (Object)compressor);
        this.inBuffer = ByteBuffer.allocate(bufferSize);
        this.out = out;
        this.compressor = compressor;
        this.compressedBuffer = ByteBuffer.allocate(compressor.maxCompressedLength(this.inBuffer.capacity()) + HEADER_LEN);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.inBuffer.remaining() == 0) {
            this.flush();
        }
        this.inBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (b.length == 1) {
            this.write(b[0]);
        } else {
            this.write(b, 0, b.length);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int remaining;
        if (b == null) {
            throw new NullPointerException("b is null");
        }
        if (off < 0) {
            throw new IndexOutOfBoundsException("off is negative");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        if (off + len > b.length) {
            throw new IndexOutOfBoundsException("off + len is greater than b.length");
        }
        if (len == 0) {
            return;
        }
        int writtenBytes = 0;
        do {
            if (this.inBuffer.remaining() == 0) {
                this.flush();
            }
            remaining = Math.min(len - writtenBytes, this.inBuffer.remaining());
            this.inBuffer.put(b, off + writtenBytes, remaining);
        } while ((writtenBytes += remaining) < len);
    }

    @Override
    public void flush() throws IOException {
        if (this.inBuffer.position() > 0) {
            this.compressedBuffer.clear();
            this.compressedBuffer.put(16, (byte)-126);
            int uncompressedLen = this.inBuffer.position();
            this.inBuffer.flip();
            int compressed = this.compressor.compress(this.inBuffer, 0, uncompressedLen, this.compressedBuffer, 25, this.compressedBuffer.remaining() - 25);
            int compressedSizeWithHeader = compressed + 9;
            ClickHouseLZ4InputStream.setInt32(this.compressedBuffer.array(), 17, compressedSizeWithHeader);
            ClickHouseLZ4InputStream.setInt32(this.compressedBuffer.array(), 21, uncompressedLen);
            long[] hash = ClickHouseCityHash.cityHash128(this.compressedBuffer.array(), 16, compressedSizeWithHeader);
            ClickHouseLZ4OutputStream.setInt64(this.compressedBuffer.array(), 0, hash[0]);
            ClickHouseLZ4OutputStream.setInt64(this.compressedBuffer.array(), 8, hash[1]);
            this.compressedBuffer.flip();
            this.out.write(this.compressedBuffer.array(), 0, compressed + 25);
            this.inBuffer.clear();
        }
    }

    static void setInt64(byte[] bytes, int offset, long value) {
        bytes[offset] = (byte)(0xFFL & value);
        bytes[offset + 1] = (byte)(0xFFL & value >> 8);
        bytes[offset + 2] = (byte)(0xFFL & value >> 16);
        bytes[offset + 3] = (byte)(0xFFL & value >> 24);
        bytes[offset + 4] = (byte)(0xFFL & value >> 32);
        bytes[offset + 5] = (byte)(0xFFL & value >> 40);
        bytes[offset + 6] = (byte)(0xFFL & value >> 48);
        bytes[offset + 7] = (byte)(0xFFL & value >> 56);
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.out.close();
    }
}

