/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cratedbbulkloader;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.CrateDBBulkLoaderData;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.CrateDBBulkLoaderField;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.CrateDBBulkLoaderMeta;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.Scheme;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.BulkImportClient;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.HttpBulkImportResponse;
import org.apache.hop.pipeline.transforms.cratedbbulkloader.http.exceptions.CrateDBHopException;

public class CrateDBBulkLoader
extends BaseTransform<CrateDBBulkLoaderMeta, CrateDBBulkLoaderData> {
    private static final Class<?> PKG = CrateDBBulkLoader.class;
    public static final String TIMESTAMP_CONVERSION_MASK = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_CONVERSION_MASK = "yyyy-MM-dd";
    public static final String NUMBER_CONVERSION_MASK = "#############0.##############";
    private final BulkImportClient bulkImportClient;

    public CrateDBBulkLoader(TransformMeta transformMeta, CrateDBBulkLoaderMeta meta, CrateDBBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
        this.bulkImportClient = new BulkImportClient(((CrateDBBulkLoaderMeta)this.meta).getHttpEndpoint(), ((CrateDBBulkLoaderMeta)this.meta).getHttpLogin(), ((CrateDBBulkLoaderMeta)this.meta).getHttpPassword());
    }

    public boolean init() {
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
                ((CrateDBBulkLoaderData)this.data).databaseMeta = this.getPipelineMeta().findDatabase(((CrateDBBulkLoaderMeta)this.meta).getConnection(), this.variables);
                if (((CrateDBBulkLoaderMeta)this.meta).isStreamToS3Csv() && !((CrateDBBulkLoaderMeta)this.meta).isUseHttpEndpoint()) {
                    String readFromFilename = this.resolve(((CrateDBBulkLoaderMeta)this.meta).getReadFromFilename());
                    String localPath = this.resolve(((CrateDBBulkLoaderMeta)this.meta).getVolumeMapping());
                    ((CrateDBBulkLoaderData)this.data).writer = !StringUtils.isEmpty((CharSequence)localPath) && this.isURIOfScheme(readFromFilename, Scheme.FILE) ? HopVfs.getOutputStream((String)FilenameUtils.concat((String)localPath, (String)this.extractFilename(readFromFilename)), (boolean)false) : HopVfs.getOutputStream((String)readFromFilename, (boolean)false);
                }
                ((CrateDBBulkLoaderData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, ((CrateDBBulkLoaderData)this.data).databaseMeta);
                ((CrateDBBulkLoaderData)this.data).db.connect();
                this.getDbFields();
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"CrateDBBulkLoader.Connection.Connected", (Object[])new Object[]{((CrateDBBulkLoaderData)this.data).db.getDatabaseMeta()}));
                }
                this.initBinaryDataFields();
                ((CrateDBBulkLoaderData)this.data).db.setAutoCommit(false);
                return true;
            }
            catch (HopException e) {
                this.logError("An error occurred initializing this transform: " + e.getMessage());
                this.stopAll();
                this.setErrors(1L);
            }
        }
        return false;
    }

    private boolean isURIOfScheme(String uriStr, Scheme expectedScheme) throws HopException {
        URI uri = null;
        try {
            uri = new URI(uriStr);
            return expectedScheme.name().equalsIgnoreCase(uri.getScheme());
        }
        catch (URISyntaxException e) {
            throw new HopException((Throwable)e);
        }
    }

    private String extractFilename(String uriStr) throws HopException {
        URI uri = null;
        try {
            uri = new URI(uriStr);
            return FilenameUtils.getName((String)uri.getPath());
        }
        catch (URISyntaxException e) {
            throw new HopException((Throwable)e);
        }
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.first && ((CrateDBBulkLoaderMeta)this.meta).isTruncateTable() && !((CrateDBBulkLoaderMeta)this.meta).isOnlyWhenHaveRows()) {
                this.truncateTable();
            }
            if (!this.first) {
                try {
                    ((CrateDBBulkLoaderData)this.data).close();
                    this.closeFile();
                    if (((CrateDBBulkLoaderMeta)this.meta).isUseHttpEndpoint()) {
                        String[] columns = (String[])((CrateDBBulkLoaderMeta)this.meta).getFields().stream().map(CrateDBBulkLoaderField::getDatabaseField).toArray(String[]::new);
                        ((CrateDBBulkLoaderData)this.data).outputRowMeta.getValueMetaList().forEach(v -> this.logBasic(v.toString()));
                        String schema = ((CrateDBBulkLoaderMeta)this.meta).getSchemaName();
                        String table = ((CrateDBBulkLoaderMeta)this.meta).getTableName();
                        this.writeBatchToCrateDB(schema, table, columns);
                    } else {
                        String copyStmt = this.buildCopyStatementSqlString();
                        Connection conn = ((CrateDBBulkLoaderData)this.data).db.getConnection();
                        Statement stmt = conn.createStatement();
                        ResultSet resultSet = stmt.executeQuery(copyStmt);
                        int errorCount = 0;
                        while (resultSet.next()) {
                            String node = resultSet.getString("node");
                            String uri = resultSet.getString("uri");
                            int successCount = resultSet.getInt("success_count");
                            errorCount = resultSet.getInt("error_count");
                            String errors = resultSet.getString("errors");
                            this.logError("Node: " + node + " URI: " + uri + " Success Count: " + successCount + " Error Count: " + errorCount + " Errors: " + errors);
                            this.incrementLinesOutput(successCount);
                            this.incrementLinesRejected(errorCount);
                        }
                        conn.commit();
                        stmt.close();
                        conn.close();
                        if (errorCount > 0) {
                            throw new HopException("Failed to COPY FROM CSV file to CrateDB: " + errorCount + " rows failed");
                        }
                    }
                }
                catch (SQLException sqle) {
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    throw new HopDatabaseException("Error executing COPY statements", (Throwable)sqle);
                }
                catch (IOException ioe) {
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    throw new HopTransformException("Error releasing resources", (Throwable)ioe);
                }
                catch (CrateDBHopException e) {
                    throw new HopException((Throwable)e);
                }
            }
            return false;
        }
        if (this.first) {
            this.first = false;
            if (((CrateDBBulkLoaderMeta)this.meta).isStreamToS3Csv()) {
                ((CrateDBBulkLoaderData)this.data).fieldnrs = new HashMap<String, Integer>();
                ((CrateDBBulkLoaderMeta)this.meta).getFields(((CrateDBBulkLoaderData)this.data).insertRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (!((CrateDBBulkLoaderMeta)this.meta).specifyFields()) {
                    ((CrateDBBulkLoaderData)this.data).insertRowMeta = this.getInputRowMeta().clone();
                    ((CrateDBBulkLoaderData)this.data).selectedRowFieldIndices = new int[((CrateDBBulkLoaderData)this.data).insertRowMeta.size()];
                    try {
                        this.getDbFields();
                    }
                    catch (HopException e) {
                        this.logError("Error getting database fields", e);
                        this.setErrors(1L);
                        this.stopAll();
                        this.setOutputDone();
                        return false;
                    }
                    this.defineAllFieldsMetadataList();
                } else {
                    this.defineSelectedFieldsMetadataList();
                }
            } else if (((CrateDBBulkLoaderMeta)this.meta).isUseHttpEndpoint()) {
                ((CrateDBBulkLoaderData)this.data).fieldnrs = new HashMap<String, Integer>();
                if (((CrateDBBulkLoaderMeta)this.meta).specifyFields()) {
                    this.defineSelectedFieldsMetadataList();
                } else {
                    this.defineAllFieldsMetadataList();
                }
            }
        }
        ((CrateDBBulkLoaderData)this.data).outputRowMeta = this.getInputRowMeta().clone();
        if (!((CrateDBBulkLoaderMeta)this.meta).isUseHttpEndpoint()) {
            if (((CrateDBBulkLoaderMeta)this.meta).isStreamToS3Csv()) {
                this.writeRowToFile(((CrateDBBulkLoaderData)this.data).outputRowMeta, r);
            }
        } else {
            this.appendRowAsJsonLine(((CrateDBBulkLoaderData)this.data).outputRowMeta, r);
            try {
                this.writeIfBatchSizeRecordsAreReached();
            }
            catch (IOException | CrateDBHopException e) {
                throw new HopException((Throwable)e);
            }
        }
        this.putRow(this.getInputRowMeta().clone(), r);
        return true;
    }

    private void incrementLinesRejected(int count) {
        for (int i = 0; i < count; ++i) {
            this.incrementLinesRejected();
        }
    }

    private void incrementLinesOutput(int count) {
        for (int i = 0; i < count; ++i) {
            this.incrementLinesOutput();
        }
    }

    private void defineAllFieldsMetadataList() throws HopException {
        ((CrateDBBulkLoaderData)this.data).insertRowMeta = new RowMeta();
        for (int i = 0; i < ((CrateDBBulkLoaderMeta)this.meta).getFields().size(); ++i) {
            int streamFieldLocation = ((CrateDBBulkLoaderData)this.data).insertRowMeta.indexOfValue(((CrateDBBulkLoaderMeta)this.meta).getFields().get(i).getStreamField());
            if (streamFieldLocation < 0) {
                throw new HopTransformException("Field [" + ((CrateDBBulkLoaderMeta)this.meta).getFields().get(i).getStreamField() + "] couldn't be found in the input stream!");
            }
            ((CrateDBBulkLoaderData)this.data).selectedRowFieldIndices[i] = streamFieldLocation;
            int dbFieldLocation = -1;
            for (int e = 0; e < ((CrateDBBulkLoaderData)this.data).dbFields.size(); ++e) {
                String[] field = ((CrateDBBulkLoaderData)this.data).dbFields.get(e);
                if (!field[0].equalsIgnoreCase(((CrateDBBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField())) continue;
                dbFieldLocation = e;
                break;
            }
            if (dbFieldLocation < 0) {
                throw new HopException("Field [" + ((CrateDBBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField() + "] couldn't be found in the table!");
            }
            IValueMeta inputValueMeta = this.getInputRowMeta().getValueMeta(streamFieldLocation);
            IValueMeta insertValueMeta = inputValueMeta.clone();
            insertValueMeta.setName(((CrateDBBulkLoaderData)this.data).dbFields.get(dbFieldLocation)[0]);
            ((CrateDBBulkLoaderData)this.data).insertRowMeta.addValueMeta(insertValueMeta);
            ((CrateDBBulkLoaderData)this.data).fieldnrs.put(((CrateDBBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField().toUpperCase(), streamFieldLocation);
        }
    }

    private void defineSelectedFieldsMetadataList() throws HopTransformException {
        int numberOfInsertFields = ((CrateDBBulkLoaderMeta)this.meta).getFields().size();
        ((CrateDBBulkLoaderData)this.data).insertRowMeta = new RowMeta();
        ((CrateDBBulkLoaderData)this.data).selectedRowFieldIndices = new int[numberOfInsertFields];
        for (int i = 0; i < ((CrateDBBulkLoaderMeta)this.meta).getFields().size(); ++i) {
            CrateDBBulkLoaderField vbf = ((CrateDBBulkLoaderMeta)this.meta).getFields().get(i);
            String inputFieldName = vbf.getStreamField();
            int inputFieldIdx = this.getInputRowMeta().indexOfValue(inputFieldName);
            if (inputFieldIdx < 0) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CrateDBBulkLoader.Exception.FieldRequired", (String[])new String[]{inputFieldName}));
            }
            ((CrateDBBulkLoaderData)this.data).selectedRowFieldIndices[i] = inputFieldIdx;
            String insertFieldName = vbf.getDatabaseField();
            IValueMeta inputValueMeta = this.getInputRowMeta().getValueMeta(inputFieldIdx);
            if (inputValueMeta == null) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"CrateDBBulkLoader.Exception.FailedToFindField", (String[])new String[]{vbf.getStreamField()}));
            }
            IValueMeta insertValueMeta = inputValueMeta.clone();
            insertValueMeta.setName(insertFieldName);
            ((CrateDBBulkLoaderData)this.data).insertRowMeta.addValueMeta(insertValueMeta);
            ((CrateDBBulkLoaderData)this.data).fieldnrs.put(((CrateDBBulkLoaderMeta)this.meta).getFields().get(i).getDatabaseField().toUpperCase(), inputFieldIdx);
        }
    }

    private void writeIfBatchSizeRecordsAreReached() throws HopException, CrateDBHopException, IOException {
        int maxBatchSize = Integer.parseInt(((CrateDBBulkLoaderMeta)this.meta).getBatchSize());
        if (((CrateDBBulkLoaderData)this.data).httpBulkArgs.size() >= maxBatchSize) {
            String[] columns = (String[])((CrateDBBulkLoaderMeta)this.meta).getFields().stream().map(CrateDBBulkLoaderField::getDatabaseField).toArray(String[]::new);
            String schema = ((CrateDBBulkLoaderMeta)this.meta).getSchemaName();
            String table = ((CrateDBBulkLoaderMeta)this.meta).getTableName();
            this.writeBatchToCrateDB(schema, table, columns);
        }
    }

    private void writeBatchToCrateDB(String schema, String table, String[] columns) throws HopException, CrateDBHopException, IOException {
        try {
            HttpBulkImportResponse httpResponse = this.bulkImportClient.batchInsert(schema, table, columns, ((CrateDBBulkLoaderData)this.data).httpBulkArgs);
            int i = 0;
            while ((long)i < httpResponse.outputRows()) {
                this.incrementLinesOutput();
                ++i;
            }
            i = 0;
            while ((long)i < httpResponse.rejectedRows()) {
                this.incrementLinesRejected();
                ++i;
            }
            switch (httpResponse.statusCode()) {
                case 200: {
                    ((CrateDBBulkLoaderData)this.data).httpBulkArgs.clear();
                    break;
                }
                case 401: {
                    throw new HopException("Unauthorized access to CrateDB");
                }
                default: {
                    throw new HopException("Error sending bulk import request");
                }
            }
            if (200 != httpResponse.statusCode()) {
                throw new HopException("Error sending bulk import request");
            }
            ((CrateDBBulkLoaderData)this.data).httpBulkArgs.clear();
        }
        catch (JsonProcessingException e) {
            throw new HopException("Error sending bulk import request ", (Throwable)e);
        }
    }

    private void appendRowAsJsonLine(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        Object[] args = new Object[rowMeta.size()];
        try {
            for (int i = 0; i < ((CrateDBBulkLoaderData)this.data).insertRowMeta.size(); ++i) {
                IValueMeta v = ((CrateDBBulkLoaderData)this.data).insertRowMeta.getValueMeta(i);
                args[i] = this.convertDatatypeIfNeeded(v, row[((CrateDBBulkLoaderData)this.data).selectedRowFieldIndices[i]], i);
            }
            ((CrateDBBulkLoaderData)this.data).convertedRowMetaReady = true;
            ((CrateDBBulkLoaderData)this.data).httpBulkArgs.add(args);
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing JSON line to file", (Throwable)e);
        }
    }

    private String convertDatatypeIfNeeded(IValueMeta v, Object rowItem, int pos) throws HopException {
        ValueMetaString vc = null;
        String convertedValue = null;
        if (!((CrateDBBulkLoaderData)this.data).convertedRowMetaReady && ((CrateDBBulkLoaderData)this.data).convertedRowMeta == null) {
            ((CrateDBBulkLoaderData)this.data).convertedRowMeta = ((CrateDBBulkLoaderData)this.data).insertRowMeta.clone();
        }
        if (rowItem != null) {
            switch (v.getType()) {
                case 2: {
                    convertedValue = (String)rowItem;
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    convertedValue = String.valueOf(rowItem);
                    break;
                }
                case 9: {
                    vc = new ValueMetaString();
                    vc.setName(v.getName());
                    v.setConversionMask(TIMESTAMP_CONVERSION_MASK);
                    vc.setConversionMask(TIMESTAMP_CONVERSION_MASK);
                    convertedValue = (String)vc.convertData(v, rowItem);
                    break;
                }
                case 3: {
                    vc = new ValueMetaString();
                    vc.setName(v.getName());
                    v.setConversionMask(DATE_CONVERSION_MASK);
                    vc.setConversionMask(DATE_CONVERSION_MASK);
                    convertedValue = (String)vc.convertData(v, rowItem);
                    break;
                }
                default: {
                    convertedValue = String.valueOf(rowItem);
                }
            }
        }
        this.logDetailed("Field: " + v.getName() + " - Converted Value: " + convertedValue);
        if (vc != null && !((CrateDBBulkLoaderData)this.data).convertedRowMetaReady) {
            ((CrateDBBulkLoaderData)this.data).convertedRowMeta.setValueMeta(pos, (IValueMeta)vc);
        }
        return convertedValue;
    }

    private boolean closeFile() {
        boolean returnValue = false;
        try {
            if (((CrateDBBulkLoaderData)this.data).writer != null) {
                ((CrateDBBulkLoaderData)this.data).writer.flush();
                ((CrateDBBulkLoaderData)this.data).writer.close();
            }
            ((CrateDBBulkLoaderData)this.data).writer = null;
            if (this.isDebug()) {
                this.logDebug("Closing normal file ...");
            }
            returnValue = true;
        }
        catch (Exception e) {
            this.logError("Exception trying to close file: " + e.toString());
            this.setErrors(1L);
            returnValue = false;
        }
        return returnValue;
    }

    private String buildCopyStatementSqlString() {
        DatabaseMeta databaseMeta = ((CrateDBBulkLoaderData)this.data).db.getDatabaseMeta();
        StringBuilder sb = new StringBuilder(150);
        sb.append("COPY ");
        sb.append(databaseMeta.getQuotedSchemaTableCombination(this.variables, ((CrateDBBulkLoaderData)this.data).db.resolve(((CrateDBBulkLoaderMeta)this.meta).getSchemaName()), ((CrateDBBulkLoaderData)this.data).db.resolve(((CrateDBBulkLoaderMeta)this.meta).getTableName())));
        sb.append(" (");
        List<CrateDBBulkLoaderField> fieldList = ((CrateDBBulkLoaderMeta)this.meta).getFields();
        for (int i = 0; i < fieldList.size(); ++i) {
            CrateDBBulkLoaderField field = fieldList.get(i);
            if (i > 0) {
                sb.append(", " + field.getDatabaseField());
                continue;
            }
            sb.append(field.getDatabaseField());
        }
        sb.append(")");
        String awsAccessKeyId = "";
        String awsSecretAccessKey = "";
        if (((CrateDBBulkLoaderMeta)this.meta).isUseSystemEnvVars()) {
            awsAccessKeyId = System.getenv("AWS_ACCESS_KEY_ID");
            awsSecretAccessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        } else {
            awsAccessKeyId = this.resolve(((CrateDBBulkLoaderMeta)this.meta).getAwsAccessKeyId());
            awsSecretAccessKey = this.resolve(((CrateDBBulkLoaderMeta)this.meta).getAwsSecretAccessKey());
        }
        Object filename = this.resolve(((CrateDBBulkLoaderMeta)this.meta).getReadFromFilename());
        String[] parts = ((String)filename).split("://", 2);
        String uriLeft = parts[0];
        String uriRight = parts[1];
        String awsSec = awsAccessKeyId + ":" + awsSecretAccessKey;
        filename = "s3".equals(uriLeft) ? (":".equals(awsSec) ? uriLeft + "://" + uriRight : uriLeft + "://" + awsSec + "@" + uriRight) : uriLeft + "://" + uriRight;
        sb.append(" FROM '" + (String)filename + "'");
        sb.append(" WITH (format='csv', wait_for_completion=true");
        sb.append(", header=false");
        sb.append(", delimiter=','");
        sb.append(")");
        sb.append(" RETURN SUMMARY");
        this.logDetailed("Copy stmt: " + sb.toString());
        return sb.toString();
    }

    private void getDbFields() throws HopException {
        ((CrateDBBulkLoaderData)this.data).dbFields = new ArrayList();
        IRowMeta rowMeta = null;
        rowMeta = !StringUtils.isEmpty((CharSequence)this.resolve(((CrateDBBulkLoaderMeta)this.meta).getSchemaName())) ? ((CrateDBBulkLoaderData)this.data).db.getTableFields(((CrateDBBulkLoaderMeta)this.meta).getSchemaName() + "." + ((CrateDBBulkLoaderMeta)this.meta).getTableName()) : ((CrateDBBulkLoaderData)this.data).db.getTableFields(((CrateDBBulkLoaderMeta)this.meta).getTableName());
        try {
            if (rowMeta.size() == 0) {
                throw new HopException("No fields found in table");
            }
            for (int i = 0; i < rowMeta.size(); ++i) {
                String[] field = new String[]{rowMeta.getValueMeta(i).getName().toUpperCase(), rowMeta.getValueMeta(i).getTypeDesc().toUpperCase()};
                ((CrateDBBulkLoaderData)this.data).dbFields.add(field);
            }
        }
        catch (Exception ex) {
            throw new HopException("Error getting database fields", (Throwable)ex);
        }
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((CrateDBBulkLoaderMeta)this.meta).getConnection() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"CrateDBBulkLoaderMeta.Error.NoConnection", (String[])new String[0]));
        }
    }

    private void initBinaryDataFields() throws HopException {
        try {
            ((CrateDBBulkLoaderData)this.data).binarySeparator = new byte[0];
            ((CrateDBBulkLoaderData)this.data).binaryEnclosure = new byte[0];
            ((CrateDBBulkLoaderData)this.data).binaryNewline = new byte[0];
            ((CrateDBBulkLoaderData)this.data).escapeCharacters = new byte[0];
            ((CrateDBBulkLoaderData)this.data).binarySeparator = this.resolve(",").getBytes(StandardCharsets.UTF_8);
            ((CrateDBBulkLoaderData)this.data).binaryEnclosure = this.resolve("\"").getBytes(StandardCharsets.UTF_8);
            ((CrateDBBulkLoaderData)this.data).binaryNewline = "\n".getBytes(StandardCharsets.UTF_8);
            ((CrateDBBulkLoaderData)this.data).escapeCharacters = "\"".getBytes(StandardCharsets.UTF_8);
            ((CrateDBBulkLoaderData)this.data).binaryNullValue = "".getBytes(StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new HopException("Unexpected error while encoding binary fields", (Throwable)e);
        }
    }

    private void writeRowToFile(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        try {
            for (int i = 0; i < ((CrateDBBulkLoaderData)this.data).insertRowMeta.size(); ++i) {
                if (i > 0 && ((CrateDBBulkLoaderData)this.data).binarySeparator.length > 0) {
                    ((CrateDBBulkLoaderData)this.data).writer.write(((CrateDBBulkLoaderData)this.data).binarySeparator);
                }
                String convertedValue = null;
                IValueMeta v = ((CrateDBBulkLoaderData)this.data).insertRowMeta.getValueMeta(i);
                convertedValue = this.convertDatatypeIfNeeded(v, row[((CrateDBBulkLoaderData)this.data).selectedRowFieldIndices[i]], i);
                this.writeField(((CrateDBBulkLoaderData)this.data).convertedRowMeta.getValueMeta(i), convertedValue, !((CrateDBBulkLoaderMeta)this.meta).isSpecifyFields() ? null : ((CrateDBBulkLoaderData)this.data).binaryNullValue);
            }
            ((CrateDBBulkLoaderData)this.data).convertedRowMetaReady = true;
            ((CrateDBBulkLoaderData)this.data).writer.write(((CrateDBBulkLoaderData)this.data).binaryNewline);
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing line", (Throwable)e);
        }
    }

    private void writeField(IValueMeta v, Object valueData, byte[] nullString) throws HopTransformException {
        try {
            byte[] str = nullString != null && v.isNull(valueData) ? nullString : this.formatField(v, valueData);
            if (str != null && str.length > 0) {
                List<Integer> enclosures = null;
                boolean writeEnclosures = false;
                if (v.isString()) {
                    writeEnclosures = true;
                    if (this.containsSeparatorOrEnclosure(str, ((CrateDBBulkLoaderData)this.data).binarySeparator, ((CrateDBBulkLoaderData)this.data).binaryEnclosure, ((CrateDBBulkLoaderData)this.data).escapeCharacters)) {
                        writeEnclosures = true;
                    }
                }
                if (writeEnclosures) {
                    ((CrateDBBulkLoaderData)this.data).writer.write(((CrateDBBulkLoaderData)this.data).binaryEnclosure);
                    enclosures = this.getEnclosurePositions(str);
                }
                if (enclosures == null) {
                    ((CrateDBBulkLoaderData)this.data).writer.write(str);
                } else {
                    int from = 0;
                    for (Integer enclosure : enclosures) {
                        int position = enclosure;
                        ((CrateDBBulkLoaderData)this.data).writer.write(str, from, position - from);
                        ((CrateDBBulkLoaderData)this.data).writer.write(((CrateDBBulkLoaderData)this.data).escapeCharacters);
                        from = position;
                    }
                    if (from < str.length) {
                        ((CrateDBBulkLoaderData)this.data).writer.write(str, from, str.length - from);
                    }
                }
                if (writeEnclosures) {
                    ((CrateDBBulkLoaderData)this.data).writer.write(((CrateDBBulkLoaderData)this.data).binaryEnclosure);
                }
            }
        }
        catch (Exception e) {
            throw new HopTransformException("Error writing field content to file", (Throwable)e);
        }
    }

    private byte[] formatField(IValueMeta v, Object valueData) throws HopValueException {
        if (v.isString()) {
            String string;
            if (v.isStorageBinaryString() && v.getTrimType() == 0 && v.getLength() < 0 && StringUtils.isEmpty((CharSequence)v.getStringEncoding())) {
                return (byte[])valueData;
            }
            String svalue = valueData instanceof String ? (string = (String)valueData) : v.getString(valueData);
            return this.convertStringToBinaryString(v, Const.trimToType((String)svalue, (int)v.getTrimType()));
        }
        return v.getBinaryString(valueData);
    }

    private byte[] convertStringToBinaryString(IValueMeta v, String string) {
        int length = v.getLength();
        if (string == null) {
            return new byte[0];
        }
        if (length > -1 && length < string.length()) {
            String tmp = string.substring(0, length);
            return tmp.getBytes(StandardCharsets.UTF_8);
        }
        byte[] text = string.getBytes(StandardCharsets.UTF_8);
        if (length > string.length()) {
            int size = 0;
            byte[] filler = " ".getBytes(StandardCharsets.UTF_8);
            size = text.length + filler.length * (length - string.length());
            byte[] bytes = new byte[size];
            System.arraycopy(text, 0, bytes, 0, text.length);
            if (filler.length == 1) {
                Arrays.fill(bytes, text.length, size, filler[0]);
            } else {
                int currIndex = text.length;
                for (int i = 0; i < length - string.length(); ++i) {
                    for (byte aFiller : filler) {
                        bytes[currIndex++] = aFiller;
                    }
                }
            }
            return bytes;
        }
        return text;
    }

    private boolean containsSeparatorOrEnclosure(byte[] source, byte[] separator, byte[] enclosure, byte[] escape) {
        boolean escapeExists;
        boolean result = false;
        boolean enclosureExists = enclosure != null && enclosure.length > 0;
        boolean separatorExists = separator != null && separator.length > 0;
        boolean bl = escapeExists = escape != null && escape.length > 0;
        if (separatorExists || enclosureExists || escapeExists) {
            block0: for (int index = 0; !result && index < source.length; ++index) {
                int i;
                if (enclosureExists && source[index] == enclosure[0]) {
                    if (index + enclosure.length > source.length) continue;
                    result = true;
                    for (i = 1; i < enclosure.length; ++i) {
                        if (source[index + i] == enclosure[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (separatorExists && source[index] == separator[0]) {
                    if (index + separator.length > source.length) continue;
                    result = true;
                    for (i = 1; i < separator.length; ++i) {
                        if (source[index + i] == separator[i]) continue;
                        result = false;
                        continue block0;
                    }
                    continue;
                }
                if (!escapeExists || source[index] != escape[0] || index + escape.length > source.length) continue;
                result = true;
                for (i = 1; i < escape.length; ++i) {
                    if (source[index + i] == escape[i]) continue;
                    result = false;
                    continue block0;
                }
            }
        }
        return result;
    }

    private List<Integer> getEnclosurePositions(byte[] str) {
        ArrayList<Integer> positions = null;
        int len = str.length;
        for (int i = 0; i < len; ++i) {
            int x;
            boolean found = true;
            for (x = 0; found && x < ((CrateDBBulkLoaderData)this.data).binaryEnclosure.length; ++x) {
                if (str[i + x] == ((CrateDBBulkLoaderData)this.data).binaryEnclosure[x]) continue;
                found = false;
            }
            if (!found) {
                found = true;
                for (x = 0; found && x < ((CrateDBBulkLoaderData)this.data).escapeCharacters.length; ++x) {
                    if (str[i + x] == ((CrateDBBulkLoaderData)this.data).escapeCharacters[x]) continue;
                    found = false;
                }
            }
            if (!found) continue;
            if (positions == null) {
                positions = new ArrayList<Integer>();
            }
            positions.add(i);
        }
        return positions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() throws HopException {
        this.setStopped(true);
        if (((CrateDBBulkLoaderData)this.data).workerThread != null) {
            Thread thread = ((CrateDBBulkLoaderData)this.data).workerThread;
            synchronized (thread) {
                if (((CrateDBBulkLoaderData)this.data).workerThread.isAlive() && !((CrateDBBulkLoaderData)this.data).workerThread.isInterrupted()) {
                    try {
                        ((CrateDBBulkLoaderData)this.data).workerThread.interrupt();
                        ((CrateDBBulkLoaderData)this.data).workerThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        super.stopRunning();
    }

    void truncateTable() throws HopDatabaseException {
        if (((CrateDBBulkLoaderMeta)this.meta).isTruncateTable() && (this.getCopy() == 0 || !Utils.isEmpty((CharSequence)this.getPartitionId()))) {
            ((CrateDBBulkLoaderData)this.data).db.truncateTable(this.resolve(((CrateDBBulkLoaderMeta)this.meta).getSchemaName()), this.resolve(((CrateDBBulkLoaderMeta)this.meta).getTableName()));
        }
    }

    public void dispose() {
        this.setOutputDone();
        try {
            if (this.getErrors() > 0L) {
                ((CrateDBBulkLoaderData)this.data).db.rollback();
            }
        }
        catch (HopDatabaseException e) {
            this.logError("Unexpected error rolling back the database connection.", e);
        }
        if (((CrateDBBulkLoaderData)this.data).workerThread != null) {
            try {
                ((CrateDBBulkLoaderData)this.data).workerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (((CrateDBBulkLoaderData)this.data).db != null) {
            ((CrateDBBulkLoaderData)this.data).db.disconnect();
        }
        super.dispose();
    }
}

