/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.mysqlbulkloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaDate;
import org.apache.hop.core.row.value.ValueMetaNumber;
import org.apache.hop.core.util.StreamLogger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.mysqlbulkloader.MySqlBulkLoaderData;
import org.apache.hop.pipeline.transforms.mysqlbulkloader.MySqlBulkLoaderMeta;

public class MySqlBulkLoader
extends BaseTransform<MySqlBulkLoaderMeta, MySqlBulkLoaderData> {
    private static final Class<?> PKG = MySqlBulkLoaderMeta.class;
    public static final String MESSAGE_ERRORSERIALIZING = "MySqlBulkLoader.Message.ERRORSERIALIZING";
    private static final long THREAD_WAIT_TIME = 300000L;
    private static final String THREAD_WAIT_TIME_TEXT = "5min";

    public MySqlBulkLoader(TransformMeta transformMeta, MySqlBulkLoaderMeta meta, MySqlBulkLoaderData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean execute(MySqlBulkLoaderMeta meta) throws HopException {
        Runtime rt = Runtime.getRuntime();
        try {
            ((MySqlBulkLoaderData)this.data).fifoFilename = this.resolve(meta.getFifoFileName());
            File fifoFile = new File(((MySqlBulkLoaderData)this.data).fifoFilename);
            if (!fifoFile.exists()) {
                String mkFifoCmd = "mkfifo " + ((MySqlBulkLoaderData)this.data).fifoFilename;
                this.logBasic(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.CREATINGFIFO", (String[])new String[]{((MySqlBulkLoaderData)this.data).dbDescription, mkFifoCmd}));
                Process mkFifoProcess = rt.exec(mkFifoCmd);
                StreamLogger errorLogger = new StreamLogger(this.getLogChannel(), mkFifoProcess.getErrorStream(), "mkFifoError");
                StreamLogger outputLogger = new StreamLogger(this.getLogChannel(), mkFifoProcess.getInputStream(), "mkFifoOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                int result = mkFifoProcess.waitFor();
                if (result != 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.ERRORFIFORC", (Object[])new Object[]{result, mkFifoCmd}));
                }
                String chmodCmd = "chmod 666 " + ((MySqlBulkLoaderData)this.data).fifoFilename;
                this.logBasic(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.SETTINGPERMISSIONSFIFO", (String[])new String[]{((MySqlBulkLoaderData)this.data).dbDescription, chmodCmd}));
                Process chmodProcess = rt.exec(chmodCmd);
                errorLogger = new StreamLogger(this.getLogChannel(), chmodProcess.getErrorStream(), "chmodError");
                outputLogger = new StreamLogger(this.getLogChannel(), chmodProcess.getInputStream(), "chmodOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                result = chmodProcess.waitFor();
                if (result != 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.ERRORFIFORC", (Object[])new Object[]{result, chmodCmd}));
                }
            }
            if (meta.getConnection() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            ((MySqlBulkLoaderData)this.data).db = new Database((ILoggingObject)this, this.variables, this.getPipelineMeta().findDatabase(meta.getConnection(), this.variables));
            ((MySqlBulkLoaderData)this.data).db.connect();
            this.logBasic(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.CONNECTED", (String[])new String[]{((MySqlBulkLoaderData)this.data).dbDescription}));
            this.executeLoadCommand();
        }
        catch (Exception ex) {
            throw new HopException((Throwable)ex);
        }
        return true;
    }

    private void executeLoadCommand() throws Exception {
        String delStr;
        StringBuilder loadCommand = new StringBuilder();
        loadCommand.append("LOAD DATA " + (((MySqlBulkLoaderMeta)this.meta).isLocalFile() ? "LOCAL" : "") + " INFILE '" + this.resolve(((MySqlBulkLoaderMeta)this.meta).getFifoFileName()) + "' ");
        if (((MySqlBulkLoaderMeta)this.meta).isReplacingData()) {
            loadCommand.append("REPLACE ");
        } else if (((MySqlBulkLoaderMeta)this.meta).isIgnoringErrors()) {
            loadCommand.append("IGNORE ");
        }
        loadCommand.append("INTO TABLE " + ((MySqlBulkLoaderData)this.data).schemaTable + " ");
        if (!Utils.isEmpty((CharSequence)this.resolve(((MySqlBulkLoaderMeta)this.meta).getLoadCharSet()))) {
            loadCommand.append("CHARACTER SET " + this.resolve(((MySqlBulkLoaderMeta)this.meta).getLoadCharSet()) + " ");
        }
        if ("\t".equals(delStr = ((MySqlBulkLoaderMeta)this.meta).getDelimiter())) {
            delStr = "\\t";
        }
        loadCommand.append("FIELDS TERMINATED BY '" + delStr + "' ");
        if (!Utils.isEmpty((CharSequence)((MySqlBulkLoaderMeta)this.meta).getEnclosure())) {
            loadCommand.append("OPTIONALLY ENCLOSED BY '" + ((MySqlBulkLoaderMeta)this.meta).getEnclosure() + "' ");
        }
        loadCommand.append("ESCAPED BY '" + ((MySqlBulkLoaderMeta)this.meta).getEscapeChar() + ("\\".equals(((MySqlBulkLoaderMeta)this.meta).getEscapeChar()) ? ((MySqlBulkLoaderMeta)this.meta).getEscapeChar() : "") + "' ");
        loadCommand.append("(");
        for (int cnt = 0; cnt < ((MySqlBulkLoaderMeta)this.meta).getFields().size(); ++cnt) {
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((MySqlBulkLoaderMeta)this.meta).getConnection(), this.variables);
            loadCommand.append(databaseMeta.quoteField(((MySqlBulkLoaderMeta)this.meta).getFields().get(cnt).getFieldTable()));
            if (cnt >= ((MySqlBulkLoaderMeta)this.meta).getFields().size() - 1) continue;
            loadCommand.append(",");
        }
        loadCommand.append(");" + Const.CR);
        this.logBasic(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.STARTING", (Object[])new Object[]{((MySqlBulkLoaderData)this.data).dbDescription, loadCommand}));
        ((MySqlBulkLoaderData)this.data).sqlRunner = new SqlRunner((MySqlBulkLoaderData)this.data, loadCommand.toString());
        ((MySqlBulkLoaderData)this.data).sqlRunner.start();
        if (!Const.isWindows()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.OPENFIFO", (String[])new String[]{((MySqlBulkLoaderData)this.data).fifoFilename}));
            OpenFifo openFifo = new OpenFifo(((MySqlBulkLoaderData)this.data).fifoFilename, 1000);
            openFifo.start();
            while (true) {
                openFifo.join(200L);
                if (openFifo.getState() == Thread.State.TERMINATED) break;
                try {
                    ((MySqlBulkLoaderData)this.data).sqlRunner.checkExcn();
                }
                catch (Exception e) {
                    new BufferedInputStream(new FileInputStream(((MySqlBulkLoaderData)this.data).fifoFilename)).close();
                    openFifo.join();
                    this.logError(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.ERRORFIFO", (String[])new String[0]));
                    this.logError("");
                    throw e;
                }
                openFifo.checkExcn();
            }
            ((MySqlBulkLoaderData)this.data).fifoStream = openFifo.getFifoStream();
        }
    }

    public boolean processRow() throws HopException {
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                this.closeOutput();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                ((MySqlBulkLoaderData)this.data).keynrs = new int[((MySqlBulkLoaderMeta)this.meta).getFields().size()];
                for (i = 0; i < ((MySqlBulkLoaderData)this.data).keynrs.length; ++i) {
                    ((MySqlBulkLoaderData)this.data).keynrs[i] = this.getInputRowMeta().indexOfValue(((MySqlBulkLoaderMeta)this.meta).getFields().get(i).getFieldStream());
                }
                ((MySqlBulkLoaderData)this.data).bulkFormatMeta = new IValueMeta[((MySqlBulkLoaderData)this.data).keynrs.length];
                for (i = 0; i < ((MySqlBulkLoaderData)this.data).keynrs.length; ++i) {
                    IValueMeta sourceMeta = this.getInputRowMeta().getValueMeta(((MySqlBulkLoaderData)this.data).keynrs[i]);
                    if (sourceMeta.isDate()) {
                        if (MySqlBulkLoaderMeta.getFieldFormatType(((MySqlBulkLoaderMeta)this.meta).getFields().get(i).getFieldFormatType()) == 1) {
                            ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] = ((MySqlBulkLoaderData)this.data).bulkDateMeta.clone();
                        } else if (MySqlBulkLoaderMeta.getFieldFormatType(((MySqlBulkLoaderMeta)this.meta).getFields().get(i).getFieldFormatType()) == 2) {
                            ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] = ((MySqlBulkLoaderData)this.data).bulkTimestampMeta.clone();
                        }
                    } else if (sourceMeta.isNumeric() && MySqlBulkLoaderMeta.getFieldFormatType(((MySqlBulkLoaderMeta)this.meta).getFields().get(i).getFieldFormatType()) == 3) {
                        ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] = ((MySqlBulkLoaderData)this.data).bulkNumberMeta.clone();
                    }
                    if (((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] != null || sourceMeta.isStorageBinaryString()) continue;
                    ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] = sourceMeta.clone();
                }
                this.execute((MySqlBulkLoaderMeta)this.meta);
            }
            if (((MySqlBulkLoaderData)this.data).bulkSize > 0L && this.getLinesOutput() > 0L && this.getLinesOutput() % ((MySqlBulkLoaderData)this.data).bulkSize == 0L) {
                this.closeOutput();
                this.executeLoadCommand();
            }
            this.writeRowToBulk(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Log.ErrorInTransform", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void closeOutput() throws Exception {
        if (((MySqlBulkLoaderData)this.data).fifoStream != null) {
            ((MySqlBulkLoaderData)this.data).fifoStream.close();
            ((MySqlBulkLoaderData)this.data).fifoStream = null;
        }
        if (((MySqlBulkLoaderData)this.data).sqlRunner != null) {
            this.logDebug("Waiting up to 5min for the MySql load command thread to finish processing.");
            ((MySqlBulkLoaderData)this.data).sqlRunner.join(300000L);
            SqlRunner sqlRunner = ((MySqlBulkLoaderData)this.data).sqlRunner;
            ((MySqlBulkLoaderData)this.data).sqlRunner = null;
            sqlRunner.checkExcn();
        }
    }

    private void writeRowToBulk(IRowMeta rowMeta, Object[] r) throws HopException {
        try {
            block15: for (int i = 0; i < ((MySqlBulkLoaderData)this.data).keynrs.length; ++i) {
                if (i > 0) {
                    ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).separator);
                }
                int index = ((MySqlBulkLoaderData)this.data).keynrs[i];
                IValueMeta valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) {
                    ((MySqlBulkLoaderData)this.data).fifoStream.write("NULL".getBytes());
                    continue;
                }
                switch (valueMeta.getType()) {
                    case 2: {
                        ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).quote);
                        if (valueMeta.isStorageBinaryString() && MySqlBulkLoaderMeta.getFieldFormatType(((MySqlBulkLoaderMeta)this.meta).getFields().get(i).getFieldFormatType()) == 0) {
                            ((MySqlBulkLoaderData)this.data).fifoStream.write((byte[])valueData);
                        } else {
                            String string = valueMeta.getString(valueData);
                            if (string != null) {
                                if (MySqlBulkLoaderMeta.getFieldFormatType(((MySqlBulkLoaderMeta)this.meta).getFields().get(i).getFieldFormatType()) == 4) {
                                    string = Const.replace((String)string, (String)((MySqlBulkLoaderMeta)this.meta).getEscapeChar(), (String)(((MySqlBulkLoaderMeta)this.meta).getEscapeChar() + ((MySqlBulkLoaderMeta)this.meta).getEscapeChar()));
                                    string = Const.replace((String)string, (String)((MySqlBulkLoaderMeta)this.meta).getEnclosure(), (String)(((MySqlBulkLoaderMeta)this.meta).getEscapeChar() + ((MySqlBulkLoaderMeta)this.meta).getEnclosure()));
                                }
                                ((MySqlBulkLoaderData)this.data).fifoStream.write(string.getBytes());
                            }
                        }
                        ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).quote);
                        continue block15;
                    }
                    case 5: {
                        if (valueMeta.isStorageBinaryString() && ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] == null) {
                            ((MySqlBulkLoaderData)this.data).fifoStream.write(valueMeta.getBinaryString(valueData));
                            continue block15;
                        }
                        Long integer = valueMeta.getInteger(valueData);
                        if (integer == null) continue block15;
                        ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).bulkFormatMeta[i].getString((Object)integer).getBytes());
                        continue block15;
                    }
                    case 3: {
                        if (valueMeta.isStorageBinaryString() && ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] == null) {
                            ((MySqlBulkLoaderData)this.data).fifoStream.write(valueMeta.getBinaryString(valueData));
                            continue block15;
                        }
                        Date date = valueMeta.getDate(valueData);
                        if (date == null) continue block15;
                        ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).bulkFormatMeta[i].getString((Object)date).getBytes());
                        continue block15;
                    }
                    case 4: {
                        if (valueMeta.isStorageBinaryString() && ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] == null) {
                            ((MySqlBulkLoaderData)this.data).fifoStream.write(valueMeta.getBinaryString(valueData));
                            continue block15;
                        }
                        Boolean b = valueMeta.getBoolean(valueData);
                        if (b == null) continue block15;
                        ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).bulkFormatMeta[i].getString((Object)b).getBytes());
                        continue block15;
                    }
                    case 1: {
                        Double d;
                        if (valueMeta.isStorageBinaryString() && ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] == null) {
                            ((MySqlBulkLoaderData)this.data).fifoStream.write((byte[])valueData);
                            continue block15;
                        }
                        if (this.getLinesWritten() == 0L) {
                            ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i].setConversionMask(null);
                        }
                        if ((d = valueMeta.getNumber(valueData)) == null) continue block15;
                        ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).bulkFormatMeta[i].getString((Object)d).getBytes());
                        continue block15;
                    }
                    case 6: {
                        if (valueMeta.isStorageBinaryString() && ((MySqlBulkLoaderData)this.data).bulkFormatMeta[i] == null) {
                            ((MySqlBulkLoaderData)this.data).fifoStream.write((byte[])valueData);
                            continue block15;
                        }
                        BigDecimal bn = valueMeta.getBigNumber(valueData);
                        if (bn == null) continue block15;
                        ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).bulkFormatMeta[i].getString((Object)bn).getBytes());
                        continue block15;
                    }
                }
            }
            ((MySqlBulkLoaderData)this.data).fifoStream.write(((MySqlBulkLoaderData)this.data).newline);
            if (this.getLinesOutput() % 5000L == 0L) {
                ((MySqlBulkLoaderData)this.data).fifoStream.flush();
            }
        }
        catch (IOException e) {
            try {
                this.logError(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.IOERROR", (String[])new String[]{THREAD_WAIT_TIME_TEXT}));
                try {
                    ((MySqlBulkLoaderData)this.data).sqlRunner.join(300000L);
                }
                catch (InterruptedException index) {
                    // empty catch block
                }
                ((MySqlBulkLoaderData)this.data).sqlRunner.checkExcn();
            }
            catch (Exception loadEx) {
                throw new HopException(BaseMessages.getString(PKG, (String)MESSAGE_ERRORSERIALIZING, (String[])new String[0]), (Throwable)loadEx);
            }
            throw new HopException(BaseMessages.getString(PKG, (String)MESSAGE_ERRORSERIALIZING, (String[])new String[0]), (Throwable)e);
        }
        catch (Exception e2) {
            throw new HopException(BaseMessages.getString(PKG, (String)MESSAGE_ERRORSERIALIZING, (String[])new String[0]), (Throwable)e2);
        }
    }

    protected void verifyDatabaseConnection() throws HopException {
        if (((MySqlBulkLoaderMeta)this.meta).getConnection() == null) {
            throw new HopException(BaseMessages.getString(PKG, (String)"MySqlBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
    }

    public boolean init() {
        if (super.init()) {
            try {
                this.verifyDatabaseConnection();
            }
            catch (HopException ex) {
                this.logError(ex.getMessage());
                return false;
            }
            ((MySqlBulkLoaderData)this.data).quote = Utils.isEmpty((CharSequence)((MySqlBulkLoaderMeta)this.meta).getEnclosure()) ? new byte[0] : this.resolve(((MySqlBulkLoaderMeta)this.meta).getEnclosure()).getBytes();
            ((MySqlBulkLoaderData)this.data).separator = Utils.isEmpty((CharSequence)((MySqlBulkLoaderMeta)this.meta).getDelimiter()) ? "\t".getBytes() : this.resolve(((MySqlBulkLoaderMeta)this.meta).getDelimiter()).getBytes();
            ((MySqlBulkLoaderData)this.data).newline = Const.CR.getBytes();
            String realEncoding = this.resolve(((MySqlBulkLoaderMeta)this.meta).getEncoding());
            ((MySqlBulkLoaderData)this.data).bulkTimestampMeta = new ValueMetaDate("timestampMeta");
            ((MySqlBulkLoaderData)this.data).bulkTimestampMeta.setConversionMask("yyyy-MM-dd HH:mm:ss");
            ((MySqlBulkLoaderData)this.data).bulkTimestampMeta.setStringEncoding(realEncoding);
            ((MySqlBulkLoaderData)this.data).bulkDateMeta = new ValueMetaDate("dateMeta");
            ((MySqlBulkLoaderData)this.data).bulkDateMeta.setConversionMask("yyyy-MM-dd");
            ((MySqlBulkLoaderData)this.data).bulkDateMeta.setStringEncoding(realEncoding);
            ((MySqlBulkLoaderData)this.data).bulkNumberMeta = new ValueMetaNumber("numberMeta");
            ((MySqlBulkLoaderData)this.data).bulkNumberMeta.setConversionMask("#.#");
            ((MySqlBulkLoaderData)this.data).bulkNumberMeta.setGroupingSymbol(",");
            ((MySqlBulkLoaderData)this.data).bulkNumberMeta.setDecimalSymbol(".");
            ((MySqlBulkLoaderData)this.data).bulkNumberMeta.setStringEncoding(realEncoding);
            ((MySqlBulkLoaderData)this.data).bulkSize = Const.toLong((String)this.resolve(((MySqlBulkLoaderMeta)this.meta).getBulkSize()), (long)-1L);
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((MySqlBulkLoaderMeta)this.meta).getConnection(), this.variables);
            ((MySqlBulkLoaderData)this.data).schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, this.resolve(((MySqlBulkLoaderMeta)this.meta).getSchemaName()), this.resolve(((MySqlBulkLoaderMeta)this.meta).getTableName()));
            return true;
        }
        return false;
    }

    public void dispose() {
        try {
            if (((MySqlBulkLoaderData)this.data).fifoStream != null) {
                ((MySqlBulkLoaderData)this.data).fifoStream.close();
            }
            if (((MySqlBulkLoaderData)this.data).sqlRunner != null) {
                ((MySqlBulkLoaderData)this.data).sqlRunner.join();
                ((MySqlBulkLoaderData)this.data).sqlRunner = null;
            }
            if (((MySqlBulkLoaderData)this.data).db != null) {
                ((MySqlBulkLoaderData)this.data).db.disconnect();
                ((MySqlBulkLoaderData)this.data).db = null;
            }
            try {
                if (((MySqlBulkLoaderData)this.data).fifoFilename != null) {
                    new File(((MySqlBulkLoaderData)this.data).fifoFilename).delete();
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.UNABLETODELETE", (String[])new String[]{((MySqlBulkLoaderData)this.data).fifoFilename}), e);
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"MySqlBulkLoader.Message.UNEXPECTEDERRORCLOSING", (String[])new String[0]), e);
        }
        super.dispose();
    }

    static class SqlRunner
    extends Thread {
        private MySqlBulkLoaderData data;
        private String loadCommand;
        private Exception ex;

        SqlRunner(MySqlBulkLoaderData data, String loadCommand) {
            this.data = data;
            this.loadCommand = loadCommand;
        }

        @Override
        public void run() {
            try {
                this.data.db.execStatement(this.loadCommand);
            }
            catch (Exception exception) {
                this.ex = exception;
            }
        }

        void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }

    static class OpenFifo
    extends Thread {
        private BufferedOutputStream fifoStream = null;
        private Exception ex;
        private String fifoName;
        private int size;

        OpenFifo(String fifoName, int size) {
            this.fifoName = fifoName;
            this.size = size;
        }

        @Override
        public void run() {
            try {
                this.fifoStream = new BufferedOutputStream(new FileOutputStream(this.fifoName), this.size);
            }
            catch (Exception exception) {
                this.ex = exception;
            }
        }

        void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        BufferedOutputStream getFifoStream() {
            return this.fifoStream;
        }
    }
}

