/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCodeParameter;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ListUtilities;
import com.ibm.as400.access.ObjectDescription;
import com.ibm.as400.access.ObjectDescriptionEnumeration;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.RequestNotSupportedException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;

public class ObjectList
implements Serializable {
    static final long serialVersionUID = 5L;
    public static final String ALL = "*ALL";
    public static final String ALL_USER = "*ALLUSR";
    public static final String ASP_NAME_ALL = "*";
    public static final String ASP_NAME_SYSBAS = "*SYSBAS";
    public static final String ASP_NAME_CURASPGRP = "*CURASPGRP";
    public static final String ASP_NAME_ALLAVL = "*ALLAVL";
    public static final String ASP_SEARCH_TYPE_ASP = "*ASP";
    public static final String ASP_SEARCH_TYPE_ASPGRP = "*ASPGRP";
    public static final String AUTH_ALL = "*ALL";
    public static final String AUTH_ANY = "*ANY";
    public static final String AUTH_CHANGE = "*CHANGE";
    public static final String AUTH_DATA_ADD = "*ADD";
    public static final String AUTH_DATA_DELETE = "*DLT";
    public static final String AUTH_DATA_EXECUTE = "*EXECUTE";
    public static final String AUTH_DATA_READ = "*READ";
    public static final String AUTH_DATA_UPDATE = "*UPD";
    public static final String AUTH_LIST_MANAGEMENT = "*AUTLMGT";
    public static final String AUTH_OBJECT_ALTER = "*OBJALTER";
    public static final String AUTH_OBJECT_EXISTENCE = "*OBJEXIST";
    public static final String AUTH_OBJECT_MANAGEMENT = "*OBJMGT";
    public static final String AUTH_OBJECT_OPERATIONAL = "*OBJOPR";
    public static final String AUTH_OBJECT_REFERENCE = "*OBJREF";
    public static final String AUTH_USE = "*USE";
    public static final String CURRENT_LIBRARY = "*CURLIB";
    public static final String IBM = "*IBM";
    public static final String LIBRARY_LIST = "*LIBL";
    public static final byte STATUS_ANY = 92;
    public static final String USER_LIBRARY_LIST = "*USRLIBL";
    private static final byte BINARY = -62;
    private static final byte CHAR = -61;
    private static final byte STRUCT = -30;
    private AS400 system_;
    private int length_;
    private int recLen_;
    private byte[] handle_;
    private byte[] handleToClose_;
    private boolean isConnected_;
    private int currentLibAuthKey_ = 0;
    private String[] libAuthKeys_ = new String[10];
    private int currentObjectAuthKey_ = 0;
    private String[] objectAuthKeys_ = new String[11];
    private int currentStatusKey_ = 0;
    private byte[] statusKeys_ = new byte[5];
    private boolean statusSelection_ = true;
    private int currentKey_ = 0;
    private int[] keys_ = new int[1];
    private int currentSortKey_ = 0;
    private int[] sortKeys_ = new int[1];
    private boolean[] sortOrders_ = new boolean[1];
    private String objectName_;
    private String objectLibrary_;
    private String objectType_;
    private String aspDeviceName_;
    private String aspSearchType_ = "*ASP";

    public ObjectList(AS400 system) {
        this(system, "*ALL", "*ALL", "*ALL");
    }

    public ObjectList(AS400 system, String objectLibrary, String objectName, String objectType) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (objectLibrary == null) {
            throw new NullPointerException("objectLibrary");
        }
        if (objectName == null) {
            throw new NullPointerException("objectName");
        }
        if (objectType == null) {
            throw new NullPointerException("objectType");
        }
        this.system_ = system;
        this.objectLibrary_ = QSYSObjectPathName.toQSYSName(objectLibrary);
        this.objectName_ = QSYSObjectPathName.toQSYSName(objectName);
        this.objectType_ = objectType.toUpperCase();
    }

    public ObjectList(AS400 system, String objectLibrary, String objectName, String objectType, String aspDeviceName) {
        if (system == null) {
            throw new NullPointerException("system");
        }
        if (objectLibrary == null) {
            throw new NullPointerException("objectLibrary");
        }
        if (objectName == null) {
            throw new NullPointerException("objectName");
        }
        if (objectType == null) {
            throw new NullPointerException("objectType");
        }
        this.system_ = system;
        this.objectLibrary_ = QSYSObjectPathName.toQSYSName(objectLibrary);
        this.objectName_ = QSYSObjectPathName.toQSYSName(objectName);
        this.objectType_ = objectType.toUpperCase();
        this.aspDeviceName_ = aspDeviceName;
    }

    public void addLibraryAuthorityCriteria(String authority) {
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (!(authority.equals("*ALL") || authority.equals(AUTH_CHANGE) || authority.equals(AUTH_USE) || authority.equals(AUTH_OBJECT_OPERATIONAL) || authority.equals(AUTH_OBJECT_MANAGEMENT) || authority.equals(AUTH_OBJECT_EXISTENCE) || authority.equals(AUTH_OBJECT_ALTER) || authority.equals(AUTH_OBJECT_REFERENCE) || authority.equals(AUTH_DATA_READ) || authority.equals(AUTH_DATA_ADD) || authority.equals(AUTH_DATA_UPDATE) || authority.equals(AUTH_DATA_DELETE) || authority.equals(AUTH_DATA_EXECUTE))) {
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (this.currentLibAuthKey_ >= 10) {
            if (Trace.traceOn_) {
                Trace.log(2, "Too many authorities added to ObjectList.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        this.libAuthKeys_[this.currentLibAuthKey_++] = authority;
        this.resetHandle();
    }

    public void addObjectAttributeToRetrieve(int attribute) {
        if (attribute < 200) {
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        if (attribute == 10000 || attribute == 10001 || attribute == 10002) {
            return;
        }
        for (int i = 0; i < this.currentKey_; ++i) {
            if (this.keys_[i] != attribute) continue;
            return;
        }
        if (this.currentKey_ >= this.keys_.length) {
            int[] temp = this.keys_;
            this.keys_ = new int[temp.length * 2];
            System.arraycopy(temp, 0, this.keys_, 0, temp.length);
        }
        this.keys_[this.currentKey_++] = attribute;
        this.resetHandle();
    }

    public void addObjectAttributeToSortOn(int attribute, boolean sortOrder) {
        if (attribute < 200 || attribute > 9999) {
            throw new ExtendedIllegalArgumentException("attribute", 2);
        }
        this.addObjectAttributeToRetrieve(attribute);
        if (this.currentSortKey_ >= this.sortKeys_.length) {
            int[] temp = this.sortKeys_;
            this.sortKeys_ = new int[temp.length * 2];
            System.arraycopy(temp, 0, this.sortKeys_, 0, temp.length);
            boolean[] tempSort = this.sortOrders_;
            this.sortOrders_ = new boolean[tempSort.length * 2];
            System.arraycopy(tempSort, 0, this.sortOrders_, 0, tempSort.length);
        }
        this.sortKeys_[this.currentSortKey_] = attribute;
        this.sortOrders_[this.currentSortKey_++] = sortOrder;
        this.resetHandle();
    }

    public void addObjectAuthorityCriteria(String authority) {
        if (authority == null) {
            throw new NullPointerException("authority");
        }
        if (!(authority.equals("*ALL") || authority.equals(AUTH_CHANGE) || authority.equals(AUTH_USE) || authority.equals(AUTH_LIST_MANAGEMENT) || authority.equals(AUTH_OBJECT_OPERATIONAL) || authority.equals(AUTH_OBJECT_MANAGEMENT) || authority.equals(AUTH_OBJECT_EXISTENCE) || authority.equals(AUTH_OBJECT_ALTER) || authority.equals(AUTH_OBJECT_REFERENCE) || authority.equals(AUTH_DATA_READ) || authority.equals(AUTH_DATA_ADD) || authority.equals(AUTH_DATA_UPDATE) || authority.equals(AUTH_DATA_DELETE) || authority.equals(AUTH_DATA_EXECUTE) || authority.equals(AUTH_ANY))) {
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (this.currentObjectAuthKey_ >= 11) {
            if (Trace.traceOn_) {
                Trace.log(2, "Too many authorities added to ObjectList.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (authority.equals(AUTH_ANY) && this.currentObjectAuthKey_ != 0) {
            if (Trace.traceOn_) {
                Trace.log(2, "Attempt to add AUTH_ANY auth after other auth was added.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        if (this.currentObjectAuthKey_ > 0 && this.objectAuthKeys_[0].equals(AUTH_ANY)) {
            if (Trace.traceOn_) {
                Trace.log(2, "Attempt to add auth after AUTH_ANY auth was added.");
            }
            throw new ExtendedIllegalArgumentException("authority", 2);
        }
        this.objectAuthKeys_[this.currentObjectAuthKey_++] = authority;
        this.resetHandle();
    }

    public void addObjectSelectionCriteria(byte status) {
        if (status != -63 && status != -60 && status != -45 && status != -41 && status != 92) {
            throw new ExtendedIllegalArgumentException("status", 2);
        }
        if (this.currentStatusKey_ >= 5) {
            if (Trace.traceOn_) {
                Trace.log(2, "Too many statuses specified for ObjectList.");
            }
            throw new ExtendedIllegalArgumentException("status", 2);
        }
        this.statusKeys_[this.currentStatusKey_] = status;
        this.resetHandle();
    }

    public void clearLibraryAuthorityCriteria() {
        this.currentLibAuthKey_ = 0;
        this.libAuthKeys_ = new String[10];
        this.resetHandle();
    }

    public void clearObjectAttributesToRetrieve() {
        this.keys_ = new int[1];
        this.currentKey_ = 0;
        this.resetHandle();
    }

    public void clearObjectAttributesToSortOn() {
        this.currentSortKey_ = 0;
        this.sortKeys_ = new int[1];
        this.sortOrders_ = new boolean[1];
        this.resetHandle();
    }

    public void clearObjectAuthorityCriteria() {
        this.currentObjectAuthKey_ = 0;
        this.objectAuthKeys_ = new String[11];
        this.resetHandle();
    }

    public void clearObjectSelectionCriteria() {
        this.currentStatusKey_ = 0;
        this.statusKeys_ = new byte[5];
        this.statusSelection_ = true;
        this.resetHandle();
    }

    public synchronized void close() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (!this.isConnected_) {
            return;
        }
        if (this.handleToClose_ != null && (this.handle_ == null || this.handle_ == this.handleToClose_)) {
            this.handle_ = this.handleToClose_;
            this.handleToClose_ = null;
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Closing object list with handle: ", this.handle_);
        }
        try {
            ListUtilities.closeList(this.system_, this.handle_);
        }
        finally {
            this.isConnected_ = false;
            this.handle_ = null;
        }
        if (this.handleToClose_ != null) {
            this.handle_ = this.handleToClose_;
            this.handleToClose_ = null;
            this.close();
        }
    }

    private void ensureSelectionKey(int key) {
        for (int i = 0; i < this.currentKey_; ++i) {
            if (this.keys_[i] != key) continue;
            return;
        }
        if (this.keys_.length <= this.currentKey_) {
            int[] temp = this.keys_;
            this.keys_ = new int[temp.length + 1];
            System.arraycopy(temp, 0, this.keys_, 0, temp.length);
        }
        this.keys_[this.currentKey_++] = key;
    }

    private void ensureSortKeyAfter(int indexKey, int key) {
        int found = -1;
        for (int i = 0; i < this.currentSortKey_; ++i) {
            if (this.sortKeys_[i] != indexKey) continue;
            found = i;
            break;
        }
        if (found == -1) {
            return;
        }
        int offset = found + 1;
        if (found < this.currentSortKey_ - 1 && this.sortKeys_[offset] == key) {
            return;
        }
        int[] temp = this.sortKeys_;
        boolean[] tempOrders = this.sortOrders_;
        this.sortKeys_ = new int[temp.length + 1];
        this.sortOrders_ = new boolean[temp.length + 1];
        System.arraycopy(temp, 0, this.sortKeys_, 0, offset);
        System.arraycopy(tempOrders, 0, this.sortOrders_, 0, offset);
        this.sortKeys_[offset] = key;
        this.sortOrders_[offset] = tempOrders[found];
        if (offset < temp.length) {
            System.arraycopy(temp, offset, this.sortKeys_, offset + 1, temp.length - offset);
            System.arraycopy(tempOrders, offset, this.sortOrders_, offset + 1, temp.length - offset);
        }
        ++this.currentSortKey_;
    }

    private void ensureSortKeyBefore(int indexKey, int key) {
        int found = -1;
        for (int i = 0; i < this.currentSortKey_; ++i) {
            if (this.sortKeys_[i] != indexKey) continue;
            found = i;
            break;
        }
        if (found == -1) {
            return;
        }
        if (found > 0 && this.sortKeys_[found - 1] == key) {
            return;
        }
        int[] temp = this.sortKeys_;
        boolean[] tempOrders = this.sortOrders_;
        this.sortKeys_ = new int[temp.length + 1];
        this.sortOrders_ = new boolean[temp.length + 1];
        System.arraycopy(temp, 0, this.sortKeys_, 0, found);
        System.arraycopy(tempOrders, 0, this.sortOrders_, 0, found);
        this.sortKeys_[found] = key;
        this.sortOrders_[found] = tempOrders[found];
        System.arraycopy(temp, found, this.sortKeys_, found + 1, temp.length - found);
        System.arraycopy(tempOrders, found, this.sortOrders_, found + 1, temp.length - found);
        ++this.currentSortKey_;
    }

    private void fixUpKeys() {
        int i;
        block14: for (i = 0; i < this.currentKey_; ++i) {
            switch (this.keys_[i]) {
                case 401: {
                    this.ensureSelectionKey(402);
                    this.ensureSelectionKey(403);
                    continue block14;
                }
                case 509: {
                    this.ensureSelectionKey(510);
                    continue block14;
                }
                case 701: {
                    this.ensureSelectionKey(702);
                    continue block14;
                }
                case 514: {
                    this.ensureSelectionKey(515);
                    continue block14;
                }
                case 503: {
                    this.ensureSelectionKey(504);
                }
            }
        }
        i = 0;
        block15: while (i < this.currentSortKey_) {
            int thisSortKey = this.currentSortKey_;
            for (i = 0; i < this.currentSortKey_; ++i) {
                switch (this.sortKeys_[i]) {
                    case 401: {
                        this.ensureSortKeyBefore(401, 402);
                        this.ensureSortKeyAfter(401, 403);
                        break;
                    }
                    case 509: {
                        this.ensureSortKeyBefore(509, 510);
                        break;
                    }
                    case 701: {
                        this.ensureSortKeyBefore(701, 702);
                        break;
                    }
                    case 514: {
                        this.ensureSortKeyBefore(514, 515);
                        break;
                    }
                    case 503: {
                        this.ensureSortKeyBefore(503, 504);
                    }
                }
                if (thisSortKey == this.currentSortKey_) continue;
                i = 0;
                continue block15;
            }
        }
    }

    public String getAspDeviceName() {
        return this.aspDeviceName_;
    }

    public String getAspSearchType() {
        return this.aspSearchType_;
    }

    public synchronized int getLength() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.handle_ == null) {
            this.load();
        }
        return this.length_;
    }

    public String getLibrary() {
        return this.objectLibrary_;
    }

    public String getName() {
        return this.objectName_;
    }

    public synchronized Enumeration getObjects() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException, RequestNotSupportedException {
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.handle_ == null) {
            this.load();
        }
        return new ObjectDescriptionEnumeration(this, this.length_);
    }

    public synchronized ObjectDescription[] getObjects(int listOffset, int number) throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        if (listOffset < -1) {
            throw new ExtendedIllegalArgumentException("listOffset", 4);
        }
        if (number < 0 && listOffset != -1) {
            throw new ExtendedIllegalArgumentException("number", 4);
        }
        if (this.handle_ == null) {
            this.load();
        }
        if (this.length_ == 0 || number == 0 && listOffset != -1) {
            return new ObjectDescription[0];
        }
        if (listOffset == -1) {
            number = this.length_;
            listOffset = 0;
        } else {
            if (listOffset >= this.length_) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Value of parameter 'listOffset' is beyond end of list:", listOffset + " (list length: " + this.length_ + ")");
                }
                return new ObjectDescription[0];
            }
            if (listOffset + number > this.length_) {
                number = this.length_ - listOffset;
            }
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        int len = number * this.recLen_;
        Object[] listInfoContainer = new Object[1];
        byte[] data = ListUtilities.retrieveListEntries(this.system_, this.handle_, len, number, listOffset, listInfoContainer);
        byte[] listInfo = (byte[])listInfoContainer[0];
        if (listInfo == null || listInfo.length == 0) {
            return new ObjectDescription[0];
        }
        int recordsReturned = BinaryConverter.byteArrayToInt(listInfo, 4);
        int recordLength = BinaryConverter.byteArrayToInt(listInfo, 12);
        ObjectDescription[] objects = new ObjectDescription[recordsReturned];
        int offset = 0;
        for (int i = 0; i < recordsReturned; ++i) {
            String objectName = conv.byteArrayToString(data, offset, 10).trim();
            String objectLibrary = conv.byteArrayToString(data, offset + 10, 10).trim();
            String objectType = conv.byteArrayToString(data, offset + 20, 10).trim().substring(1);
            byte infoStatus = data[offset + 30];
            int numFields = BinaryConverter.byteArrayToInt(data, offset + 32);
            objects[i] = this.aspDeviceName_ != null ? new ObjectDescription(this.system_, objectLibrary, objectName, objectType, infoStatus, this.aspDeviceName_, this.aspSearchType_) : new ObjectDescription(this.system_, objectLibrary, objectName, objectType, infoStatus);
            if (infoStatus != -63 && infoStatus != -45) {
                int fieldOffset = offset + 36;
                for (int j = 0; j < numFields && fieldOffset + 16 < data.length; ++j) {
                    int infoLength = BinaryConverter.byteArrayToInt(data, fieldOffset);
                    int key = BinaryConverter.byteArrayToInt(data, fieldOffset + 4);
                    byte type = data[fieldOffset + 8];
                    int dataLength = BinaryConverter.byteArrayToInt(data, fieldOffset + 12);
                    byte[] keyData = new byte[dataLength];
                    System.arraycopy(data, fieldOffset + 16, keyData, 0, dataLength);
                    Object value = null;
                    if (type == -62) {
                        value = BinaryConverter.byteArrayToInt(keyData, 0);
                        objects[i].set(key, value);
                    } else if (type == -61) {
                        switch (key) {
                            case 304: 
                            case 305: 
                            case 501: 
                            case 502: 
                            case 512: 
                            case 518: 
                            case 601: 
                            case 602: {
                                value = keyData;
                                break;
                            }
                            case 303: 
                            case 307: 
                            case 308: 
                            case 309: 
                            case 311: 
                            case 312: 
                            case 313: 
                            case 404: 
                            case 407: 
                            case 410: 
                            case 507: 
                            case 513: 
                            case 516: 
                            case 517: 
                            case 604: 
                            case 703: {
                                value = conv.byteArrayToString(keyData, 0, keyData.length);
                                break;
                            }
                            default: {
                                value = conv.byteArrayToString(keyData, 0, keyData.length).trim();
                            }
                        }
                        objects[i].set(key, value);
                    } else {
                        Trace.log(2, "Unknown key type for key " + key + ": " + type);
                        throw new InternalErrorException(5, key + ": " + type, null);
                    }
                    fieldOffset += infoLength;
                }
            }
            offset += recordLength;
        }
        return objects;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public String getType() {
        return this.objectType_;
    }

    public synchronized void load() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        ProgramCall pc;
        int i;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.handle_ != null || this.handleToClose_ != null) {
            this.close();
        }
        int ccsid = this.system_.getCcsid();
        ConvTable conv = ConvTable.getTable(ccsid, null);
        AS400Text text10 = new AS400Text(10, ccsid, this.system_);
        ProgramParameter[] parms = new ProgramParameter[this.aspDeviceName_ == null ? 12 : 15];
        parms[0] = new ProgramParameter(1);
        parms[1] = new ProgramParameter(BinaryConverter.intToByteArray(1));
        parms[2] = new ProgramParameter(80);
        parms[3] = new ProgramParameter(BinaryConverter.intToByteArray(-1));
        this.fixUpKeys();
        byte[] sortInfo = null;
        int numSortKeys = this.currentSortKey_;
        if (numSortKeys > 0) {
            sortInfo = new byte[4 + numSortKeys * 12];
            BinaryConverter.intToByteArray(numSortKeys, sortInfo, 0);
            int offset = 4;
            for (int i2 = 0; i2 < numSortKeys; ++i2) {
                int key = this.sortKeys_[i2];
                boolean order = this.sortOrders_[i2];
                int fieldLength = ObjectDescription.keyLengths_.get(key);
                short dataType = 4;
                int fieldStartingPosition = 53;
                switch (key) {
                    case 205: 
                    case 301: 
                    case 304: 
                    case 305: 
                    case 314: 
                    case 501: 
                    case 502: 
                    case 503: 
                    case 504: 
                    case 505: 
                    case 512: 
                    case 518: 
                    case 601: 
                    case 602: 
                    case 603: 
                    case 701: 
                    case 702: {
                        dataType = 0;
                    }
                }
                int j = 0;
                while (this.keys_[j] != key) {
                    fieldStartingPosition += 16 + ObjectDescription.keyLengths_.get(this.keys_[j]);
                    ++j;
                }
                BinaryConverter.intToByteArray(fieldStartingPosition, sortInfo, offset);
                BinaryConverter.intToByteArray(fieldLength, sortInfo, offset += 4);
                BinaryConverter.shortToByteArray(dataType, sortInfo, offset += 4);
                sortInfo[offset += 2] = order ? -15 : -14;
                offset += 2;
            }
        } else {
            sortInfo = new byte[4];
        }
        parms[4] = new ProgramParameter(sortInfo);
        byte[] objectNameAndLibrary = new byte[20];
        text10.toBytes(this.objectName_, objectNameAndLibrary, 0);
        text10.toBytes(this.objectLibrary_, objectNameAndLibrary, 10);
        parms[5] = new ProgramParameter(objectNameAndLibrary);
        parms[6] = new ProgramParameter(text10.toBytes(this.objectType_));
        byte[] authInfo = new byte[28 + (this.currentObjectAuthKey_ + this.currentLibAuthKey_) * 10];
        BinaryConverter.intToByteArray(authInfo.length, authInfo, 0);
        BinaryConverter.intToByteArray(1, authInfo, 4);
        BinaryConverter.intToByteArray(this.currentObjectAuthKey_ == 0 ? 0 : 28, authInfo, 8);
        BinaryConverter.intToByteArray(this.currentObjectAuthKey_, authInfo, 12);
        BinaryConverter.intToByteArray(this.currentLibAuthKey_ == 0 ? 0 : 28 + this.currentObjectAuthKey_ * 10, authInfo, 16);
        BinaryConverter.intToByteArray(this.currentLibAuthKey_, authInfo, 20);
        BinaryConverter.intToByteArray(0, authInfo, 24);
        int offset = 28;
        for (i = 0; i < this.currentObjectAuthKey_; ++i) {
            text10.toBytes(this.objectAuthKeys_[i], authInfo, offset);
            offset += 10;
        }
        for (i = 0; i < this.currentLibAuthKey_; ++i) {
            text10.toBytes(this.libAuthKeys_[i], authInfo, offset);
            offset += 10;
        }
        parms[7] = new ProgramParameter(authInfo);
        int num = this.currentStatusKey_;
        byte[] statuses = this.statusKeys_;
        if (num == 0) {
            num = 1;
            statuses = new byte[]{92};
        }
        byte[] selectionInfo = new byte[20 + num];
        BinaryConverter.intToByteArray(selectionInfo.length, selectionInfo, 0);
        BinaryConverter.intToByteArray(this.statusSelection_ ? 0 : 1, selectionInfo, 4);
        BinaryConverter.intToByteArray(20, selectionInfo, 8);
        BinaryConverter.intToByteArray(num, selectionInfo, 12);
        BinaryConverter.intToByteArray(0, selectionInfo, 16);
        System.arraycopy(statuses, 0, selectionInfo, 20, num);
        parms[8] = new ProgramParameter(selectionInfo);
        parms[9] = new ProgramParameter(BinaryConverter.intToByteArray(this.currentKey_));
        byte[] keyInfo = new byte[this.currentKey_ * 4];
        offset = 0;
        for (int i3 = 0; i3 < this.currentKey_; ++i3) {
            BinaryConverter.intToByteArray(this.keys_[i3], keyInfo, offset);
            offset += 4;
        }
        parms[10] = new ProgramParameter(keyInfo);
        parms[11] = new ErrorCodeParameter();
        if (parms.length == 15) {
            parms[12] = new ProgramParameter(text10.toBytes(ASP_NAME_ALL));
            parms[13] = new ProgramParameter(conv.stringToByteArray("JIDF0000"));
            byte[] controlFormat = new byte[24];
            System.arraycopy(BinaryConverter.intToByteArray(24), 0, controlFormat, 0, 4);
            for (int i4 = 4; i4 < controlFormat.length; ++i4) {
                controlFormat[i4] = 64;
            }
            conv.stringToByteArray(this.aspDeviceName_, controlFormat, 4);
            if (!(this.aspDeviceName_.equals(ASP_NAME_ALL) || this.aspDeviceName_.equals(ASP_NAME_SYSBAS) || this.aspDeviceName_.equals(ASP_NAME_CURASPGRP) || this.aspDeviceName_.equals(ASP_NAME_ALLAVL))) {
                conv.stringToByteArray(this.aspSearchType_, controlFormat, 14);
            }
            parms[14] = new ProgramParameter(controlFormat);
        }
        if (!(pc = new ProgramCall(this.system_, "/QSYS.LIB/QGYOLOBJ.PGM", parms)).run()) {
            throw new AS400Exception(pc.getMessageList());
        }
        this.isConnected_ = true;
        byte[] listInformation = parms[2].getOutputData();
        this.handle_ = new byte[4];
        System.arraycopy(listInformation, 8, this.handle_, 0, 4);
        listInformation = ListUtilities.waitForListToComplete(this.system_, this.handle_, listInformation);
        this.length_ = BinaryConverter.byteArrayToInt(listInformation, 0);
        this.recLen_ = BinaryConverter.byteArrayToInt(listInformation, 12);
        if (this.recLen_ <= 0) {
            Trace.log(2, "invalid record length", this.recLen_);
            throw new InternalErrorException(2, this.recLen_);
        }
        if (Trace.traceOn_) {
            Trace.log(1, "Loaded object list with length = " + this.length_ + " and handle: ", this.handle_);
        }
    }

    private synchronized void resetHandle() {
        if (this.handleToClose_ == null) {
            this.handleToClose_ = this.handle_;
        }
        this.handle_ = null;
    }

    public void setAspSearchType(String aspSearchType) throws ExtendedIllegalArgumentException {
        if (aspSearchType == null) {
            throw new NullPointerException("aspSearchType");
        }
        if (!aspSearchType.equals(ASP_SEARCH_TYPE_ASP) && !aspSearchType.equals(ASP_SEARCH_TYPE_ASPGRP)) {
            throw new ExtendedIllegalArgumentException("aspSearchType", 2);
        }
        this.aspSearchType_ = aspSearchType;
    }

    public void setObjectSelection(boolean select) {
        this.statusSelection_ = select;
        this.resetHandle();
    }

    protected void finalize() throws Throwable {
        if (Trace.traceOn_) {
            Trace.log(1, "Finalize method for object list invoked.");
        }
        if (this.handle_ != null) {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        super.finalize();
    }
}

