/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.laf.BasePropertyHandler;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ShowHelpDialog
extends Dialog {
    private static final Class<?> PKG = HopGui.class;
    private static final String DOC_URL = Const.getDocUrl((String)BasePropertyHandler.getProperty((String)"documentationUrl"));
    private static final String PREFIX = "https://help";
    private static final String PRINT_PREFIX = "https://f1.help";
    private static final String PRINT_SCRIPT = "javascript:window.print();";
    private static final int MARGIN = 5;
    private boolean fromPrint;
    private String dialogTitle = BaseMessages.getString(PKG, (String)"HopGui.Documentation.Hop.Title", (String[])new String[0]);
    private String url;
    private String homeURL;
    private Browser wBrowser;
    private ToolItem tltmBack;
    private ToolItem tltmForward;
    private Text textURL;
    private Shell shell;

    public ShowHelpDialog(Shell parent, String dialogTitle, String url, String header) {
        super(parent, 0);
        this.url = url;
        try {
            this.homeURL = new URL(DOC_URL).toString();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public ShowHelpDialog(Shell parent, String dialogTitle, String url) {
        this(parent, dialogTitle, url, "");
    }

    protected Shell createShell(Shell parent) {
        return new Shell(parent, 3312);
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        PropsUi props = PropsUi.getInstance();
        this.shell = this.createShell(parent);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setText(this.dialogTitle);
        PropsUi.setLook((Widget)this.shell);
        Cursor cursorHand = new Cursor((Device)display, 21);
        ToolBar navigateToolBar = new ToolBar((Composite)this.shell, 0x800000);
        FormData fdtoolBarBack = new FormData();
        fdtoolBarBack.top = new FormAttachment(0, 5);
        fdtoolBarBack.left = new FormAttachment(0, 0);
        navigateToolBar.setLayoutData((Object)fdtoolBarBack);
        navigateToolBar.setCursor(cursorHand);
        navigateToolBar.setBackground(navigateToolBar.getParent().getBackground());
        ToolItem tltmHome = new ToolItem(navigateToolBar, 0);
        tltmHome.setImage(GuiResource.getInstance().getImageHome());
        tltmHome.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Documentation.Tooltip.Home", (String[])new String[0]));
        tltmHome.setEnabled(true);
        tltmHome.addListener(13, e -> this.home());
        if (!EnvironmentUtils.getInstance().isWeb()) {
            this.tltmBack = new ToolItem(navigateToolBar, 0);
            this.tltmBack.setImage(GuiResource.getInstance().getImageNavigateBack());
            this.tltmBack.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Documentation.Tooltip.Back", (String[])new String[0]));
            this.tltmBack.setEnabled(false);
            this.tltmBack.addListener(13, e -> this.back());
            this.tltmForward = new ToolItem(navigateToolBar, 0);
            this.tltmForward.setImage(GuiResource.getInstance().getImageNavigateForward());
            this.tltmForward.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Documentation.Tooltip.Forward", (String[])new String[0]));
            this.tltmForward.setEnabled(false);
            this.tltmForward.addListener(13, e -> this.forward());
        }
        ToolItem tltmRefresh = new ToolItem(navigateToolBar, 0);
        tltmRefresh.setImage(GuiResource.getInstance().getImageRefresh());
        tltmRefresh.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Documentation.Tooltip.Refresh", (String[])new String[0]));
        tltmRefresh.addListener(13, e -> this.refresh());
        ToolBar printToolBar = new ToolBar((Composite)this.shell, 0x800000);
        FormData fdtoolBarPrint = new FormData();
        fdtoolBarPrint.top = new FormAttachment(0, 5);
        fdtoolBarPrint.right = new FormAttachment(100, -5);
        printToolBar.setLayoutData((Object)fdtoolBarPrint);
        printToolBar.setCursor(cursorHand);
        printToolBar.setBackground(printToolBar.getParent().getBackground());
        ToolItem tltmPrint = new ToolItem(printToolBar, 0);
        tltmPrint.setImage(GuiResource.getInstance().getImagePrint());
        tltmPrint.setToolTipText(BaseMessages.getString(PKG, (String)"HopGui.Documentation.Tooltip.Print", (String[])new String[0]));
        tltmPrint.setEnabled(true);
        tltmPrint.addListener(13, e -> this.print());
        this.textURL = new Text((Composite)this.shell, 2048);
        FormData fdtext = new FormData();
        fdtext.top = new FormAttachment(0, 5);
        fdtext.right = new FormAttachment((Control)printToolBar, -5);
        fdtext.left = new FormAttachment((Control)navigateToolBar, 5);
        this.textURL.setLayoutData((Object)fdtext);
        this.textURL.setForeground(new Color((Device)display, props.contrastColor(101, 101, 101)));
        this.wBrowser = new Browser((Composite)this.shell, 0);
        FormData fdBrowser = new FormData();
        fdBrowser.top = new FormAttachment((Control)this.textURL, 5);
        fdBrowser.right = new FormAttachment(100, 0);
        fdBrowser.bottom = new FormAttachment(100, 0);
        fdBrowser.left = new FormAttachment(0, 0);
        this.wBrowser.setLayoutData((Object)fdBrowser);
        this.wBrowser.setUrl(this.url);
        PropsUi.setLook((Widget)this.wBrowser);
        this.addProgressAndLocationListener();
        this.textURL.setFocus();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.ok());
    }

    private void addProgressAndLocationListener() {
        ProgressListener progressListener = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            public void completed(ProgressEvent event) {
                if (ShowHelpDialog.this.fromPrint) {
                    ShowHelpDialog.this.wBrowser.execute(ShowHelpDialog.PRINT_SCRIPT);
                    ShowHelpDialog.this.fromPrint = false;
                }
                if (!EnvironmentUtils.getInstance().isWeb()) {
                    ShowHelpDialog.this.setBackEnable(ShowHelpDialog.this.wBrowser.isBackEnabled());
                    ShowHelpDialog.this.setForwardEnable(ShowHelpDialog.this.wBrowser.isForwardEnabled());
                }
            }
        };
        LocationListener listener = new LocationListener(){

            public void changing(LocationEvent event) {
                if (event.location.endsWith(".pdf")) {
                    try {
                        EnvironmentUtils.getInstance().openUrl(event.location);
                    }
                    catch (Exception e) {
                        new ErrorDialog(ShowHelpDialog.this.shell, "Error", "Error opening URL", e);
                    }
                    event.doit = false;
                }
            }

            public void changed(LocationEvent event) {
                ShowHelpDialog.this.textURL.setText(event.location);
            }
        };
        this.wBrowser.addProgressListener(progressListener);
        this.wBrowser.addLocationListener(listener);
    }

    private void back() {
        this.wBrowser.back();
    }

    private void forward() {
        this.wBrowser.forward();
    }

    private void refresh() {
        this.wBrowser.refresh();
    }

    private void home() {
        this.wBrowser.setUrl(this.homeURL != null ? this.homeURL : this.url);
    }

    private void print() {
        String printURL = this.wBrowser.getUrl();
        if (printURL.startsWith(PREFIX)) {
            printURL = printURL.replace(PREFIX, PRINT_PREFIX);
            this.fromPrint = true;
            this.wBrowser.setUrl(printURL);
        } else {
            this.wBrowser.execute(PRINT_SCRIPT);
        }
    }

    private void setBackEnable(boolean enable) {
        this.tltmBack.setEnabled(enable);
    }

    private void setForwardEnable(boolean enable) {
        this.tltmForward.setEnabled(enable);
    }

    public void dispose() {
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }
}

