/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.variables.resolver;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.resolver.IVariableResolver;
import org.apache.hop.core.variables.resolver.VariableResolver;
import org.apache.hop.core.variables.resolver.VariableResolverPluginType;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.GuiCompositeWidgetsAdapter;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin(description="This is the editor for variable resolver metadata")
public class VariableResolverEditor
extends MetadataEditor<VariableResolver> {
    private static final Class<?> PKG = VariableResolverEditor.class;
    private Text wName;
    private Text wDescription;
    private Combo wResolverType;
    private Composite wResolverSpecificComp;
    private GuiCompositeWidgets guiCompositeWidgets;
    private Map<String, IVariableResolver> metaMap;
    private final PropsUi props;
    private AtomicBoolean busyChangingConnectionType = new AtomicBoolean(false);

    public VariableResolverEditor(HopGui hopGui, MetadataManager<VariableResolver> manager, VariableResolver resolver) {
        super(hopGui, manager, resolver);
        this.props = PropsUi.getInstance();
        this.populateMetaMap();
    }

    @Override
    public void createControl(Composite parent) {
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Label wIcon = new Label(parent, 131072);
        wIcon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wIcon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wIcon);
        Label wlName = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlName);
        wlName.setText(BaseMessages.getString(PKG, (String)"VariableResolverEditor.label.Name", (String[])new String[0]));
        FormData fdlName = new FormData();
        fdlName.top = new FormAttachment(0, 0);
        fdlName.left = new FormAttachment(0, 0);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wName);
        FormData fdName = new FormData();
        fdName.top = new FormAttachment((Control)wlName, margin);
        fdName.left = new FormAttachment(0, 0);
        fdName.right = new FormAttachment((Control)wIcon, -margin);
        this.wName.setLayoutData((Object)fdName);
        Label wlDescription = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlDescription);
        wlDescription.setText(BaseMessages.getString(PKG, (String)"VariableResolverEditor.label.Description", (String[])new String[0]));
        FormData fdlDescription = new FormData();
        fdlDescription.top = new FormAttachment((Control)this.wName, margin);
        fdlDescription.left = new FormAttachment(0, 0);
        wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(parent, 18436);
        PropsUi.setLook((Widget)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.top = new FormAttachment((Control)wlDescription, margin);
        fdDescription.left = new FormAttachment(0, 0);
        fdDescription.right = new FormAttachment((Control)wIcon, -margin);
        this.wDescription.setLayoutData((Object)fdDescription);
        Label spacer = new Label(parent, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wDescription, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label wlResolverType = new Label(parent, 131072);
        PropsUi.setLook((Widget)wlResolverType);
        wlResolverType.setText(BaseMessages.getString(PKG, (String)"VariableResolverEditor.label.ResolverType", (String[])new String[0]));
        FormData fdlConnectionType = new FormData();
        fdlConnectionType.top = new FormAttachment((Control)spacer, margin);
        fdlConnectionType.left = new FormAttachment(0, 0);
        fdlConnectionType.right = new FormAttachment(middle, -margin);
        wlResolverType.setLayoutData((Object)fdlConnectionType);
        ToolBar wToolBar = new ToolBar(parent, 0x800100);
        FormData fdToolBar = new FormData();
        fdToolBar.right = new FormAttachment(100, 0);
        fdToolBar.top = new FormAttachment((Control)spacer, margin);
        wToolBar.setLayoutData((Object)fdToolBar);
        PropsUi.setLook((Widget)wToolBar, 0);
        ToolItem item = new ToolItem(wToolBar, 8);
        item.setImage(GuiResource.getInstance().getImageHelp());
        item.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.Help", (String[])new String[0]));
        item.addListener(13, e -> this.onHelpVariableResolverType());
        this.wResolverType = new Combo(parent, 18436);
        this.wResolverType.setItems(this.getResolverTypes());
        PropsUi.setLook((Widget)this.wResolverType);
        FormData fdConnectionType = new FormData();
        fdConnectionType.top = new FormAttachment((Control)wlResolverType, 0, 0x1000000);
        fdConnectionType.left = new FormAttachment(middle, 0);
        fdConnectionType.right = new FormAttachment((Control)wToolBar, -margin);
        this.wResolverType.setLayoutData((Object)fdConnectionType);
        Combo lastControl = this.wResolverType;
        this.wResolverSpecificComp = new Composite(parent, 8);
        this.wResolverSpecificComp.setLayout((Layout)new FormLayout());
        FormData fdResolverSpecificComp = new FormData();
        fdResolverSpecificComp.left = new FormAttachment(0, 0);
        fdResolverSpecificComp.right = new FormAttachment(100, 0);
        fdResolverSpecificComp.top = new FormAttachment((Control)lastControl, 0);
        fdResolverSpecificComp.bottom = new FormAttachment(100, 0);
        this.wResolverSpecificComp.setLayoutData((Object)fdResolverSpecificComp);
        PropsUi.setLook((Widget)this.wResolverSpecificComp);
        this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.guiCompositeWidgets.createCompositeWidgets(((VariableResolver)this.getMetadata()).getIResolver(), null, this.wResolverSpecificComp, "VariableResolver-PluginSpecific-Options", null);
        this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

            @Override
            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                VariableResolverEditor.this.setChanged();
            }
        });
        this.setWidgetsContent();
        this.resetChanged();
        Listener modifyListener = event -> {
            this.setChanged();
            MetadataPerspective.getInstance().updateEditor(this);
        };
        this.wName.addListener(24, modifyListener);
        this.wResolverType.addListener(24, modifyListener);
        this.wResolverType.addListener(24, event -> this.changeResolverType());
    }

    private void changeResolverType() {
        if (this.busyChangingConnectionType.get()) {
            return;
        }
        this.busyChangingConnectionType.set(true);
        String newTypeName = this.wResolverType.getText();
        this.wResolverType.setText(newTypeName);
        IVariableResolver iResolver = this.metaMap.get(newTypeName);
        ((VariableResolver)this.getMetadata()).setIResolver(iResolver);
        for (Control child : this.wResolverSpecificComp.getChildren()) {
            child.dispose();
        }
        this.guiCompositeWidgets = new GuiCompositeWidgets(this.manager.getVariables());
        this.guiCompositeWidgets.createCompositeWidgets(iResolver, null, this.wResolverSpecificComp, "VariableResolver-PluginSpecific-Options", null);
        this.guiCompositeWidgets.setWidgetsListener(new GuiCompositeWidgetsAdapter(){

            @Override
            public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
                VariableResolverEditor.this.setChanged();
            }
        });
        this.setWidgetsContent();
        this.getShell().layout(true, true);
        this.busyChangingConnectionType.set(false);
    }

    private void enableFields() {
    }

    @Override
    public void setWidgetsContent() {
        VariableResolver resolver = (VariableResolver)this.getMetadata();
        this.wName.setText(Const.NVL((String)resolver.getName(), (String)""));
        this.wDescription.setText(Const.NVL((String)resolver.getDescription(), (String)""));
        this.wResolverType.setText(Const.NVL((String)resolver.getPluginName(), (String)""));
        this.guiCompositeWidgets.setWidgetsContents(resolver.getIResolver(), this.wResolverSpecificComp, "VariableResolver-PluginSpecific-Options");
        this.enableFields();
    }

    @Override
    public void getWidgetsContent(VariableResolver meta) {
        meta.setName(this.wName.getText());
        meta.setDescription(this.wDescription.getText());
        this.guiCompositeWidgets.getWidgetsContents(meta.getIResolver(), "VariableResolver-PluginSpecific-Options");
    }

    private String[] getResolverTypes() {
        PluginRegistry registry = PluginRegistry.getInstance();
        List plugins = registry.getPlugins(VariableResolverPluginType.class);
        String[] types = new String[plugins.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = ((IPlugin)plugins.get(i)).getName();
        }
        Arrays.sort(types, String.CASE_INSENSITIVE_ORDER);
        return types;
    }

    private void onHelpVariableResolverType() {
        PluginRegistry registry = PluginRegistry.getInstance();
        String name = this.wResolverType.getText();
        for (IPlugin plugin : registry.getPlugins(VariableResolverPluginType.class)) {
            if (!plugin.getName().equals(name)) continue;
            HelpUtils.openHelp(this.getShell(), plugin);
            break;
        }
    }

    @Override
    public boolean setFocus() {
        if (this.wName == null || this.wName.isDisposed()) {
            return false;
        }
        return this.wName.setFocus();
    }

    private Map<String, IVariableResolver> populateMetaMap() {
        this.metaMap = new HashMap<String, IVariableResolver>();
        List plugins = PluginRegistry.getInstance().getPlugins(VariableResolverPluginType.class);
        for (IPlugin plugin : plugins) {
            try {
                IVariableResolver resolver = (IVariableResolver)PluginRegistry.getInstance().loadClass(plugin);
                this.metaMap.put(plugin.getName(), resolver);
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), "Error", "Error instantiating variable resolver metadata", e);
            }
        }
        return this.metaMap;
    }
}

