/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webservices.wsdl;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Operation;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.hop.core.HttpProtocol;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlComplexTypes;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOperation;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlTypes;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlUtils;
import org.apache.http.auth.AuthenticationException;
import org.w3c.dom.Document;

public final class Wsdl
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String CONST_COULD_NOT_LOAD_WSDL_FILE = "Could not load WSDL file: ";
    private Port port;
    private final Definition wsdlDefinition;
    private final Service service;
    private final WsdlTypes wsdlTypes;
    private HashMap<String, WsdlOperation> operationHashMap;
    private URI wsdlURI = null;

    public Wsdl(URI wsdlURI, QName serviceQName, String portName) throws AuthenticationException {
        this(wsdlURI, serviceQName, portName, null, null);
    }

    public Wsdl(URI wsdlURI, QName serviceQName, String portName, String username, String password) throws AuthenticationException {
        this.wsdlURI = wsdlURI;
        try {
            this.wsdlDefinition = this.parse(wsdlURI, username, password);
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (WSDLException | HopException e) {
            throw new RuntimeException(CONST_COULD_NOT_LOAD_WSDL_FILE + e.getMessage(), e);
        }
        if (serviceQName == null) {
            this.service = (Service)this.wsdlDefinition.getServices().values().iterator().next();
        } else {
            this.service = this.wsdlDefinition.getService(serviceQName);
            if (this.service == null) {
                throw new IllegalArgumentException("Service: " + String.valueOf(serviceQName) + " is not defined in the WSDL file " + String.valueOf(wsdlURI));
            }
        }
        if (portName == null) {
            this.port = this.getSoapPort(this.service.getPorts().values());
        } else {
            this.port = this.service.getPort(portName);
            if (this.port == null) {
                throw new IllegalArgumentException("Port: " + portName + " is not defined in the service: " + String.valueOf(serviceQName));
            }
            this.port = this.service.getPort(portName);
        }
        this.wsdlTypes = new WsdlTypes(this.wsdlDefinition);
        this.operationHashMap = new HashMap();
    }

    private Port getSoapPort(Collection<?> portCollection) {
        Port soapPort = null;
        for (Port tempPort : portCollection) {
            if (!WsdlUtils.isSoapPort(tempPort)) continue;
            soapPort = tempPort;
            break;
        }
        return soapPort;
    }

    public Wsdl(WSDLLocator wsdlLocator, QName serviceQName, String portName) throws AuthenticationException {
        this(wsdlLocator, serviceQName, portName, null, null);
    }

    public Wsdl(WSDLLocator wsdlLocator, QName serviceQName, String portName, String username, String password) throws AuthenticationException {
        try {
            this.wsdlDefinition = this.parse(wsdlLocator, username, password);
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (WSDLException | HopException e) {
            throw new RuntimeException(CONST_COULD_NOT_LOAD_WSDL_FILE + e.getMessage(), e);
        }
        this.service = this.wsdlDefinition.getService(serviceQName);
        if (this.service == null) {
            throw new IllegalArgumentException("Service: " + String.valueOf(serviceQName) + " is not defined in the WSDL file.");
        }
        this.port = this.service.getPort(portName);
        if (this.port == null) {
            throw new IllegalArgumentException("Port: " + portName + " is not defined in the service: " + String.valueOf(serviceQName));
        }
        this.wsdlTypes = new WsdlTypes(this.wsdlDefinition);
        this.operationHashMap = new HashMap();
    }

    public WsdlComplexTypes getComplexTypes() {
        return this.wsdlTypes.getNamedComplexTypes();
    }

    public WsdlOperation getOperation(String operationName) throws HopTransformException {
        if (this.operationHashMap.containsKey(operationName)) {
            return this.operationHashMap.get(operationName);
        }
        Binding b = this.port.getBinding();
        PortType pt = b.getPortType();
        Operation op = pt.getOperation(operationName, null, null);
        if (op != null) {
            try {
                WsdlOperation wop = new WsdlOperation(b, op, this.wsdlTypes);
                this.operationHashMap.put(operationName, wop);
                return wop;
            }
            catch (HopException kse) {
                LogChannel.GENERAL.logError("Could not retrieve WSDL Operator for operation name: " + operationName);
                throw new HopTransformException("Could not retrieve WSDL Operator for operation name: " + operationName, (Throwable)kse);
            }
        }
        return null;
    }

    public List<WsdlOperation> getOperations() throws HopTransformException {
        ArrayList<WsdlOperation> opList = new ArrayList<WsdlOperation>();
        PortType pt = this.port.getBinding().getPortType();
        List operations = pt.getOperations();
        Iterator itr = operations.iterator();
        while (itr.hasNext()) {
            WsdlOperation operation = this.getOperation(((Operation)itr.next()).getName());
            if (operation == null) continue;
            opList.add(operation);
        }
        return opList;
    }

    public String getPortName() {
        return this.port.getName();
    }

    public QName getPortTypeQName() {
        Binding b = this.port.getBinding();
        return b.getPortType().getQName();
    }

    public String getServiceEndpoint() {
        return WsdlUtils.getSOAPAddress(this.port);
    }

    public String getServiceName() {
        return this.service.getQName().getLocalPart();
    }

    public String getTargetNamespace() {
        return this.wsdlDefinition.getTargetNamespace();
    }

    public void setPort(QName portName) {
        Port tempPort = this.service.getPort(portName.getLocalPart());
        if (tempPort == null) {
            throw new IllegalArgumentException("Port name: '" + String.valueOf(portName) + "' was not found in the WSDL file.");
        }
        this.port = tempPort;
        this.operationHashMap.clear();
    }

    private WSDLReader getReader() throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        WSDLReader wsdlReader = wsdlFactory.newWSDLReader();
        ExtensionRegistry registry = wsdlFactory.newPopulatedExtensionRegistry();
        wsdlReader.setExtensionRegistry(registry);
        wsdlReader.setFeature("javax.wsdl.verbose", true);
        wsdlReader.setFeature("javax.wsdl.importDocuments", true);
        return wsdlReader;
    }

    private Definition parse(WSDLLocator wsdlLocator, String username, String password) throws WSDLException, HopException, AuthenticationException {
        WSDLReader wsdlReader = this.getReader();
        try {
            return wsdlReader.readWSDL(wsdlLocator);
        }
        catch (WSDLException we) {
            this.readWsdl(wsdlReader, this.wsdlURI.toString(), username, password);
            return null;
        }
    }

    private Definition parse(URI wsdlURI, String username, String password) throws WSDLException, HopException, AuthenticationException {
        WSDLReader wsdlReader = this.getReader();
        return this.readWsdl(wsdlReader, wsdlURI.toString(), username, password);
    }

    private Definition readWsdl(WSDLReader wsdlReader, String uri, String username, String password) throws WSDLException, HopException, AuthenticationException {
        try {
            HttpProtocol http = new HttpProtocol();
            Document doc = XmlHandler.loadXmlString((String)http.get(this.wsdlURI.toString(), username, password), (Boolean)true, (Boolean)false);
            if (doc != null) {
                return wsdlReader.readWSDL(doc.getBaseURI(), doc);
            }
            throw new HopException("Unable to get document.");
        }
        catch (MalformedURLException mue) {
            throw new HopException((Throwable)mue);
        }
        catch (AuthenticationException ae) {
            throw ae;
        }
        catch (IOException ioe) {
            throw new HopException((Throwable)ioe);
        }
    }

    public WsdlTypes getWsdlTypes() {
        return this.wsdlTypes;
    }
}

