/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.rest;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.HttpClientManager;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.rest.RestConnection;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.rest.RestData;
import org.apache.hop.pipeline.transforms.rest.RestMeta;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.uri.UriComponent;
import org.json.simple.JSONObject;

public class Rest
extends BaseTransform<RestMeta, RestData> {
    private static final Class<?> PKG = RestMeta.class;
    public static final String CONST_REST_EXCEPTION_ERROR_FINDING_FIELD = "Rest.Exception.ErrorFindingField";
    private String baseUrl = "";
    private RestConnection connection;

    public Rest(TransformMeta transformMeta, RestMeta meta, RestData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    MultivaluedHashMap createMultivalueMap(String paramName, String paramValue) {
        MultivaluedHashMap queryParams = new MultivaluedHashMap();
        queryParams.add((Object)paramName, (Object)UriComponent.encode((String)paramValue, (UriComponent.Type)UriComponent.Type.QUERY_PARAM));
        return queryParams;
    }

    protected Object[] callRest(Object[] rowData) throws HopException {
        if (((RestMeta)this.meta).isUrlInField()) {
            ((RestData)this.data).realUrl = !Utils.isEmpty((CharSequence)((RestData)this.data).connectionName) ? this.baseUrl + ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfUrlField) : ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfUrlField);
        }
        if (((RestMeta)this.meta).isDynamicMethod()) {
            ((RestData)this.data).method = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfMethod);
            if (Utils.isEmpty((CharSequence)((RestData)this.data).method)) {
                throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
            }
        }
        WebTarget webResource = null;
        Client client = null;
        Object[] newRow = null;
        if (rowData != null) {
            newRow = (Object[])rowData.clone();
        }
        try {
            String body;
            Response response;
            long startTime;
            block48: {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ConnectingToURL", (String[])new String[]{((RestData)this.data).realUrl}));
                }
                ClientBuilder clientBuilder = ClientBuilder.newBuilder();
                clientBuilder.withConfig((Configuration)((RestData)this.data).config).property("jersey.config.client.httpUrlConnection.setMethodWorkaround", (Object)true);
                if (((RestMeta)this.meta).isIgnoreSsl() || !Utils.isEmpty((CharSequence)((RestData)this.data).trustStoreFile)) {
                    clientBuilder.hostnameVerifier((s1, s2) -> true);
                    clientBuilder.sslContext(((RestData)this.data).sslContext);
                }
                client = clientBuilder.build();
                if (((RestData)this.data).basicAuthentication != null) {
                    client.register((Object)((RestData)this.data).basicAuthentication);
                }
                webResource = client.target(((RestData)this.data).realUrl);
                startTime = System.currentTimeMillis();
                if (((RestData)this.data).useMatrixParams) {
                    UriBuilder builder = webResource.getUriBuilder();
                    for (int i = 0; i < ((RestData)this.data).nrMatrixParams; ++i) {
                        String value = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfMatrixParamFields[i]);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.matrixParameterValue", (String[])new String[]{((RestData)this.data).matrixParamNames[i], value}));
                        }
                        builder = builder.matrixParam(((RestData)this.data).matrixParamNames[i], new Object[]{UriComponent.encode((String)value, (UriComponent.Type)UriComponent.Type.QUERY_PARAM)});
                    }
                    webResource = client.target(builder.build(new Object[0]));
                }
                if (((RestData)this.data).useParams) {
                    for (int i = 0; i < ((RestData)this.data).nrParams; ++i) {
                        String value = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfParamFields[i]);
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.queryParameterValue", (String[])new String[]{((RestData)this.data).paramNames[i], value}));
                        }
                        webResource = webResource.queryParam(((RestData)this.data).paramNames[i], new Object[]{value});
                    }
                }
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.ConnectingToURL", (Object[])new Object[]{webResource.getUri()}));
                }
                Invocation.Builder invocationBuilder = webResource.request();
                if (this.connection != null && !Utils.isEmpty((CharSequence)this.resolve(this.connection.getAuthorizationHeaderName()))) {
                    if (!StringUtils.isEmpty((String)this.resolve(this.connection.getAuthorizationPrefix()))) {
                        invocationBuilder.header(this.resolve(this.connection.getAuthorizationHeaderName()), (Object)(this.resolve(this.connection.getAuthorizationPrefix()) + " " + this.resolve(this.connection.getAuthorizationHeaderValue())));
                    } else {
                        invocationBuilder.header(this.resolve(this.connection.getAuthorizationHeaderName()), (Object)this.resolve(this.connection.getAuthorizationHeaderValue()));
                    }
                }
                String contentType = null;
                if (((RestData)this.data).useHeaders) {
                    for (int i = 0; i < ((RestData)this.data).nrheader; ++i) {
                        String value = ((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfHeaderFields[i]);
                        invocationBuilder.header(((RestData)this.data).headerNames[i], (Object)value);
                        if ("Content-Type".equals(((RestData)this.data).headerNames[i])) {
                            contentType = value;
                        }
                        if (!this.isDebug()) continue;
                        this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.HeaderValue", (String[])new String[]{((RestData)this.data).headerNames[i], value}));
                    }
                }
                response = null;
                String entityString = null;
                if (((RestData)this.data).useBody) {
                    entityString = Const.NVL((String)((RestData)this.data).inputRowMeta.getString(rowData, ((RestData)this.data).indexOfBodyField), null);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.BodyValue", (String[])new String[]{entityString}));
                    }
                }
                try {
                    if (((RestData)this.data).method.equals("GET")) {
                        response = (Response)invocationBuilder.get(Response.class);
                        break block48;
                    }
                    if (((RestData)this.data).method.equals("POST")) {
                        response = null != contentType ? invocationBuilder.post(Entity.entity((Object)entityString, contentType)) : invocationBuilder.post(Entity.entity((Object)entityString, (MediaType)((RestData)this.data).mediaType));
                        break block48;
                    }
                    if (((RestData)this.data).method.equals("PUT")) {
                        response = null != contentType ? invocationBuilder.put(Entity.entity((Object)entityString, contentType)) : invocationBuilder.put(Entity.entity((Object)entityString, (MediaType)((RestData)this.data).mediaType));
                        break block48;
                    }
                    if (((RestData)this.data).method.equals("DELETE")) {
                        Invocation invocation = invocationBuilder.build("DELETE", Entity.entity((Object)entityString, (MediaType)((RestData)this.data).mediaType));
                        response = invocation.invoke();
                        break block48;
                    }
                    if (((RestData)this.data).method.equals("HEAD")) {
                        response = invocationBuilder.head();
                        break block48;
                    }
                    if (((RestData)this.data).method.equals("OPTIONS")) {
                        response = invocationBuilder.options();
                        break block48;
                    }
                    if (((RestData)this.data).method.equals("PATCH")) {
                        response = null != contentType ? invocationBuilder.method("PATCH", Entity.entity((Object)entityString, (String)contentType)) : invocationBuilder.method("PATCH", Entity.entity((Object)entityString, (MediaType)((RestData)this.data).mediaType));
                        break block48;
                    }
                    throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.UnknownMethod", (String[])new String[]{((RestData)this.data).method}));
                }
                catch (Exception e) {
                    throw new HopException("Request could not be processed", (Throwable)e);
                }
            }
            long responseTime = System.currentTimeMillis() - startTime;
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseTime", (String[])new String[]{String.valueOf(responseTime), ((RestData)this.data).realUrl}));
            }
            int status = response.getStatus();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"Rest.Log.ResponseCode", (String[])new String[]{"" + status}));
            }
            String headerString = null;
            try {
                body = (String)response.readEntity(String.class);
            }
            catch (Exception ex) {
                body = "";
            }
            MultivaluedMap<String, Object> headers = this.searchForHeaders(response);
            JSONObject json = new JSONObject();
            for (Map.Entry entry : headers.entrySet()) {
                String name = (String)entry.getKey();
                List value = (List)entry.getValue();
                if (value.size() > 1) {
                    json.put((Object)name, (Object)value);
                    continue;
                }
                json.put((Object)name, value.get(0));
            }
            headerString = json.toJSONString();
            int returnFieldsOffset = ((RestData)this.data).inputRowMeta.size();
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)body);
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultCodeFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)status);
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultResponseFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)responseTime);
                ++returnFieldsOffset;
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).resultHeaderFieldName)) {
                newRow = RowDataUtil.addValueData((Object[])newRow, (int)returnFieldsOffset, (Object)headerString);
            }
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.CanNotReadURL", (String[])new String[]{((RestData)this.data).realUrl}), (Throwable)e);
        }
        finally {
            if (webResource != null) {
                webResource = null;
            }
            if (client != null) {
                client.close();
            }
        }
        return newRow;
    }

    private void setConfig() throws HopException {
        if (((RestData)this.data).config == null) {
            ((RestData)this.data).config = new ClientConfig();
            ((RestData)this.data).config.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            ((RestData)this.data).config.property("jersey.config.client.request.entity.processing", (Object)RequestEntityProcessing.BUFFERED);
            ((RestData)this.data).config.property("jersey.config.client.suppressHttpComplianceValidation", (Object)true);
            ((RestData)this.data).config.property("jersey.config.client.readTimeout", (Object)((RestData)this.data).realReadTimeout);
            ((RestData)this.data).config.property("jersey.config.client.connectTimeout", (Object)((RestData)this.data).realConnectionTimeout);
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).realProxyHost)) {
                ((RestData)this.data).config.property("jersey.config.client.proxy.uri", (Object)("http://" + ((RestData)this.data).realProxyHost + ":" + ((RestData)this.data).realProxyPort));
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).realHttpLogin) || !Utils.isEmpty((CharSequence)((RestData)this.data).realHttpPassword)) {
                ((RestData)this.data).basicAuthentication = HttpAuthenticationFeature.basicBuilder().credentials(((RestData)this.data).realHttpLogin, ((RestData)this.data).realHttpPassword).build();
            }
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).trustStoreFile) && !((RestMeta)this.meta).isIgnoreSsl()) {
                this.setTrustStoreFile();
            }
            if (((RestMeta)this.meta).isIgnoreSsl()) {
                this.setTrustAll();
            }
        }
    }

    private void setTrustAll() throws HopException {
        try {
            SSLContext ctx;
            ((RestData)this.data).sslContext = ctx = HttpClientManager.getTrustAllSslContext();
        }
        catch (NoSuchAlgorithmException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.NoSuchAlgorithm", (String[])new String[0]), (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyManagementException", (String[])new String[0]), (Throwable)e);
        }
    }

    private void setTrustStoreFile() throws HopException {
        try (FileInputStream trustFileStream = new FileInputStream(((RestData)this.data).trustStoreFile);){
            SSLContext ctx;
            ((RestData)this.data).sslContext = ctx = HttpClientManager.getSslContextWithTrustStoreFile((FileInputStream)trustFileStream, (String)((RestData)this.data).trustStorePassword);
        }
        catch (NoSuchAlgorithmException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.NoSuchAlgorithm", (String[])new String[0]), (Throwable)e);
        }
        catch (KeyStoreException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyStoreException", (String[])new String[0]), (Throwable)e);
        }
        catch (CertificateException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.CertificateException", (String[])new String[0]), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.FileNotFound", (String[])new String[]{((RestData)this.data).trustStoreFile}), (Throwable)e);
        }
        catch (IOException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.IOException", (String[])new String[0]), (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Error.KeyManagementException", (String[])new String[0]), (Throwable)e);
        }
    }

    protected MultivaluedMap<String, Object> searchForHeaders(Response response) {
        return response.getHeaders();
    }

    public boolean processRow() throws HopException {
        block26: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                String field;
                this.first = false;
                ((RestData)this.data).inputRowMeta = this.getInputRowMeta();
                ((RestData)this.data).outputRowMeta = ((RestData)this.data).inputRowMeta.clone();
                ((RestMeta)this.meta).getFields(((RestData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (((RestMeta)this.meta).isUrlInField()) {
                    if (Utils.isEmpty((CharSequence)((RestMeta)this.meta).getUrlField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                        throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Log.NoField", (String[])new String[0]));
                    }
                    if (((RestData)this.data).indexOfUrlField < 0) {
                        String realUrlfieldName = this.resolve(((RestMeta)this.meta).getUrlField());
                        ((RestData)this.data).indexOfUrlField = ((RestData)this.data).inputRowMeta.indexOfValue(realUrlfieldName);
                        if (((RestData)this.data).indexOfUrlField < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)CONST_REST_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{realUrlfieldName}));
                        }
                    }
                } else {
                    ((RestData)this.data).realUrl = !Utils.isEmpty((CharSequence)((RestData)this.data).connectionName) ? this.baseUrl + Const.NVL((String)this.resolve(((RestMeta)this.meta).getUrl()), (String)"") : this.resolve(((RestMeta)this.meta).getUrl());
                }
                if (((RestMeta)this.meta).isDynamicMethod()) {
                    String field2 = this.resolve(((RestMeta)this.meta).getMethodFieldName());
                    if (Utils.isEmpty((CharSequence)field2)) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.MethodFieldMissing", (String[])new String[0]));
                    }
                    ((RestData)this.data).indexOfMethod = ((RestData)this.data).inputRowMeta.indexOfValue(field2);
                    if (((RestData)this.data).indexOfMethod < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)CONST_REST_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{field2}));
                    }
                }
                if (!Utils.isEmpty(((RestMeta)this.meta).getHeaderFields())) {
                    ((RestData)this.data).nrheader = ((RestMeta)this.meta).getHeaderFields().size();
                    ((RestData)this.data).indexOfHeaderFields = new int[((RestMeta)this.meta).getHeaderFields().size()];
                    ((RestData)this.data).headerNames = new String[((RestMeta)this.meta).getHeaderFields().size()];
                    for (int i = 0; i < ((RestMeta)this.meta).getHeaderFields().size(); ++i) {
                        ((RestData)this.data).headerNames[i] = this.resolve(((RestMeta)this.meta).getHeaderFields().get(i).getName());
                        String field3 = this.resolve(((RestMeta)this.meta).getHeaderFields().get(i).getHeaderField());
                        if (Utils.isEmpty((CharSequence)field3)) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.HeaderFieldEmpty", (String[])new String[0]));
                        }
                        ((RestData)this.data).indexOfHeaderFields[i] = ((RestData)this.data).inputRowMeta.indexOfValue(field3);
                        if (((RestData)this.data).indexOfHeaderFields[i] >= 0) continue;
                        throw new HopException(BaseMessages.getString(PKG, (String)CONST_REST_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{field3}));
                    }
                    ((RestData)this.data).useHeaders = true;
                }
                if (RestMeta.isActiveParameters(((RestMeta)this.meta).getMethod())) {
                    int nrmatrixparams;
                    int nrparams;
                    int n = nrparams = ((RestMeta)this.meta).getParameterFields() == null ? 0 : ((RestMeta)this.meta).getParameterFields().size();
                    if (nrparams > 0) {
                        ((RestData)this.data).nrParams = nrparams;
                        ((RestData)this.data).paramNames = new String[nrparams];
                        ((RestData)this.data).indexOfParamFields = new int[nrparams];
                        for (int i = 0; i < nrparams; ++i) {
                            ((RestData)this.data).paramNames[i] = this.resolve(((RestMeta)this.meta).getParameterFields().get(i).getName());
                            String field4 = this.resolve(((RestMeta)this.meta).getParameterFields().get(i).getHeaderField());
                            if (Utils.isEmpty((CharSequence)field4)) {
                                throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.ParamFieldEmpty", (String[])new String[0]));
                            }
                            ((RestData)this.data).indexOfParamFields[i] = ((RestData)this.data).inputRowMeta.indexOfValue(field4);
                            if (((RestData)this.data).indexOfParamFields[i] >= 0) continue;
                            throw new HopException(BaseMessages.getString(PKG, (String)CONST_REST_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{field4}));
                        }
                        ((RestData)this.data).useParams = true;
                    }
                    int n2 = nrmatrixparams = ((RestMeta)this.meta).getMatrixParameterFields() == null ? 0 : ((RestMeta)this.meta).getMatrixParameterFields().size();
                    if (nrmatrixparams > 0) {
                        ((RestData)this.data).nrMatrixParams = nrmatrixparams;
                        ((RestData)this.data).matrixParamNames = new String[nrmatrixparams];
                        ((RestData)this.data).indexOfMatrixParamFields = new int[nrmatrixparams];
                        for (int i = 0; i < nrmatrixparams; ++i) {
                            ((RestData)this.data).matrixParamNames[i] = this.resolve(((RestMeta)this.meta).getMatrixParameterFields().get(i).getName());
                            String field5 = this.resolve(((RestMeta)this.meta).getMatrixParameterFields().get(i).getHeaderField());
                            if (Utils.isEmpty((CharSequence)field5)) {
                                throw new HopException(BaseMessages.getString(PKG, (String)"Rest.Exception.MatrixParamFieldEmpty", (String[])new String[0]));
                            }
                            ((RestData)this.data).indexOfMatrixParamFields[i] = ((RestData)this.data).inputRowMeta.indexOfValue(field5);
                            if (((RestData)this.data).indexOfMatrixParamFields[i] >= 0) continue;
                            throw new HopException(BaseMessages.getString(PKG, (String)CONST_REST_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{field5}));
                        }
                        ((RestData)this.data).useMatrixParams = true;
                    }
                }
                if (RestMeta.isActiveBody(((RestMeta)this.meta).getMethod()) && !Utils.isEmpty((CharSequence)(field = this.resolve(((RestMeta)this.meta).getBodyField())))) {
                    ((RestData)this.data).indexOfBodyField = ((RestData)this.data).inputRowMeta.indexOfValue(field);
                    if (((RestData)this.data).indexOfBodyField < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)CONST_REST_EXCEPTION_ERROR_FINDING_FIELD, (String[])new String[]{field}));
                    }
                    ((RestData)this.data).useBody = true;
                }
            }
            try {
                Object[] outputRowData = this.callRest(r);
                this.putRow(((RestData)this.data).outputRowMeta, outputRowData);
                if (this.checkFeedback(this.getLinesRead()) && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"Rest.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.logError(Const.getStackTracker((Throwable)e));
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block26;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "Rest001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            ((RestData)this.data).connectionName = this.resolve(((RestMeta)this.meta).getConnectionName());
            if (!Utils.isEmpty((CharSequence)((RestData)this.data).connectionName)) {
                try {
                    this.connection = (RestConnection)this.metadataProvider.getSerializer(RestConnection.class).load(((RestData)this.data).connectionName);
                    this.baseUrl = this.resolve(this.connection.getBaseUrl());
                }
                catch (Exception e) {
                    throw new RuntimeException("REST connection " + ((RestMeta)this.meta).getConnectionName() + " could not be found");
                }
            }
            ((RestData)this.data).resultFieldName = this.resolve(((RestMeta)this.meta).getResultField().getFieldName());
            ((RestData)this.data).resultCodeFieldName = this.resolve(((RestMeta)this.meta).getResultField().getCode());
            ((RestData)this.data).resultResponseFieldName = this.resolve(((RestMeta)this.meta).getResultField().getResponseTime());
            ((RestData)this.data).resultHeaderFieldName = this.resolve(((RestMeta)this.meta).getResultField().getResponseHeader());
            ((RestData)this.data).realConnectionTimeout = Const.toInt((String)this.resolve(((RestMeta)this.meta).getConnectionTimeout()), (int)-1);
            ((RestData)this.data).realReadTimeout = Const.toInt((String)this.resolve(((RestMeta)this.meta).getReadTimeout()), (int)-1);
            ((RestData)this.data).realProxyHost = this.resolve(((RestMeta)this.meta).getProxyHost());
            ((RestData)this.data).realProxyPort = Const.toInt((String)this.resolve(((RestMeta)this.meta).getProxyPort()), (int)8080);
            ((RestData)this.data).realHttpLogin = this.resolve(((RestMeta)this.meta).getHttpLogin());
            ((RestData)this.data).realHttpPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.resolve(((RestMeta)this.meta).getHttpPassword()));
            if (!((RestMeta)this.meta).isDynamicMethod()) {
                ((RestData)this.data).method = this.resolve(((RestMeta)this.meta).getMethod());
                if (Utils.isEmpty((CharSequence)((RestData)this.data).method)) {
                    this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.MethodMissing", (String[])new String[0]));
                    return false;
                }
            }
            ((RestData)this.data).trustStoreFile = this.resolve(((RestMeta)this.meta).getTrustStoreFile());
            ((RestData)this.data).trustStorePassword = this.resolve(((RestMeta)this.meta).getTrustStorePassword());
            String applicationType = Const.NVL((String)((RestMeta)this.meta).getApplicationType(), (String)"");
            ((RestData)this.data).mediaType = applicationType.equals("XML") ? MediaType.APPLICATION_XML_TYPE : (applicationType.equals("JSON") ? MediaType.APPLICATION_JSON_TYPE : (applicationType.equals("OCTET STREAM") ? MediaType.APPLICATION_OCTET_STREAM_TYPE : (applicationType.equals("XHTML") ? MediaType.APPLICATION_XHTML_XML_TYPE : (applicationType.equals("FORM URLENCODED") ? MediaType.APPLICATION_FORM_URLENCODED_TYPE : (applicationType.equals("ATOM XML") ? MediaType.APPLICATION_ATOM_XML_TYPE : (applicationType.equals("SVG XML") ? MediaType.APPLICATION_SVG_XML_TYPE : (applicationType.equals("TEXT XML") ? MediaType.TEXT_XML_TYPE : MediaType.TEXT_PLAIN_TYPE)))))));
            try {
                this.setConfig();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"Rest.Error.Config", (String[])new String[0]), e);
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        ((RestData)this.data).config = null;
        ((RestData)this.data).headerNames = null;
        ((RestData)this.data).indexOfHeaderFields = null;
        ((RestData)this.data).paramNames = null;
        super.dispose();
    }
}

