/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import org.apache.flink.configuration.MemorySize;
import org.apache.flink.util.Preconditions;

public class RangeFraction {
    private final MemorySize minSize;
    private final MemorySize maxSize;
    private final double fraction;

    RangeFraction(MemorySize minSize, MemorySize maxSize, double fraction) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.fraction = fraction;
        Preconditions.checkArgument((minSize.getBytes() <= maxSize.getBytes() ? 1 : 0) != 0, (Object)"min value must be less or equal to max value");
        Preconditions.checkArgument((fraction >= 0.0 && fraction < 1.0 ? 1 : 0) != 0, (Object)"fraction must be in range [0, 1)");
    }

    public MemorySize getMinSize() {
        return this.minSize;
    }

    public MemorySize getMaxSize() {
        return this.maxSize;
    }

    public double getFraction() {
        return this.fraction;
    }
}

