/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.transforms.cypher.CypherMeta;
import org.apache.hop.neo4j.transforms.cypher.ParameterMapping;
import org.apache.hop.neo4j.transforms.cypher.ReturnValue;
import org.apache.hop.neo4j.transforms.output.Neo4JOutputDialog;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.FormDataBuilder;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.types.Type;
import org.neo4j.driver.util.Pair;

public class CypherDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = CypherMeta.class;
    public static final String CONST_ERROR = "Error";
    private CTabFolder wTabFolder;
    private Text wTransformName;
    private int middle;
    private int margin;
    private MetaSelectionLine<NeoConnection> wConnection;
    private TextVar wBatchSize;
    private Button wReadOnly;
    private Button wRetryOnDisconnect;
    private TextVar wNrRetriesOnError;
    private Button wCypherFromField;
    private CCombo wCypherField;
    private Button wUnwind;
    private Label wlUnwindMap;
    private TextVar wUnwindMap;
    private Button wReturnGraph;
    private Label wlReturnGraphField;
    private TextVar wReturnGraphField;
    private Text wCypher;
    private TableView wParameters;
    private TableView wReturns;
    private CypherMeta input;

    public CypherDialog(Shell parent, IVariables variables, CypherMeta inputMetadata, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)inputMetadata, pipelineMeta);
        this.input = inputMetadata;
        this.metadataProvider = HopGui.getInstance().getMetadataProvider();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.shell.setLayout(this.createFormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"Cypher.Transform.Name", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = PropsUi.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, this.margin, null);
        Label wlTransformName = new Label((Composite)this.shell, 131072);
        wlTransformName.setText("Transform name");
        PropsUi.setLook((Widget)wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.fdlTransformName.top = new FormAttachment(0, 0);
        wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.addOptionsTab();
        this.addParametersTab();
        this.addCypherTab();
        this.addReturnsTab();
        this.wTabFolder.setLayoutData((Object)new FormDataBuilder().left().top(new FormAttachment((Control)this.wTransformName, this.margin)).right().bottom(new FormAttachment((Control)this.wOk, -2 * this.margin)).result());
        this.getData();
        this.wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void addOptionsTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Options.Label", (String[])new String[0]));
        wOptionsTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Options.ToolTip", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wOptionsComp);
        wOptionsComp.setLayout(this.createFormLayout());
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, NeoConnection.class, wOptionsComp, 18436, "Neo4j Connection", "The name of the Neo4j connection to use");
        PropsUi.setLook(this.wConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment(0, 0);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error getting list of connections", e);
        }
        TextVar lastControl = this.wConnection;
        Label wlBatchSize = new Label(wOptionsComp, 131072);
        wlBatchSize.setText("Batch size (rows)");
        PropsUi.setLook((Widget)wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.right = new FormAttachment(this.middle, -this.margin);
        fdlBatchSize.top = new FormAttachment(lastControl, 2 * this.margin);
        wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(this.middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        lastControl = this.wBatchSize;
        Label wlReadOnly = new Label(wOptionsComp, 131072);
        wlReadOnly.setText("Read only statement? ");
        PropsUi.setLook((Widget)wlReadOnly);
        FormData fdlReadOnly = new FormData();
        fdlReadOnly.left = new FormAttachment(0, 0);
        fdlReadOnly.right = new FormAttachment(this.middle, -this.margin);
        fdlReadOnly.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlReadOnly.setLayoutData((Object)fdlReadOnly);
        this.wReadOnly = new Button(wOptionsComp, 2080);
        PropsUi.setLook((Widget)this.wReadOnly);
        FormData fdReadOnly = new FormData();
        fdReadOnly.left = new FormAttachment(this.middle, 0);
        fdReadOnly.right = new FormAttachment(100, 0);
        fdReadOnly.top = new FormAttachment((Control)wlReadOnly, 0, 0x1000000);
        this.wReadOnly.setLayoutData((Object)fdReadOnly);
        lastControl = this.wReadOnly;
        Label wlRetry = new Label(wOptionsComp, 131072);
        wlRetry.setText("Reconnect once after disconnection? ");
        PropsUi.setLook((Widget)wlRetry);
        FormData fdlRetry = new FormData();
        fdlRetry.left = new FormAttachment(0, 0);
        fdlRetry.right = new FormAttachment(this.middle, -this.margin);
        fdlRetry.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlRetry.setLayoutData((Object)fdlRetry);
        this.wRetryOnDisconnect = new Button(wOptionsComp, 2080);
        PropsUi.setLook((Widget)this.wRetryOnDisconnect);
        FormData fdRetry = new FormData();
        fdRetry.left = new FormAttachment(this.middle, 0);
        fdRetry.right = new FormAttachment(100, 0);
        fdRetry.top = new FormAttachment((Control)wlRetry, 0, 0x1000000);
        this.wRetryOnDisconnect.setLayoutData((Object)fdRetry);
        lastControl = this.wRetryOnDisconnect;
        Label wlNrRetriesOnError = new Label(wOptionsComp, 131072);
        wlNrRetriesOnError.setText("Number of retries on error");
        PropsUi.setLook((Widget)wlNrRetriesOnError);
        FormData fdlNrRetriesOnError = new FormData();
        fdlNrRetriesOnError.left = new FormAttachment(0, 0);
        fdlNrRetriesOnError.right = new FormAttachment(this.middle, -this.margin);
        fdlNrRetriesOnError.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlNrRetriesOnError.setLayoutData((Object)fdlNrRetriesOnError);
        this.wNrRetriesOnError = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wNrRetriesOnError);
        FormData fdNrRetriesOnError = new FormData();
        fdNrRetriesOnError.left = new FormAttachment(this.middle, 0);
        fdNrRetriesOnError.right = new FormAttachment(100, 0);
        fdNrRetriesOnError.top = new FormAttachment((Control)wlNrRetriesOnError, 0, 0x1000000);
        this.wNrRetriesOnError.setLayoutData((Object)fdNrRetriesOnError);
        lastControl = this.wNrRetriesOnError;
        Label wlCypherFromField = new Label(wOptionsComp, 131072);
        wlCypherFromField.setText("Get Cypher from input field? ");
        PropsUi.setLook((Widget)wlCypherFromField);
        FormData fdlCypherFromField = new FormData();
        fdlCypherFromField.left = new FormAttachment(0, 0);
        fdlCypherFromField.right = new FormAttachment(this.middle, -this.margin);
        fdlCypherFromField.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlCypherFromField.setLayoutData((Object)fdlCypherFromField);
        this.wCypherFromField = new Button(wOptionsComp, 2080);
        PropsUi.setLook((Widget)this.wCypherFromField);
        FormData fdCypherFromField = new FormData();
        fdCypherFromField.left = new FormAttachment(this.middle, 0);
        fdCypherFromField.right = new FormAttachment(100, 0);
        fdCypherFromField.top = new FormAttachment((Control)wlCypherFromField, 0, 0x1000000);
        this.wCypherFromField.setLayoutData((Object)fdCypherFromField);
        lastControl = this.wCypherFromField;
        this.wCypherFromField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CypherDialog.this.enableFields();
            }
        });
        Label wlCypherField = new Label(wOptionsComp, 131072);
        wlCypherField.setText("Cypher input field");
        PropsUi.setLook((Widget)wlCypherField);
        FormData fdlCypherField = new FormData();
        fdlCypherField.left = new FormAttachment(0, 0);
        fdlCypherField.right = new FormAttachment(this.middle, -this.margin);
        fdlCypherField.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlCypherField.setLayoutData((Object)fdlCypherField);
        this.wCypherField = new CCombo(wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wCypherField);
        FormData fdCypherField = new FormData();
        fdCypherField.left = new FormAttachment(this.middle, 0);
        fdCypherField.right = new FormAttachment(100, 0);
        fdCypherField.top = new FormAttachment((Control)wlCypherField, 0, 0x1000000);
        this.wCypherField.setLayoutData((Object)fdCypherField);
        lastControl = this.wCypherField;
        Label wlUnwind = new Label(wOptionsComp, 131072);
        wlUnwind.setText("Collect parameter values map?");
        wlUnwind.setToolTipText("Collect the specified parameters field data and expose it into a single variable to support UNWIND statements");
        PropsUi.setLook((Widget)wlUnwind);
        FormData fdlUnwind = new FormData();
        fdlUnwind.left = new FormAttachment(0, 0);
        fdlUnwind.right = new FormAttachment(this.middle, -this.margin);
        fdlUnwind.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlUnwind.setLayoutData((Object)fdlUnwind);
        this.wUnwind = new Button(wOptionsComp, 2080);
        PropsUi.setLook((Widget)this.wUnwind);
        FormData fdUnwind = new FormData();
        fdUnwind.left = new FormAttachment(this.middle, 0);
        fdUnwind.right = new FormAttachment(100, 0);
        fdUnwind.top = new FormAttachment((Control)wlUnwind, 0, 0x1000000);
        this.wUnwind.setLayoutData((Object)fdUnwind);
        lastControl = this.wUnwind;
        this.wUnwind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CypherDialog.this.enableFields();
            }
        });
        this.wlUnwindMap = new Label(wOptionsComp, 131072);
        this.wlUnwindMap.setText("Name of values map list");
        this.wlUnwindMap.setToolTipText("You can use this parameter in your Cypher usually in UNWIND statements");
        PropsUi.setLook((Widget)this.wlUnwindMap);
        FormData fdlUnwindMap = new FormData();
        fdlUnwindMap.left = new FormAttachment(0, 0);
        fdlUnwindMap.right = new FormAttachment(this.middle, -this.margin);
        fdlUnwindMap.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        this.wlUnwindMap.setLayoutData((Object)fdlUnwindMap);
        this.wUnwindMap = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wUnwindMap);
        FormData fdUnwindMap = new FormData();
        fdUnwindMap.left = new FormAttachment(this.middle, 0);
        fdUnwindMap.right = new FormAttachment(100, 0);
        fdUnwindMap.top = new FormAttachment((Control)this.wlUnwindMap, 0, 0x1000000);
        this.wUnwindMap.setLayoutData((Object)fdUnwindMap);
        lastControl = this.wUnwindMap;
        Label wlReturnGraph = new Label(wOptionsComp, 131072);
        wlReturnGraph.setText("Return graph data?");
        String returnGraphTooltipText = "Returns the whole result of a query as a Graph Hop data type";
        wlReturnGraph.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)wlReturnGraph);
        FormData fdlReturnGraph = new FormData();
        fdlReturnGraph.left = new FormAttachment(0, 0);
        fdlReturnGraph.right = new FormAttachment(this.middle, -this.margin);
        fdlReturnGraph.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        wlReturnGraph.setLayoutData((Object)fdlReturnGraph);
        this.wReturnGraph = new Button(wOptionsComp, 2080);
        this.wReturnGraph.setToolTipText(returnGraphTooltipText);
        PropsUi.setLook((Widget)this.wReturnGraph);
        FormData fdReturnGraph = new FormData();
        fdReturnGraph.left = new FormAttachment(this.middle, 0);
        fdReturnGraph.right = new FormAttachment(100, 0);
        fdReturnGraph.top = new FormAttachment((Control)wlReturnGraph, 0, 0x1000000);
        this.wReturnGraph.setLayoutData((Object)fdReturnGraph);
        lastControl = this.wReturnGraph;
        this.wReturnGraph.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                CypherDialog.this.enableFields();
            }
        });
        this.wlReturnGraphField = new Label(wOptionsComp, 131072);
        this.wlReturnGraphField.setText("Graph output field name");
        PropsUi.setLook((Widget)this.wlReturnGraphField);
        FormData fdlReturnGraphField = new FormData();
        fdlReturnGraphField.left = new FormAttachment(0, 0);
        fdlReturnGraphField.right = new FormAttachment(this.middle, -this.margin);
        fdlReturnGraphField.top = new FormAttachment((Control)lastControl, 2 * this.margin);
        this.wlReturnGraphField.setLayoutData((Object)fdlReturnGraphField);
        this.wReturnGraphField = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wReturnGraphField);
        FormData fdReturnGraphField = new FormData();
        fdReturnGraphField.left = new FormAttachment(this.middle, 0);
        fdReturnGraphField.right = new FormAttachment(100, 0);
        fdReturnGraphField.top = new FormAttachment((Control)this.wlReturnGraphField, 0, 0x1000000);
        this.wReturnGraphField.setLayoutData((Object)fdReturnGraphField);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void addParametersTab() {
        String[] fieldNames;
        CTabItem wParametersTab = new CTabItem(this.wTabFolder, 0);
        wParametersTab.setFont(GuiResource.getInstance().getFontDefault());
        wParametersTab.setText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Parameters.Label", (String[])new String[0]));
        wParametersTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Parameters.ToolTip", (String[])new String[0]));
        Composite wParametersComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wParametersComp);
        wParametersComp.setLayout(this.createFormLayout());
        try {
            fieldNames = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames();
        }
        catch (Exception e2) {
            this.logError("Unable to get fields from previous transform", e2);
            fieldNames = new String[]{};
        }
        ColumnInfo[] parameterColumns = new ColumnInfo[]{new ColumnInfo("Parameter", 1, false), new ColumnInfo("Field", 2, fieldNames, false), new ColumnInfo("Neo4j Type", 2, GraphPropertyType.getNames(), false)};
        Label wlParameters = new Label(wParametersComp, 16384);
        wlParameters.setText("Parameters: (NOTE that parameters for labels are not supported)");
        PropsUi.setLook((Widget)wlParameters);
        FormData fdlParameters = new FormData();
        fdlParameters.left = new FormAttachment(0, 0);
        fdlParameters.right = new FormAttachment(100, 0);
        fdlParameters.top = new FormAttachment(0, 0);
        wlParameters.setLayoutData((Object)fdlParameters);
        Button wbGetParameters = new Button(wParametersComp, 8);
        wbGetParameters.setText("Get parameters");
        FormData fdbGetParameters = new FormData();
        fdbGetParameters.right = new FormAttachment(100, 0);
        fdbGetParameters.top = new FormAttachment((Control)wlParameters, 0, 1024);
        wbGetParameters.setLayoutData((Object)fdbGetParameters);
        wbGetParameters.addListener(13, e -> {
            try {
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wParameters, (int)2, (int[])new int[]{2}, (int[])new int[0], (int)-1, (int)-1, (item, valueMeta) -> Neo4JOutputDialog.getPropertyNameTypePrimary(item, valueMeta, new int[]{1}, new int[]{3}, -1));
            }
            catch (Exception ex) {
                new ErrorDialog(this.shell, CONST_ERROR, "Error getting transform input fields", ex);
            }
        });
        this.wParameters = new TableView(this.variables, wParametersComp, 67586, parameterColumns, this.input.getParameterMappings().size(), null, this.props);
        PropsUi.setLook((Widget)this.wParameters);
        FormData fdParameters = new FormData();
        fdParameters.left = new FormAttachment(0, 0);
        fdParameters.right = new FormAttachment((Control)wbGetParameters, -this.margin);
        fdParameters.top = new FormAttachment((Control)wlParameters, this.margin);
        fdParameters.bottom = new FormAttachment(100, 0);
        this.wParameters.setLayoutData((Object)fdParameters);
        wParametersComp.layout();
        wParametersTab.setControl((Control)wParametersComp);
    }

    private void addCypherTab() {
        CTabItem wCypherTab = new CTabItem(this.wTabFolder, 0);
        wCypherTab.setFont(GuiResource.getInstance().getFontDefault());
        wCypherTab.setText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Cypher.Label", (String[])new String[0]));
        wCypherTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Cypher.ToolTip", (String[])new String[0]));
        Composite wCypherComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wCypherComp);
        wCypherComp.setLayout(this.createFormLayout());
        Label wlCypher = new Label(wCypherComp, 16384);
        wlCypher.setText("Cypher:");
        PropsUi.setLook((Widget)wlCypher);
        FormData fdlCypher = new FormData();
        fdlCypher.left = new FormAttachment(0, 0);
        fdlCypher.right = new FormAttachment(this.middle, -this.margin);
        fdlCypher.top = new FormAttachment(0, 0);
        wlCypher.setLayoutData((Object)fdlCypher);
        this.wCypher = new Text(wCypherComp, 19202);
        this.wCypher.setFont(GuiResource.getInstance().getFontFixed());
        PropsUi.setLook((Widget)this.wCypher);
        FormData fdCypher = new FormData();
        fdCypher.left = new FormAttachment(0, 0);
        fdCypher.right = new FormAttachment(100, 0);
        fdCypher.top = new FormAttachment((Control)wlCypher, this.margin);
        fdCypher.bottom = new FormAttachment(100, 0);
        this.wCypher.setLayoutData((Object)fdCypher);
        wCypherComp.layout();
        wCypherTab.setControl((Control)wCypherComp);
    }

    private void addReturnsTab() {
        CTabItem wReturnsTab = new CTabItem(this.wTabFolder, 0);
        wReturnsTab.setFont(GuiResource.getInstance().getFontDefault());
        wReturnsTab.setText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Returns.Label", (String[])new String[0]));
        wReturnsTab.setToolTipText(BaseMessages.getString(PKG, (String)"CypherDialog.Tab.Returns.ToolTip", (String[])new String[0]));
        Composite wReturnsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wReturnsComp);
        wReturnsComp.setLayout(this.createFormLayout());
        ColumnInfo[] returnColumns = new ColumnInfo[]{new ColumnInfo("Field name", 1, false), new ColumnInfo("Return type", 2, ValueMetaFactory.getAllValueMetaNames(), false), new ColumnInfo("Source type", 2, GraphPropertyDataType.getNames(), false)};
        Label wlReturns = new Label(wReturnsComp, 16384);
        wlReturns.setText("Returns");
        PropsUi.setLook((Widget)wlReturns);
        FormData fdlReturns = new FormData();
        fdlReturns.left = new FormAttachment(0, 0);
        fdlReturns.right = new FormAttachment(this.middle, -this.margin);
        fdlReturns.top = new FormAttachment(0, 0);
        wlReturns.setLayoutData((Object)fdlReturns);
        Button wbGetReturnFields = new Button(wReturnsComp, 8);
        wbGetReturnFields.setText("Get Output Fields");
        FormData fdbGetReturnFields = new FormData();
        fdbGetReturnFields.right = new FormAttachment(100, 0);
        fdbGetReturnFields.top = new FormAttachment((Control)wlReturns, 0, 1024);
        wbGetReturnFields.setLayoutData((Object)fdbGetReturnFields);
        wbGetReturnFields.addListener(13, e -> this.getReturnValues());
        this.wReturns = new TableView(this.variables, wReturnsComp, 67586, returnColumns, this.input.getReturnValues().size(), null, this.props);
        PropsUi.setLook((Widget)this.wReturns);
        FormData fdReturns = new FormData();
        fdReturns.left = new FormAttachment(0, 0);
        fdReturns.right = new FormAttachment((Control)wbGetReturnFields, 0);
        fdReturns.top = new FormAttachment((Control)wlReturns, this.margin);
        fdReturns.bottom = new FormAttachment(100, 0);
        this.wReturns.setLayoutData((Object)fdReturns);
        wReturnsComp.layout();
        wReturnsTab.setControl((Control)wReturnsComp);
    }

    private Layout createFormLayout() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginLeft = PropsUi.getFormMargin();
        formLayout.marginRight = PropsUi.getFormMargin();
        formLayout.marginTop = PropsUi.getFormMargin();
        formLayout.marginBottom = PropsUi.getFormMargin();
        return formLayout;
    }

    private void enableFields() {
        boolean fromField = this.wCypherFromField.getSelection();
        this.wCypher.setEnabled(!fromField);
        this.wCypherField.setEnabled(fromField);
        boolean usingUnwind = this.wUnwind.getSelection();
        this.wlUnwindMap.setEnabled(usingUnwind);
        this.wUnwindMap.setEnabled(usingUnwind);
        boolean returningGraph = this.wReturnGraph.getSelection();
        this.wlReturnGraphField.setEnabled(returningGraph);
        this.wReturnGraphField.setEnabled(returningGraph);
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    public void getData() {
        TableItem item;
        int i;
        this.wTransformName.setText(Const.NVL((String)this.transformName, (String)""));
        this.wConnection.setText(Const.NVL((String)this.input.getConnectionName(), (String)""));
        this.wReadOnly.setSelection(this.input.isReadOnly());
        this.wRetryOnDisconnect.setSelection(this.input.isRetryingOnDisconnect());
        this.wNrRetriesOnError.setText(Const.NVL((String)this.input.getNrRetriesOnError(), (String)""));
        this.wCypherFromField.setSelection(this.input.isCypherFromField());
        this.wCypherField.setText(Const.NVL((String)this.input.getCypherField(), (String)""));
        try {
            this.wCypherField.setItems(this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName).getFieldNames());
        }
        catch (HopTransformException e) {
            this.log.logError("Error getting fields from previous transform", (Throwable)e);
        }
        this.wUnwind.setSelection(this.input.isUsingUnwind());
        this.wUnwindMap.setText(Const.NVL((String)this.input.getUnwindMapName(), (String)""));
        this.wReturnGraph.setSelection(this.input.isReturningGraph());
        this.wReturnGraphField.setText(Const.NVL((String)this.input.getReturnGraphField(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)this.input.getBatchSize(), (String)""));
        this.wCypher.setText(Const.NVL((String)this.input.getCypher(), (String)""));
        for (i = 0; i < this.input.getParameterMappings().size(); ++i) {
            ParameterMapping mapping = this.input.getParameterMappings().get(i);
            item = this.wParameters.table.getItem(i);
            item.setText(1, Const.NVL((String)mapping.getParameter(), (String)""));
            item.setText(2, Const.NVL((String)mapping.getField(), (String)""));
            item.setText(3, Const.NVL((String)mapping.getNeoType(), (String)""));
        }
        this.wParameters.removeEmptyRows();
        this.wParameters.setRowNums();
        this.wParameters.optWidth(true);
        for (i = 0; i < this.input.getReturnValues().size(); ++i) {
            ReturnValue returnValue = this.input.getReturnValues().get(i);
            item = this.wReturns.table.getItem(i);
            item.setText(1, Const.NVL((String)returnValue.getName(), (String)""));
            item.setText(2, Const.NVL((String)returnValue.getType(), (String)""));
            item.setText(3, Const.NVL((String)returnValue.getSourceType(), (String)""));
        }
        this.wReturns.removeEmptyRows();
        this.wReturns.setRowNums();
        this.wReturns.optWidth(true);
        this.enableFields();
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.input.setChanged();
        this.dispose();
    }

    private void getInfo(CypherMeta meta) {
        meta.setConnectionName(this.wConnection.getText());
        meta.setBatchSize(this.wBatchSize.getText());
        meta.setCypher(this.wCypher.getText());
        meta.setReadOnly(this.wReadOnly.getSelection());
        meta.setRetryingOnDisconnect(this.wRetryOnDisconnect.getSelection());
        meta.setNrRetriesOnError(this.wNrRetriesOnError.getText());
        meta.setCypherFromField(this.wCypherFromField.getSelection());
        meta.setCypherField(this.wCypherField.getText());
        meta.setUsingUnwind(this.wUnwind.getSelection());
        meta.setUnwindMapName(this.wUnwindMap.getText());
        meta.setReturningGraph(this.wReturnGraph.getSelection());
        meta.setReturnGraphField(this.wReturnGraphField.getText());
        ArrayList<ParameterMapping> mappings = new ArrayList<ParameterMapping>();
        for (int i = 0; i < this.wParameters.nrNonEmpty(); ++i) {
            TableItem item = this.wParameters.getNonEmpty(i);
            mappings.add(new ParameterMapping(item.getText(1), item.getText(2), item.getText(3)));
        }
        meta.setParameterMappings(mappings);
        ArrayList<ReturnValue> returnValues = new ArrayList<ReturnValue>();
        for (int i = 0; i < this.wReturns.nrNonEmpty(); ++i) {
            TableItem item = this.wReturns.getNonEmpty(i);
            returnValues.add(new ReturnValue(item.getText(1), item.getText(2), item.getText(3)));
        }
        meta.setReturnValues(returnValues);
    }

    private synchronized void preview() {
        CypherMeta oneMeta = new CypherMeta();
        this.getInfo(oneMeta);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)HopGui.getInstance().getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CypherDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CypherDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getReturnValues() {
        Driver driver = null;
        Session session = null;
        Transaction transaction = null;
        CypherMeta meta = new CypherMeta();
        this.getInfo(meta);
        try {
            NeoConnection neoConnection = (NeoConnection)this.metadataProvider.getSerializer(NeoConnection.class).load(meta.getConnectionName());
            driver = neoConnection.getDriver((ILogChannel)this.log, this.variables);
            session = driver.session();
            transaction = session.beginTransaction();
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (ParameterMapping mapping : meta.getParameterMappings()) {
                parameters.put(this.variables.resolve(mapping.getParameter()), "");
            }
            String cypher = this.variables.resolve(this.wCypher.getText());
            Result result = transaction.run(cypher, parameters);
            if (result.hasNext()) {
                Record record = result.next();
                List fields = record.fields();
                for (Pair fieldPair : fields) {
                    String returnField = (String)fieldPair.key();
                    Value returnValue = (Value)fieldPair.value();
                    Type valueType = returnValue.type();
                    String typeName = valueType.name().replaceAll("_", "").replace("LIST OF ANY?", "LIST");
                    GraphPropertyDataType type = GraphPropertyDataType.parseCode(typeName);
                    int kettleType = type.getHopType();
                    TableItem item = new TableItem(this.wReturns.table, 0);
                    item.setText(1, returnField);
                    item.setText(2, ValueMetaFactory.getValueMetaName((int)kettleType));
                    item.setText(3, type.name());
                }
            }
            this.wReturns.removeEmptyRows();
            this.wReturns.setRowNums();
            this.wReturns.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, CONST_ERROR, "Error getting return values from Cypher statement", e);
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
                transaction.close();
            }
            if (session != null) {
                session.close();
            }
            if (driver != null) {
                driver.close();
            }
        }
    }
}

