/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sortedmerge;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sortedmerge.SortedMerge;
import org.apache.hop.pipeline.transforms.sortedmerge.SortedMergeData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SortedMerge.Injection.", groups={"FIELDS"})
@Transform(id="SortedMerge", image="sortedmerge.svg", name="i18n::SortedMerge.Name", description="i18n::SortedMerge.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::SortedMergeMeta.keyword"}, documentationUrl="/pipeline/transforms/sortedmerge.html")
public class SortedMergeMeta
extends BaseTransformMeta<SortedMerge, SortedMergeData> {
    private static final Class<?> PKG = SortedMergeMeta.class;
    public static final String CONST_FIELD = "field";
    @Injection(name="FIELD_NAME", group="FIELDS")
    private String[] fieldName;
    @Injection(name="ASCENDING", group="FIELDS")
    private boolean[] ascending;

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int nrFields) {
        this.fieldName = new String[nrFields];
        this.ascending = new boolean[nrFields];
    }

    public void setDefault() {
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.fieldName[i] = CONST_FIELD + i;
        }
    }

    public Object clone() {
        SortedMergeMeta retval = (SortedMergeMeta)((Object)super.clone());
        int nrFields = this.fieldName.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrFields);
        System.arraycopy(this.ascending, 0, retval.ascending, 0, nrFields);
        return retval;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)CONST_FIELD);
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)CONST_FIELD, (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                String asc = XmlHandler.getTagValue((Node)fnode, (String)"ascending");
                this.ascending[i] = asc.equalsIgnoreCase("Y");
            }
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to load transform info from XML", (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XmlHandler.addTagValue((String)"ascending", (boolean)this.ascending[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            int idx = inputRowMeta.indexOfValue(this.fieldName[i]);
            if (idx < 0) continue;
            IValueMeta valueMeta = inputRowMeta.getValueMeta(idx);
            valueMeta.setSortedDescending(!this.ascending[i]);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortedMergeMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            Object errorMessage = "";
            boolean errorFound = false;
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                errorMessage = (String)errorMessage + "\t\t" + this.fieldName[i] + Const.CR;
                errorFound = true;
            }
            if (errorFound) {
                errorMessage = BaseMessages.getString(PKG, (String)"SortedMergeMeta.CheckResult.SortKeysNotFound", (String[])new String[]{errorMessage});
                cr = new CheckResult(4, (String)errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortedMergeMeta.CheckResult.AllSortKeysFound", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortedMergeMeta.CheckResult.NoSortKeysEntered", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortedMergeMeta.CheckResult.NoFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"SortedMergeMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SortedMergeMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean[] getAscending() {
        return this.ascending;
    }

    public void setAscending(boolean[] ascending) {
        this.ascending = ascending;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.fieldName == null ? -1 : this.fieldName.length;
        if (nrFields <= 0) {
            return;
        }
        boolean[][] rtn = Utils.normalizeArrays((int)nrFields, (boolean[][])new boolean[][]{this.ascending});
        this.ascending = rtn[0];
    }
}

