/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.io;

public enum LineType {
    UNKNOWN(null),
    ERROR(new byte[]{33}),
    HEADER(new byte[]{37}),
    RESULT(new byte[]{91}),
    PROMPT(new byte[]{1, 1}),
    MORE(new byte[]{1, 2}),
    FILETRANSFER(new byte[]{1, 3}),
    SOHEADER(new byte[]{38}),
    REDIRECT(new byte[]{94}),
    INFO(new byte[]{35});

    private final byte[] bytes;

    private LineType(byte[] byArray) {
        this.bytes = byArray;
    }

    public final byte[] bytes() {
        return this.bytes;
    }

    public static final LineType classify(String string) {
        if (string != null) {
            if (string.length() > 1) {
                return LineType.classify(string.charAt(0), string.charAt(1));
            }
            if (string.length() == 1) {
                return LineType.classify(string.charAt(0), 0);
            }
        }
        return UNKNOWN;
    }

    public static final LineType classify(byte[] byArray) {
        if (byArray != null) {
            if (byArray.length > 1) {
                return LineType.classify(byArray[0], byArray[1]);
            }
            if (byArray.length == 1) {
                return LineType.classify(byArray[0], 0);
            }
        }
        return UNKNOWN;
    }

    private static final LineType classify(int n, int n2) {
        switch (n) {
            case 33: {
                return ERROR;
            }
            case 37: {
                return HEADER;
            }
            case 61: 
            case 91: {
                return RESULT;
            }
            case 38: {
                return SOHEADER;
            }
            case 94: {
                return REDIRECT;
            }
            case 35: {
                return INFO;
            }
            case 1: {
                break;
            }
            default: {
                return UNKNOWN;
            }
        }
        switch (n2) {
            case 1: {
                return PROMPT;
            }
            case 2: {
                return MORE;
            }
            case 3: {
                return FILETRANSFER;
            }
        }
        return UNKNOWN;
    }
}

