/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FileEvent;
import com.ibm.as400.access.FileListener;
import com.ibm.as400.access.IFSFileDescriptorImpl;
import com.ibm.as400.access.IFSFileInputStream;
import com.ibm.as400.access.IFSFileOutputStream;
import com.ibm.as400.access.IFSRandomAccessFile;
import com.ibm.as400.access.IFSTextFileInputStream;
import com.ibm.as400.access.IFSTextFileOutputStream;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public final class IFSFileDescriptor
implements Serializable {
    static final long serialVersionUID = 4L;
    private transient long fileOffset_;
    private transient Object parent_;
    private String path_ = "";
    private int shareOption_;
    private AS400 system_;
    private boolean closed_ = false;
    private transient Object fileOffsetLock_ = new Object();
    private transient IFSFileDescriptorImpl impl_;

    public IFSFileDescriptor() {
    }

    IFSFileDescriptor(AS400 system, String path, int shareOption, Object parent) {
        this.system_ = system;
        this.path_ = path;
        this.shareOption_ = shareOption;
        this.parent_ = parent;
    }

    IFSFileDescriptor(int shareOption, Object parent) {
        this.shareOption_ = shareOption;
        this.parent_ = parent;
    }

    void chooseImpl() {
        if (this.impl_ != null) {
            return;
        }
        this.impl_ = (IFSFileDescriptorImpl)this.system_.loadImpl2("com.ibm.as400.access.IFSFileDescriptorImplRemote", "com.ibm.as400.access.IFSFileDescriptorImplProxy");
        Object parentImpl = null;
        if (this.parent_ != null) {
            String className = this.parent_.getClass().getName();
            if (this.parent_ instanceof IFSFileInputStream) {
                parentImpl = ((IFSFileInputStream)this.parent_).getImpl();
            } else if (this.parent_ instanceof IFSFileOutputStream) {
                parentImpl = ((IFSFileOutputStream)this.parent_).getImpl();
            } else if (this.parent_ instanceof IFSTextFileInputStream) {
                parentImpl = ((IFSTextFileInputStream)this.parent_).getImpl();
            } else if (this.parent_ instanceof IFSTextFileOutputStream) {
                parentImpl = ((IFSTextFileOutputStream)this.parent_).getImpl();
            } else if (this.parent_ instanceof IFSRandomAccessFile) {
                parentImpl = ((IFSRandomAccessFile)this.parent_).getImpl();
            } else {
                Trace.log(2, "IFSFileDescriptor has invalid parent: " + className);
                throw new InternalErrorException(10);
            }
        }
        this.impl_.initialize(this.fileOffset_, parentImpl, this.path_, this.shareOption_, this.system_.getImpl());
    }

    void close() {
        if (this.impl_ != null) {
            this.impl_.close();
        }
        this.closed_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireClosedEvents(Object source, Vector fileListeners) {
        FileEvent event = new FileEvent(source, 0);
        Vector vector = fileListeners;
        synchronized (vector) {
            Enumeration e = fileListeners.elements();
            while (e.hasMoreElements()) {
                FileListener listener = (FileListener)e.nextElement();
                listener.fileClosed(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireModifiedEvents(Object source, Vector fileListeners) {
        FileEvent event = new FileEvent(source, 2);
        Vector vector = fileListeners;
        synchronized (vector) {
            Enumeration e = fileListeners.elements();
            while (e.hasMoreElements()) {
                FileListener listener = (FileListener)e.nextElement();
                listener.fileModified(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fireOpenedEvents(Object source, Vector fileListeners) {
        FileEvent event = new FileEvent(source, 3);
        Vector vector = fileListeners;
        synchronized (vector) {
            Enumeration e = fileListeners.elements();
            while (e.hasMoreElements()) {
                FileListener listener = (FileListener)e.nextElement();
                listener.fileOpened(event);
            }
        }
    }

    IFSFileDescriptorImpl getImpl() {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_;
    }

    int getCCSID() throws IOException {
        if (this.impl_ == null) {
            this.chooseImpl();
        }
        return this.impl_.getCCSID();
    }

    long getFileOffset() {
        if (this.impl_ == null) {
            return this.fileOffset_;
        }
        return this.impl_.getFileOffset();
    }

    String getPath() {
        return this.path_;
    }

    int getShareOption() {
        return this.shareOption_;
    }

    AS400 getSystem() {
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementFileOffset(long fileOffsetIncrement) {
        if (this.impl_ == null) {
            Object object = this.fileOffsetLock_;
            synchronized (object) {
                this.fileOffset_ += fileOffsetIncrement;
            }
        } else {
            this.impl_.incrementFileOffset(fileOffsetIncrement);
        }
    }

    boolean isClosed() {
        return this.closed_;
    }

    boolean isOpen() {
        if (this.impl_ == null) {
            return false;
        }
        return this.impl_.isOpen();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.fileOffset_ = 0L;
        this.parent_ = null;
        this.fileOffsetLock_ = new Object();
        this.impl_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setFileOffset(long fileOffset) {
        if (this.impl_ == null) {
            Object object = this.fileOffsetLock_;
            synchronized (object) {
                this.fileOffset_ = fileOffset;
            }
        } else {
            this.impl_.setFileOffset(fileOffset);
        }
    }

    void setPath(String path) {
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("path", 5);
        }
        this.path_ = path;
    }

    void setShareOption(int shareOption) {
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("shareOption", 5);
        }
        this.shareOption_ = shareOption;
    }

    void setSystem(AS400 system) {
        if (this.impl_ != null) {
            throw new ExtendedIllegalStateException("system", 5);
        }
        this.system_ = system;
    }

    public void sync() throws IOException {
        if (this.impl_ == null) {
            if (this.parent_ == null) {
                Trace.log(2, "Parent is null, nothing to synchronize.");
            } else if (this.parent_ instanceof IFSRandomAccessFile) {
                ((IFSRandomAccessFile)this.parent_).flush();
            } else if (this.parent_ instanceof IFSFileOutputStream) {
                ((IFSFileOutputStream)this.parent_).flush();
            } else {
                Trace.log(2, "Parent does not have a flush() method: " + this.parent_.getClass().getName());
            }
        } else {
            this.impl_.sync();
        }
    }

    public boolean valid() {
        return this.isOpen();
    }
}

