/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model;

import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.agent.tool.ToolSpecifications;
import dev.langchain4j.data.message.ChatMessage;
import java.util.ArrayList;
import java.util.Collections;

public interface Tokenizer {
    public int estimateTokenCountInText(String var1);

    public int estimateTokenCountInMessage(ChatMessage var1);

    public int estimateTokenCountInMessages(Iterable<ChatMessage> var1);

    default public int estimateTokenCountInTools(Object objectWithTools) {
        return this.estimateTokenCountInTools(Collections.singletonList(objectWithTools));
    }

    default public int estimateTokenCountInTools(Iterable<Object> objectsWithTools) {
        ArrayList<ToolSpecification> toolSpecifications = new ArrayList<ToolSpecification>();
        objectsWithTools.forEach(objectWithTools -> toolSpecifications.addAll(ToolSpecifications.toolSpecificationsFrom(objectWithTools)));
        return this.estimateTokenCountInToolSpecifications(toolSpecifications);
    }

    public int estimateTokenCountInToolSpecifications(Iterable<ToolSpecification> var1);

    default public int estimateTokenCountInForcefulToolSpecification(ToolSpecification toolSpecification) {
        return this.estimateTokenCountInToolSpecifications(Collections.singletonList(toolSpecification));
    }

    public int estimateTokenCountInToolExecutionRequests(Iterable<ToolExecutionRequest> var1);

    default public int estimateTokenCountInForcefulToolExecutionRequest(ToolExecutionRequest toolExecutionRequest) {
        return this.estimateTokenCountInToolExecutionRequests(Collections.singletonList(toolExecutionRequest));
    }
}

