/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.row.value;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Comparator;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.apache.hop.core.util.JsonUtil;

@ValueMetaPlugin(id="2", name="String", description="String", image="images/string.svg")
public class ValueMetaString
extends ValueMetaBase {
    public ValueMetaString() {
        this((String)null);
    }

    public ValueMetaString(String name) {
        super(name, 2);
    }

    public ValueMetaString(String name, Comparator<Object> comparator) {
        super(name, 2, comparator);
    }

    public ValueMetaString(String name, int length, int precision) {
        super(name, 2, length, precision);
    }

    @Override
    public JsonNode getJson(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        try {
            if (this.type == 2) {
                switch (this.storageType) {
                    case 2: {
                        object = this.index[(Integer)object];
                    }
                    case 0: 
                    case 1: {
                        return JsonUtil.parseTextValue(object);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HopValueException("Error converting value to JSON (" + String.valueOf(object) + ")", e);
        }
        return super.getJson(object);
    }

    @Override
    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getString(object);
    }

    @Override
    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return String.class;
    }
}

