/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.vfs.minio;

import lombok.Generated;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;

public class MinioFileName
extends AbstractFileName {
    public static final String DELIMITER = "/";
    private final String bucketId;
    private String bucketRelativePath;

    public MinioFileName(String scheme, String bucketId, String path, FileType type) {
        super(scheme, path, type);
        this.bucketId = bucketId;
        if (path.length() > 1) {
            this.bucketRelativePath = path.substring(1);
            if (this.bucketRelativePath.startsWith(bucketId)) {
                this.bucketRelativePath = this.bucketRelativePath.substring(bucketId.length());
            }
            if (this.bucketRelativePath.startsWith(DELIMITER)) {
                this.bucketRelativePath = this.bucketRelativePath.substring(DELIMITER.length());
            }
            if (type.equals((Object)FileType.FOLDER)) {
                this.bucketRelativePath = this.bucketRelativePath + DELIMITER;
            }
        } else {
            this.bucketRelativePath = "";
        }
    }

    public String getURI() {
        StringBuilder buffer = new StringBuilder();
        this.appendRootUri(buffer, false);
        buffer.append(this.getPath());
        return buffer.toString();
    }

    public FileName createName(String absPath, FileType type) {
        return new MinioFileName(this.getScheme(), this.bucketId, absPath, type);
    }

    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
    }

    @Generated
    public String getBucketId() {
        return this.bucketId;
    }

    @Generated
    public String getBucketRelativePath() {
        return this.bucketRelativePath;
    }

    @Generated
    public void setBucketRelativePath(String bucketRelativePath) {
        this.bucketRelativePath = bucketRelativePath;
    }
}

