/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.file.datalake.implementation.models.BlobItemInternal;
import com.azure.storage.file.datalake.implementation.models.BlobPrefix;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class BlobHierarchyListSegment
implements XmlSerializable<BlobHierarchyListSegment> {
    private List<BlobPrefix> blobPrefixes = new ArrayList<BlobPrefix>();
    private List<BlobItemInternal> blobItems = new ArrayList<BlobItemInternal>();

    public List<BlobPrefix> getBlobPrefixes() {
        return this.blobPrefixes;
    }

    public BlobHierarchyListSegment setBlobPrefixes(List<BlobPrefix> blobPrefixes) {
        this.blobPrefixes = blobPrefixes;
        return this;
    }

    public List<BlobItemInternal> getBlobItems() {
        return this.blobItems;
    }

    public BlobHierarchyListSegment setBlobItems(List<BlobItemInternal> blobItems) {
        this.blobItems = blobItems;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Blobs" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.blobPrefixes != null) {
            for (BlobPrefix blobPrefix : this.blobPrefixes) {
                xmlWriter.writeXml((XmlSerializable)blobPrefix, "BlobPrefix");
            }
        }
        if (this.blobItems != null) {
            for (BlobItemInternal blobItemInternal : this.blobItems) {
                xmlWriter.writeXml((XmlSerializable)blobItemInternal, "Blob");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static BlobHierarchyListSegment fromXml(XmlReader xmlReader) throws XMLStreamException {
        return BlobHierarchyListSegment.fromXml(xmlReader, null);
    }

    public static BlobHierarchyListSegment fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "Blobs" : rootElementName;
        return (BlobHierarchyListSegment)xmlReader.readObject(finalRootElementName, reader -> {
            BlobHierarchyListSegment deserializedBlobHierarchyListSegment = new BlobHierarchyListSegment();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("BlobPrefix".equals(elementName.getLocalPart())) {
                    if (deserializedBlobHierarchyListSegment.blobPrefixes == null) {
                        deserializedBlobHierarchyListSegment.blobPrefixes = new ArrayList<BlobPrefix>();
                    }
                    deserializedBlobHierarchyListSegment.blobPrefixes.add(BlobPrefix.fromXml(reader, "BlobPrefix"));
                    continue;
                }
                if ("Blob".equals(elementName.getLocalPart())) {
                    if (deserializedBlobHierarchyListSegment.blobItems == null) {
                        deserializedBlobHierarchyListSegment.blobItems = new ArrayList<BlobItemInternal>();
                    }
                    deserializedBlobHierarchyListSegment.blobItems.add(BlobItemInternal.fromXml(reader, "Blob"));
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlobHierarchyListSegment;
        });
    }
}

