/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.action;

import java.util.HashMap;
import java.util.Map;
import org.apache.hop.base.IBaseMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.IAttributes;
import org.apache.hop.core.attributes.AttributesUtil;
import org.apache.hop.core.changed.IChanged;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.plugins.ActionPluginType;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.copy.CopyContext;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.copy.DefaultActionCopyFactory;
import org.apache.hop.workflow.actions.missing.MissingAction;
import org.w3c.dom.Node;

public class ActionMeta
implements Cloneable,
IGuiPosition,
IChanged,
IAttributes,
IBaseMeta {
    public static final String XML_TAG = "action";
    private static final String XML_ATTRIBUTE_WORKFLOW_ACTION_COPY = "attributes_hac";
    private static final String CONST_SPACE = "      ";
    private IAction action;
    private String suggestion = "";
    private boolean selected;
    private boolean isDeprecated;
    private Point location;
    private boolean launchingInParallel;
    private WorkflowMeta parentWorkflowMeta;
    private Map<String, Map<String, String>> attributesMap;

    public ActionMeta() {
        this.clear();
    }

    public ActionMeta(IAction action) {
        this();
        this.setAction(action);
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(100);
        xml.append("    ").append(XmlHandler.openTag((String)XML_TAG)).append(Const.CR);
        this.action.setParentWorkflowMeta(this.parentWorkflowMeta);
        xml.append(this.action.getXml());
        xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"parallel", (boolean)this.launchingInParallel));
        xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"xloc", (int)this.location.x));
        xml.append(CONST_SPACE).append(XmlHandler.addTagValue((String)"yloc", (int)this.location.y));
        xml.append(AttributesUtil.getAttributesXml(this.attributesMap, XML_ATTRIBUTE_WORKFLOW_ACTION_COPY));
        xml.append("    ").append(XmlHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public ActionMeta(Node actionNode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            String pluginId = XmlHandler.getTagValue((Node)actionNode, (String)"type");
            PluginRegistry registry = PluginRegistry.getInstance();
            IPlugin actionPlugin = registry.findPluginWithId(ActionPluginType.class, pluginId, true);
            if (actionPlugin == null) {
                String name = XmlHandler.getTagValue((Node)actionNode, (String)"name");
                this.setAction(new MissingAction(name, pluginId));
            } else {
                this.setAction((IAction)registry.loadClass(actionPlugin, IAction.class));
            }
            if (this.action != null) {
                if (actionPlugin != null) {
                    this.action.setPluginId(actionPlugin.getIds()[0]);
                    this.suggestion = Const.NVL((String)actionPlugin.getSuggestion(), (String)"");
                }
                this.action.setMetadataProvider(metadataProvider);
                this.action.loadXml(actionNode, metadataProvider, variables);
                this.setLaunchingInParallel("Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)actionNode, (String)"parallel")));
                int x = Const.toInt((String)XmlHandler.getTagValue((Node)actionNode, (String)"xloc"), (int)0);
                int y = Const.toInt((String)XmlHandler.getTagValue((Node)actionNode, (String)"yloc"), (int)0);
                this.setLocation(x, y);
                Node actionCopyAttributesNode = XmlHandler.getSubNode((Node)actionNode, (String)XML_ATTRIBUTE_WORKFLOW_ACTION_COPY);
                this.attributesMap = actionCopyAttributesNode != null ? AttributesUtil.loadAttributes(actionCopyAttributesNode) : AttributesUtil.loadAttributes(XmlHandler.getLastSubNode((Node)actionNode, (String)"attributes"));
            }
        }
        catch (Throwable e) {
            String message = "Unable to read Workflow action copy info from XML node : " + String.valueOf(e);
            throw new HopXmlException(message, e);
        }
    }

    public void clear() {
        this.location = new Point(0, 0);
        this.action = null;
        this.launchingInParallel = false;
        this.attributesMap = new HashMap<String, Map<String, String>>();
    }

    public ActionMeta clone() {
        ActionMeta ge = new ActionMeta();
        ge.replaceMeta(this);
        for (Map.Entry<String, Map<String, String>> attribute : this.attributesMap.entrySet()) {
            ge.attributesMap.put(attribute.getKey(), attribute.getValue());
        }
        return ge;
    }

    public void replaceMeta(ActionMeta actionCopy) {
        this.action = DefaultActionCopyFactory.getInstance().copy(actionCopy.action, CopyContext.SAME_PIPELINE);
        this.selected = actionCopy.selected;
        if (actionCopy.location != null) {
            this.location = new Point(actionCopy.location.x, actionCopy.location.y);
        }
        this.launchingInParallel = actionCopy.launchingInParallel;
        this.setChanged();
    }

    public Object cloneDeep() {
        ActionMeta ge = this.clone();
        ge.action = (IAction)this.action.clone();
        return ge;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        ActionMeta je = (ActionMeta)o;
        return je.action.getName().equalsIgnoreCase(this.action.getName());
    }

    public int hashCode() {
        return this.action.getName().hashCode();
    }

    public void setAction(IAction action) {
        this.action = action;
        if (action != null) {
            Deprecated deprecated;
            if (action.getPluginId() == null) {
                action.setPluginId(PluginRegistry.getInstance().getPluginId(ActionPluginType.class, (Object)action));
            }
            if ((deprecated = action.getClass().getDeclaredAnnotation(Deprecated.class)) != null) {
                this.isDeprecated = true;
            }
        }
    }

    public IAction getAction() {
        return this.action;
    }

    public String getTypeDesc() {
        IPlugin plugin = PluginRegistry.getInstance().findPluginWithId(ActionPluginType.class, this.action.getPluginId());
        return plugin.getDescription();
    }

    public void setLocation(int x, int y) {
        int ny;
        int nx = x >= 0 ? x : 0;
        Point loc = new Point(nx, ny = y >= 0 ? y : 0);
        if (!loc.equals((Object)this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    public void setLocation(Point loc) {
        if (loc != null && !loc.equals((Object)this.location)) {
            this.setChanged();
        }
        this.location = loc;
    }

    @Override
    public Point getLocation() {
        return this.location;
    }

    @Override
    public void setChanged() {
        this.setChanged(true);
    }

    @Override
    public void setChanged(boolean ch) {
        this.action.setChanged(ch);
    }

    @Override
    public void clearChanged() {
        this.action.setChanged(false);
    }

    @Override
    public boolean hasChanged() {
        return this.action.hasChanged();
    }

    public void setLaunchingInParallel(boolean p) {
        this.launchingInParallel = p;
    }

    public boolean isLaunchingInParallel() {
        return this.launchingInParallel;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setDescription(String description) {
        this.action.setDescription(description);
    }

    public String getDescription() {
        return this.action.getDescription();
    }

    public boolean isStart() {
        return this.action.isStart();
    }

    public boolean isJoin() {
        return this.action.isJoin();
    }

    public boolean isMissing() {
        return this.action instanceof MissingAction;
    }

    public boolean isPipeline() {
        return this.action.isPipeline();
    }

    public boolean isWorkflow() {
        return this.action.isWorkflow();
    }

    public boolean isEvaluation() {
        if (this.action != null) {
            return this.action.isEvaluation();
        }
        return false;
    }

    public boolean isUnconditional() {
        if (this.action != null) {
            return this.action.isUnconditional();
        }
        return true;
    }

    public String toString() {
        if (this.action != null) {
            return this.action.getName();
        }
        return "null";
    }

    public String getName() {
        if (this.action != null) {
            return this.action.getName();
        }
        return "null";
    }

    public void setName(String name) {
        this.action.setName(name);
    }

    public boolean resetErrorsBeforeExecution() {
        return this.action.resetErrorsBeforeExecution();
    }

    public WorkflowMeta getParentWorkflowMeta() {
        return this.parentWorkflowMeta;
    }

    public void setParentWorkflowMeta(WorkflowMeta parentWorkflowMeta) {
        this.parentWorkflowMeta = parentWorkflowMeta;
        this.action.setParentWorkflowMeta(parentWorkflowMeta);
    }

    public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Map<String, Map<String, String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttribute(String groupName, String key, String value) {
        Map<String, String> attributes = this.getAttributes(groupName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.attributesMap.put(groupName, attributes);
        }
        attributes.put(key, value);
    }

    public void setAttributes(String groupName, Map<String, String> attributes) {
        this.attributesMap.put(groupName, attributes);
    }

    public Map<String, String> getAttributes(String groupName) {
        return this.attributesMap.get(groupName);
    }

    public String getAttribute(String groupName, String key) {
        Map<String, String> attributes = this.attributesMap.get(groupName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public String getSuggestion() {
        return this.suggestion;
    }
}

