/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.launcher;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class CommandBuilderUtils {
    static final String DEFAULT_MEM = "1g";
    static final String DEFAULT_PROPERTIES_FILE = "spark-defaults.conf";
    static final String ENV_SPARK_HOME = "SPARK_HOME";

    CommandBuilderUtils() {
    }

    static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    static String join(String sep, String ... elements) {
        StringBuilder sb = new StringBuilder();
        for (String e : elements) {
            if (e == null) continue;
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(e);
        }
        return sb.toString();
    }

    static String join(String sep, Iterable<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (String e : elements) {
            if (e == null) continue;
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(e);
        }
        return sb.toString();
    }

    static String firstNonEmptyValue(String key, Map<?, ?> ... maps) {
        for (Map<?, ?> map : maps) {
            String value = (String)map.get(key);
            if (CommandBuilderUtils.isEmpty(value)) continue;
            return value;
        }
        return null;
    }

    static String firstNonEmpty(String ... candidates) {
        for (String s : candidates) {
            if (CommandBuilderUtils.isEmpty(s)) continue;
            return s;
        }
        return null;
    }

    static String getLibPathEnvName() {
        if (CommandBuilderUtils.isWindows()) {
            return "PATH";
        }
        String os = System.getProperty("os.name");
        if (os.startsWith("Mac OS X")) {
            return "DYLD_LIBRARY_PATH";
        }
        return "LD_LIBRARY_PATH";
    }

    static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os.startsWith("Windows");
    }

    static void mergeEnvPathList(Map<String, String> userEnv, String envKey, String pathList) {
        if (!CommandBuilderUtils.isEmpty(pathList)) {
            String current = CommandBuilderUtils.firstNonEmpty(userEnv.get(envKey), System.getenv(envKey));
            userEnv.put(envKey, CommandBuilderUtils.join(File.pathSeparator, current, pathList));
        }
    }

    static List<String> parseOptionString(String s) {
        ArrayList<String> opts = new ArrayList<String>();
        StringBuilder opt = new StringBuilder();
        boolean inOpt = false;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean escapeNext = false;
        boolean hasData = false;
        block10: for (int i = 0; i < s.length(); ++i) {
            int c = s.codePointAt(i);
            if (escapeNext) {
                opt.appendCodePoint(c);
                escapeNext = false;
                continue;
            }
            if (inOpt) {
                switch (c) {
                    case 92: {
                        if (inSingleQuote) {
                            opt.appendCodePoint(c);
                            break;
                        }
                        escapeNext = true;
                        break;
                    }
                    case 39: {
                        if (inDoubleQuote) {
                            opt.appendCodePoint(c);
                            break;
                        }
                        inSingleQuote = !inSingleQuote;
                        break;
                    }
                    case 34: {
                        if (inSingleQuote) {
                            opt.appendCodePoint(c);
                            break;
                        }
                        inDoubleQuote = !inDoubleQuote;
                        break;
                    }
                    default: {
                        if (!Character.isWhitespace(c) || inSingleQuote || inDoubleQuote) {
                            opt.appendCodePoint(c);
                            break;
                        }
                        opts.add(opt.toString());
                        opt.setLength(0);
                        inOpt = false;
                        hasData = false;
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case 39: {
                    inSingleQuote = true;
                    inOpt = true;
                    hasData = true;
                    continue block10;
                }
                case 34: {
                    inDoubleQuote = true;
                    inOpt = true;
                    hasData = true;
                    continue block10;
                }
                case 92: {
                    escapeNext = true;
                    inOpt = true;
                    hasData = true;
                    continue block10;
                }
                default: {
                    if (Character.isWhitespace(c)) continue block10;
                    inOpt = true;
                    hasData = true;
                    opt.appendCodePoint(c);
                }
            }
        }
        CommandBuilderUtils.checkArgument(!inSingleQuote && !inDoubleQuote && !escapeNext, "Invalid option string: %s", s);
        if (hasData) {
            opts.add(opt.toString());
        }
        return opts;
    }

    static void checkNotNull(Object o, String arg) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("'%s' must not be null.", arg));
        }
    }

    static void checkArgument(boolean check, String msg, Object ... args) {
        if (!check) {
            throw new IllegalArgumentException(String.format(msg, args));
        }
    }

    static void checkState(boolean check, String msg, Object ... args) {
        if (!check) {
            throw new IllegalStateException(String.format(msg, args));
        }
    }

    static String quoteForBatchScript(String arg) {
        boolean needsQuotes = false;
        for (int i = 0; i < arg.length(); ++i) {
            int c = arg.codePointAt(i);
            if (!Character.isWhitespace(c) && c != 34 && c != 61 && c != 44 && c != 59) continue;
            needsQuotes = true;
            break;
        }
        if (!needsQuotes) {
            return arg;
        }
        StringBuilder quoted = new StringBuilder();
        quoted.append("\"");
        for (int i = 0; i < arg.length(); ++i) {
            int cp = arg.codePointAt(i);
            switch (cp) {
                case 34: {
                    quoted.append('\"');
                    break;
                }
            }
            quoted.appendCodePoint(cp);
        }
        if (arg.codePointAt(arg.length() - 1) == 92) {
            quoted.append("\\");
        }
        quoted.append("\"");
        return quoted.toString();
    }

    static String quoteForCommandString(String s) {
        StringBuilder quoted = new StringBuilder().append('\"');
        for (int i = 0; i < s.length(); ++i) {
            int cp = s.codePointAt(i);
            if (cp == 34 || cp == 92) {
                quoted.appendCodePoint(92);
            }
            quoted.appendCodePoint(cp);
        }
        return quoted.append('\"').toString();
    }

    static int javaMajorVersion(String javaVersion) {
        String[] version = javaVersion.split("[+.\\-]+");
        int major = Integer.parseInt(version[0]);
        if (major > 1) {
            return major;
        }
        return Integer.parseInt(version[1]);
    }

    static String findJarsDir(String sparkHome, String scalaVersion, boolean failIfNotFound) {
        File libdir = new File(sparkHome, "jars");
        if (!libdir.isDirectory() && !(libdir = new File(sparkHome, String.format("assembly/target/scala-%s/jars", scalaVersion))).isDirectory()) {
            CommandBuilderUtils.checkState(!failIfNotFound, "Library directory '%s' does not exist; make sure Spark is built.", libdir.getAbsolutePath());
            return null;
        }
        return libdir.getAbsolutePath();
    }
}

