/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.server;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.registry.impl.ZkRegistryBase;
import org.apache.hive.service.server.HS2ActivePassiveHARegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HS2ActivePassiveHARegistryClient {
    private static final Logger LOG = LoggerFactory.getLogger(HS2ActivePassiveHARegistryClient.class);
    private static final Map<String, HS2ActivePassiveHARegistry> hs2Registries = new HashMap<String, HS2ActivePassiveHARegistry>();

    public static synchronized HS2ActivePassiveHARegistry getClient(Configuration conf) throws IOException {
        String namespace = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SERVER2_ACTIVE_PASSIVE_HA_REGISTRY_NAMESPACE);
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)namespace) ? 1 : 0) != 0, (Object)(HiveConf.ConfVars.HIVE_SERVER2_ACTIVE_PASSIVE_HA_REGISTRY_NAMESPACE.varname + " cannot be null or empty"));
        String nsKey = ZkRegistryBase.getRootNamespace((Configuration)conf, null, (String)(namespace + "-"));
        HS2ActivePassiveHARegistry registry = hs2Registries.get(nsKey);
        if (registry == null) {
            registry = HS2ActivePassiveHARegistry.create(conf, true);
            registry.start();
            hs2Registries.put(nsKey, registry);
            LOG.info("Added registry client to cache with namespace: {}", (Object)nsKey);
        } else {
            LOG.info("Returning cached registry client for namespace: {}", (Object)nsKey);
        }
        return registry;
    }
}

