/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.expr;

import com.healthmarketscience.jackcess.expr.LocaleContext;
import com.healthmarketscience.jackcess.expr.Value;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.expr.BaseValue;
import com.healthmarketscience.jackcess.impl.expr.ValueSupport;
import java.math.BigDecimal;
import java.time.LocalDateTime;

public class DateTimeValue
extends BaseValue {
    private final Value.Type _type;
    private final LocalDateTime _val;

    public DateTimeValue(Value.Type type, LocalDateTime val) {
        if (!type.isTemporal()) {
            throw new IllegalArgumentException("invalid date/time type");
        }
        this._type = type;
        this._val = val;
    }

    @Override
    public Value.Type getType() {
        return this._type;
    }

    @Override
    public Object get() {
        return this._val;
    }

    protected Double getNumber(LocaleContext ctx) {
        return ColumnImpl.toDateDouble(this._val);
    }

    @Override
    public boolean getAsBoolean(LocaleContext ctx) {
        return true;
    }

    @Override
    public String getAsString(LocaleContext ctx) {
        return ValueSupport.getDateFormatForType(ctx, this.getType()).format(this._val);
    }

    @Override
    public LocalDateTime getAsLocalDateTime(LocaleContext ctx) {
        return this._val;
    }

    @Override
    public Value getAsDateTimeValue(LocaleContext ctx) {
        return this;
    }

    @Override
    public Integer getAsLongInt(LocaleContext ctx) {
        return this.roundToLongInt(ctx);
    }

    @Override
    public Double getAsDouble(LocaleContext ctx) {
        return this.getNumber(ctx);
    }

    @Override
    public BigDecimal getAsBigDecimal(LocaleContext ctx) {
        return BigDecimal.valueOf(this.getNumber(ctx));
    }
}

