/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.NoSuchElementException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class CompressedSource<T>
extends FileBasedSource<T> {
    private final FileBasedSource<T> sourceDelegate;
    private final DecompressingChannelFactory channelFactory;

    public static <T> CompressedSource<T> from(FileBasedSource<T> sourceDelegate) {
        return new CompressedSource<T>(sourceDelegate, CompressionMode.AUTO);
    }

    public CompressedSource<T> withDecompression(DecompressingChannelFactory channelFactory) {
        return new CompressedSource<T>(this.sourceDelegate, channelFactory);
    }

    public CompressedSource<T> withCompression(Compression compression) {
        return this.withDecompression(CompressionMode.fromCanonical(compression));
    }

    private CompressedSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory) {
        super(sourceDelegate.getFileOrPatternSpecProvider(), sourceDelegate.getEmptyMatchTreatment(), Long.MAX_VALUE);
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
    }

    private CompressedSource(FileBasedSource<T> sourceDelegate, DecompressingChannelFactory channelFactory, MatchResult.Metadata metadata, long minBundleSize, long startOffset, long endOffset) {
        super(metadata, minBundleSize, startOffset, endOffset);
        boolean splittable;
        this.sourceDelegate = sourceDelegate;
        this.channelFactory = channelFactory;
        try {
            splittable = this.isSplittable();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to determine if the source is splittable", e);
        }
        Preconditions.checkArgument((splittable || startOffset == 0L ? 1 : 0) != 0, (String)"CompressedSources must start reading at offset 0. Requested offset: %s", (long)startOffset);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkNotNull(this.sourceDelegate);
        this.sourceDelegate.validate();
        Preconditions.checkNotNull((Object)this.channelFactory);
    }

    @Override
    protected FileBasedSource<T> createForSubrangeOfFile(MatchResult.Metadata metadata, long start, long end) {
        return new CompressedSource<T>(this.sourceDelegate.createForSubrangeOfFile(metadata, start, end), this.channelFactory, metadata, this.sourceDelegate.getMinBundleSize(), start, end);
    }

    @Override
    protected final boolean isSplittable() {
        try {
            if (!this.sourceDelegate.isSplittable()) {
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.channelFactory == CompressionMode.UNCOMPRESSED) {
            return true;
        }
        if (this.channelFactory == CompressionMode.AUTO) {
            return !Compression.AUTO.isCompressed(this.getFileOrPatternSpec());
        }
        return false;
    }

    @Override
    protected final FileBasedSource.FileBasedReader<T> createSingleFileReader(PipelineOptions options) {
        if (this.isSplittable()) {
            return this.sourceDelegate.createSingleFileReader(options);
        }
        return new CompressedReader<T>(this, this.sourceDelegate.createSingleFileReader(options));
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        builder.include("source", this.sourceDelegate).add(DisplayData.item("source", this.sourceDelegate.getClass()).withLabel("Read Source"));
        if (this.channelFactory instanceof Enum) {
            builder.add(DisplayData.item("compressionMode", ((Enum)((Object)this.channelFactory)).name()).withLabel("Compression Mode"));
        } else {
            builder.add(DisplayData.item("compressionMode", this.channelFactory.getClass()).withLabel("Compression Mode"));
        }
    }

    @Override
    public final Coder<T> getOutputCoder() {
        return this.sourceDelegate.getOutputCoder();
    }

    public final DecompressingChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public static class CompressedReader<T>
    extends FileBasedSource.FileBasedReader<T> {
        private final FileBasedSource.FileBasedReader<T> readerDelegate;
        private final Object progressLock = new Object();
        @GuardedBy(value="progressLock")
        private long numRecordsRead;
        @GuardedBy(value="progressLock")
        private @Nullable CountingChannel channel;
        private DecompressingChannelFactory channelFactory;

        public CompressedReader(CompressedSource<T> source, FileBasedSource.FileBasedReader<T> readerDelegate) {
            super(source);
            this.channelFactory = source.getChannelFactory();
            this.readerDelegate = readerDelegate;
        }

        @Override
        public T getCurrent() throws NoSuchElementException {
            return this.readerDelegate.getCurrent();
        }

        @Override
        public boolean allowsDynamicSplitting() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final long getSplitPointsConsumed() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.isDone() && this.numRecordsRead > 0L ? 1L : 0L;
            }
        }

        @Override
        public final long getSplitPointsRemaining() {
            return this.isDone() ? 0L : 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final boolean isAtSplitPoint() {
            Object object = this.progressLock;
            synchronized (object) {
                return this.numRecordsRead == 1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void startReading(ReadableByteChannel channel) throws IOException {
            Object object = this.progressLock;
            synchronized (object) {
                this.channel = new CountingChannel(channel, this.getCurrentSource().getStartOffset());
                channel = this.channel;
            }
            if (this.channelFactory == CompressionMode.AUTO) {
                this.readerDelegate.startReading(Compression.detect(((FileBasedSource)this.getCurrentSource()).getFileOrPatternSpec()).readDecompressed(channel));
            } else {
                this.readerDelegate.startReading(this.channelFactory.createDecompressingChannel(channel));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final boolean readNextRecord() throws IOException {
            if (!this.readerDelegate.readNextRecord()) {
                return false;
            }
            Object object = this.progressLock;
            synchronized (object) {
                ++this.numRecordsRead;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final long getCurrentOffset() throws NoSuchElementException {
            Object object = this.progressLock;
            synchronized (object) {
                if (this.numRecordsRead <= 1L) {
                    return 0L;
                }
                return this.channel.getCount();
            }
        }

        @Override
        public Instant getCurrentTimestamp() throws NoSuchElementException {
            return this.readerDelegate.getCurrentTimestamp();
        }

        private static class CountingChannel
        implements ReadableByteChannel {
            long count;
            private final ReadableByteChannel inner;

            public CountingChannel(ReadableByteChannel inner, long count) {
                this.inner = inner;
                this.count = count;
            }

            public long getCount() {
                return this.count;
            }

            @Override
            public int read(ByteBuffer dst) throws IOException {
                int bytes = this.inner.read(dst);
                if (bytes > 0) {
                    this.count += (long)bytes;
                }
                return bytes;
            }

            @Override
            public boolean isOpen() {
                return this.inner.isOpen();
            }

            @Override
            public void close() throws IOException {
                this.inner.close();
            }
        }
    }

    @Deprecated
    public static enum CompressionMode implements DecompressingChannelFactory
    {
        UNCOMPRESSED(Compression.UNCOMPRESSED),
        AUTO(Compression.AUTO),
        GZIP(Compression.GZIP),
        BZIP2(Compression.BZIP2),
        ZIP(Compression.ZIP),
        ZSTD(Compression.ZSTD),
        LZO(Compression.LZO),
        LZOP(Compression.LZOP),
        DEFLATE(Compression.DEFLATE),
        SNAPPY(Compression.SNAPPY);

        private final Compression canonical;

        private CompressionMode(Compression canonical) {
            this.canonical = canonical;
        }

        public boolean matches(String fileName) {
            return this.canonical.matches(fileName);
        }

        @Override
        public ReadableByteChannel createDecompressingChannel(ReadableByteChannel channel) throws IOException {
            return this.canonical.readDecompressed(channel);
        }

        public static boolean isCompressed(String filename) {
            return Compression.AUTO.isCompressed(filename);
        }

        static DecompressingChannelFactory fromCanonical(Compression compression) {
            switch (compression) {
                case AUTO: {
                    return AUTO;
                }
                case UNCOMPRESSED: {
                    return UNCOMPRESSED;
                }
                case GZIP: {
                    return GZIP;
                }
                case BZIP2: {
                    return BZIP2;
                }
                case ZIP: {
                    return ZIP;
                }
                case ZSTD: {
                    return ZSTD;
                }
                case LZO: {
                    return LZO;
                }
                case LZOP: {
                    return LZOP;
                }
                case DEFLATE: {
                    return DEFLATE;
                }
                case SNAPPY: {
                    return SNAPPY;
                }
            }
            throw new IllegalArgumentException("Unsupported compression type: " + (Object)((Object)compression));
        }
    }

    public static interface DecompressingChannelFactory
    extends Serializable {
        public ReadableByteChannel createDecompressingChannel(ReadableByteChannel var1) throws IOException;
    }
}

