/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Objects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Optional;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CombineFns {
    public static ComposeCombineFnBuilder compose() {
        return new ComposeCombineFnBuilder();
    }

    private static <OutputT> void checkUniqueness(List<TupleTag<?>> registeredTags, TupleTag<OutputT> outputTag) {
        Preconditions.checkArgument((!registeredTags.contains(outputTag) ? 1 : 0) != 0, (String)"Cannot compose with tuple tag %s because it is already present in the composition.", outputTag);
    }

    private static void populateDisplayData(DisplayData.Builder builder, List<? extends HasDisplayData> combineFns) {
        for (int i = 0; i < combineFns.size(); ++i) {
            HasDisplayData combineFn = combineFns.get(i);
            String token = "combineFn" + (i + 1);
            builder.add(DisplayData.item(token, combineFn.getClass()).withLabel("Combine Function"));
            builder.include(token, combineFn);
        }
    }

    private static class ComposedAccumulatorCoder
    extends StructuredCoder<Object[]> {
        private List<Coder<Object>> coders;
        private int codersCount;

        public ComposedAccumulatorCoder(List<Coder<Object>> coders) {
            this.coders = ImmutableList.copyOf(coders);
            this.codersCount = coders.size();
        }

        @Override
        public void encode(Object[] value, OutputStream outStream) throws CoderException, IOException {
            this.encode(value, outStream, Coder.Context.NESTED);
        }

        @Override
        public void encode(Object[] value, OutputStream outStream, Coder.Context context) throws CoderException, IOException {
            Preconditions.checkArgument((value.length == this.codersCount ? 1 : 0) != 0);
            if (value.length == 0) {
                return;
            }
            int lastIndex = this.codersCount - 1;
            for (int i = 0; i < lastIndex; ++i) {
                this.coders.get(i).encode(value[i], outStream);
            }
            this.coders.get(lastIndex).encode(value[lastIndex], outStream, context);
        }

        @Override
        public Object[] decode(InputStream inStream) throws CoderException, IOException {
            return this.decode(inStream, Coder.Context.NESTED);
        }

        @Override
        public Object[] decode(InputStream inStream, Coder.Context context) throws CoderException, IOException {
            Object[] ret = new Object[this.codersCount];
            if (this.codersCount == 0) {
                return ret;
            }
            int lastIndex = this.codersCount - 1;
            for (int i = 0; i < lastIndex; ++i) {
                ret[i] = this.coders.get(i).decode(inStream);
            }
            ret[lastIndex] = this.coders.get(lastIndex).decode(inStream, context);
            return ret;
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return this.coders;
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            for (int i = 0; i < this.codersCount; ++i) {
                this.coders.get(i).verifyDeterministic();
            }
        }
    }

    private static class ProjectionIterable
    implements Iterable<Object> {
        private final Iterable<Object[]> iterable;
        private final int column;

        private ProjectionIterable(Iterable<Object[]> iterable, int column) {
            this.iterable = iterable;
            this.column = column;
        }

        @Override
        public Iterator<Object> iterator() {
            final Iterator<Object[]> iter = this.iterable.iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return iter.hasNext();
                }

                @Override
                public Object next() {
                    return ((Object[])iter.next())[column];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    public static class ComposedCombineFnWithContext<DataT>
    extends CombineWithContext.CombineFnWithContext<DataT, Object[], CoCombineResult> {
        private final List<SerializableFunction<DataT, Object>> extractInputFns;
        private final List<Optional<Coder>> combineInputCoders;
        private final List<CombineWithContext.CombineFnWithContext<Object, Object, Object>> combineFnWithContexts;
        private final List<TupleTag<?>> outputTags;
        private final int combineFnCount;

        private ComposedCombineFnWithContext() {
            this.extractInputFns = ImmutableList.of();
            this.combineInputCoders = ImmutableList.of();
            this.combineFnWithContexts = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedCombineFnWithContext(ImmutableList<SerializableFunction<DataT, ?>> extractInputFns, ImmutableList<Optional<Coder>> combineInputCoders, ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>> combineFnWithContexts, ImmutableList<TupleTag<?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            this.combineInputCoders = combineInputCoders;
            ImmutableList<CombineWithContext.CombineFnWithContext<?, ?, ?>> castedCombineFnWithContexts = combineFnWithContexts;
            this.combineFnWithContexts = castedCombineFnWithContexts;
            this.outputTags = outputTags;
            this.combineFnCount = this.combineFnWithContexts.size();
        }

        public <InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, CombineFnBase.GlobalCombineFn<InputT, ?, OutputT> globalCombineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFnWithContext<DataT>(ImmutableList.builder().addAll(this.extractInputFns).add(extractInputFn).build(), (ImmutableList<Optional<Coder>>)ImmutableList.builder().addAll(this.combineInputCoders).add((Object)Optional.absent()).build(), ImmutableList.builder().addAll(this.combineFnWithContexts).add(CombineFnUtil.toFnWithContext(globalCombineFn)).build(), ImmutableList.builder().addAll(this.outputTags).add(outputTag).build());
        }

        public <InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Coder<InputT> combineInputCoder, CombineFnBase.GlobalCombineFn<InputT, ?, OutputT> globalCombineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFnWithContext<DataT>(ImmutableList.builder().addAll(this.extractInputFns).add(extractInputFn).build(), (ImmutableList<Optional<Coder>>)ImmutableList.builder().addAll(this.combineInputCoders).add((Object)Optional.of(combineInputCoder)).build(), ImmutableList.builder().addAll(this.combineFnWithContexts).add(CombineFnUtil.toFnWithContext(globalCombineFn)).build(), ImmutableList.builder().addAll(this.outputTags).add(outputTag).build());
        }

        @Override
        public Object[] createAccumulator(CombineWithContext.Context c) {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.combineFnWithContexts.get(i).createAccumulator(c);
            }
            return accumsArray;
        }

        @Override
        public Object[] addInput(Object[] accumulator, DataT value, CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.combineFnWithContexts.get(i).addInput(accumulator[i], input, c);
            }
            return accumulator;
        }

        @Override
        public Object[] mergeAccumulators(Iterable<Object[]> accumulators, CombineWithContext.Context c) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator(c);
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.combineFnWithContexts.get(i).mergeAccumulators(new ProjectionIterable(accumulators, i), c);
            }
            return accum;
        }

        @Override
        public CoCombineResult extractOutput(Object[] accumulator, CombineWithContext.Context c) {
            HashMap valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.combineFnWithContexts.get(i).extractOutput(accumulator[i], c));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public Object[] compact(Object[] accumulator, CombineWithContext.Context c) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.combineFnWithContexts.get(i).compact(accumulator[i], c);
            }
            return accumulator;
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<DataT> dataCoder) throws CannotProvideCoderException {
            ArrayList coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = this.combineInputCoders.get(i).isPresent() ? (Coder<Object>)this.combineInputCoders.get(i).get() : registry.getOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.combineFnWithContexts.get(i).getAccumulatorCoder(registry, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.combineFnWithContexts);
        }
    }

    public static class ComposedCombineFn<DataT>
    extends Combine.CombineFn<DataT, Object[], CoCombineResult> {
        private final List<Combine.CombineFn<Object, Object, Object>> combineFns;
        private final List<Optional<Coder>> combineInputCoders;
        private final List<SerializableFunction<DataT, Object>> extractInputFns;
        private final List<TupleTag<?>> outputTags;
        private final int combineFnCount;

        private ComposedCombineFn() {
            this.extractInputFns = ImmutableList.of();
            this.combineInputCoders = ImmutableList.of();
            this.combineFns = ImmutableList.of();
            this.outputTags = ImmutableList.of();
            this.combineFnCount = 0;
        }

        private ComposedCombineFn(ImmutableList<SerializableFunction<DataT, ?>> extractInputFns, List<Optional<Coder>> combineInputCoders, ImmutableList<Combine.CombineFn<?, ?, ?>> combineFns, ImmutableList<TupleTag<?>> outputTags) {
            ImmutableList<SerializableFunction<DataT, ?>> castedExtractInputFns = extractInputFns;
            this.extractInputFns = castedExtractInputFns;
            this.combineInputCoders = combineInputCoders;
            ImmutableList<Combine.CombineFn<?, ?, ?>> castedCombineFns = combineFns;
            this.combineFns = castedCombineFns;
            this.outputTags = outputTags;
            this.combineFnCount = this.combineFns.size();
        }

        public <InputT, OutputT> ComposedCombineFn<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.CombineFn<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFn<DataT>(ImmutableList.builder().addAll(this.extractInputFns).add(extractInputFn).build(), (List<Optional<Coder>>)ImmutableList.builder().addAll(this.combineInputCoders).add((Object)Optional.absent()).build(), ImmutableList.builder().addAll(this.combineFns).add(combineFn).build(), ImmutableList.builder().addAll(this.outputTags).add(outputTag).build());
        }

        public <InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            ArrayList fnsWithContext = Lists.newArrayList();
            for (Combine.CombineFn<Object, Object, Object> fn : this.combineFns) {
                fnsWithContext.add(CombineFnUtil.toFnWithContext(fn));
            }
            return new ComposedCombineFnWithContext(ImmutableList.builder().addAll(this.extractInputFns).add(extractInputFn).build(), ImmutableList.builder().addAll(this.combineInputCoders).add((Object)Optional.absent()).build(), ImmutableList.builder().addAll((Iterable)fnsWithContext).add(combineFn).build(), ImmutableList.builder().addAll(this.outputTags).add(outputTag).build());
        }

        public <InputT, OutputT> ComposedCombineFn<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Coder combineInputCoder, Combine.CombineFn<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            return new ComposedCombineFn<DataT>(ImmutableList.builder().addAll(this.extractInputFns).add(extractInputFn).build(), (List<Optional<Coder>>)ImmutableList.builder().addAll(this.combineInputCoders).add((Object)Optional.of((Object)combineInputCoder)).build(), ImmutableList.builder().addAll(this.combineFns).add(combineFn).build(), ImmutableList.builder().addAll(this.outputTags).add(outputTag).build());
        }

        public <InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Coder combineInputCoder, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            CombineFns.checkUniqueness(this.outputTags, outputTag);
            List fnsWithContext = this.combineFns.stream().map(CombineFnUtil::toFnWithContext).collect(Collectors.toList());
            return new ComposedCombineFnWithContext(ImmutableList.builder().addAll(this.extractInputFns).add(extractInputFn).build(), ImmutableList.builder().addAll(this.combineInputCoders).add((Object)Optional.of((Object)combineInputCoder)).build(), ImmutableList.builder().addAll(fnsWithContext).add(combineFn).build(), ImmutableList.builder().addAll(this.outputTags).add(outputTag).build());
        }

        @Override
        public Object[] createAccumulator() {
            Object[] accumsArray = new Object[this.combineFnCount];
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumsArray[i] = this.combineFns.get(i).createAccumulator();
            }
            return accumsArray;
        }

        @Override
        public Object[] addInput(Object[] accumulator, DataT value) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                Object input = this.extractInputFns.get(i).apply(value);
                accumulator[i] = this.combineFns.get(i).addInput(accumulator[i], input);
            }
            return accumulator;
        }

        @Override
        public Object[] mergeAccumulators(Iterable<Object[]> accumulators) {
            Iterator<Object[]> iter = accumulators.iterator();
            if (!iter.hasNext()) {
                return this.createAccumulator();
            }
            Object[] accum = iter.next();
            for (int i = 0; i < this.combineFnCount; ++i) {
                accum[i] = this.combineFns.get(i).mergeAccumulators(new ProjectionIterable(accumulators, i));
            }
            return accum;
        }

        @Override
        public CoCombineResult extractOutput(Object[] accumulator) {
            HashMap valuesMap = Maps.newHashMap();
            for (int i = 0; i < this.combineFnCount; ++i) {
                valuesMap.put(this.outputTags.get(i), this.combineFns.get(i).extractOutput(accumulator[i]));
            }
            return new CoCombineResult(valuesMap);
        }

        @Override
        public Object[] compact(Object[] accumulator) {
            for (int i = 0; i < this.combineFnCount; ++i) {
                accumulator[i] = this.combineFns.get(i).compact(accumulator[i]);
            }
            return accumulator;
        }

        @Override
        public Coder<Object[]> getAccumulatorCoder(CoderRegistry registry, Coder<DataT> dataCoder) throws CannotProvideCoderException {
            ArrayList coders = Lists.newArrayList();
            for (int i = 0; i < this.combineFnCount; ++i) {
                Coder<Object> inputCoder = this.combineInputCoders.get(i).isPresent() ? (Coder<Object>)this.combineInputCoders.get(i).get() : registry.getOutputCoder(this.extractInputFns.get(i), dataCoder);
                coders.add(this.combineFns.get(i).getAccumulatorCoder(registry, (Coder)inputCoder));
            }
            return new ComposedAccumulatorCoder(coders);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            CombineFns.populateDisplayData(builder, this.combineFns);
        }
    }

    public static class CoCombineResult
    implements Serializable {
        private final Map<TupleTag<?>, Object> valuesMap;

        CoCombineResult(Map<TupleTag<?>, Object> valuesMap) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry<TupleTag<?>, Object> entry : valuesMap.entrySet()) {
                if (entry.getValue() != null) {
                    builder.put(entry);
                    continue;
                }
                builder.put(entry.getKey(), (Object)NullValue.INSTANCE);
            }
            this.valuesMap = builder.build();
        }

        public <V> @Nullable V get(TupleTag<V> tag) {
            Preconditions.checkArgument((boolean)this.valuesMap.keySet().contains(tag), (Object)("TupleTag " + tag + " is not in the CoCombineResult"));
            Object value = this.valuesMap.get(tag);
            if (value == NullValue.INSTANCE) {
                return null;
            }
            return (V)value;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CoCombineResult that = (CoCombineResult)o;
            return Objects.equal(this.valuesMap, that.valuesMap);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.valuesMap});
        }

        private static enum NullValue {
            INSTANCE;

        }
    }

    public static class ComposeCombineFnBuilder {
        public <DataT, InputT, OutputT> ComposedCombineFn<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Combine.CombineFn<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            return new ComposedCombineFn<DataT>().with(extractInputFn, combineFn, outputTag);
        }

        public <DataT, InputT, OutputT> ComposedCombineFn<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Coder combineInputCoder, Combine.CombineFn<InputT, ?, OutputT> combineFn, TupleTag<OutputT> outputTag) {
            return new ComposedCombineFn<DataT>().with(extractInputFn, combineInputCoder, combineFn, outputTag);
        }

        public <DataT, InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> combineFnWithContext, TupleTag<OutputT> outputTag) {
            return new ComposedCombineFnWithContext<DataT>().with(extractInputFn, combineFnWithContext, outputTag);
        }

        public <DataT, InputT, OutputT> ComposedCombineFnWithContext<DataT> with(SimpleFunction<DataT, InputT> extractInputFn, Coder combineInputCoder, CombineWithContext.CombineFnWithContext<InputT, ?, OutputT> combineFnWithContext, TupleTag<OutputT> outputTag) {
            return new ComposedCombineFnWithContext<DataT>().with(extractInputFn, combineInputCoder, combineFnWithContext, outputTag);
        }
    }
}

