/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HintedHandoffMetrics {
    private static final Logger logger = LoggerFactory.getLogger(HintedHandoffMetrics.class);
    private static final MetricNameFactory factory = new DefaultNameFactory("HintsService");
    private final LoadingCache<InetAddressAndPort, DifferencingCounter> notStored = Caffeine.newBuilder().executor(MoreExecutors.directExecutor()).build(DifferencingCounter::new);
    private final LoadingCache<InetAddressAndPort, Counter> createdHintCounts = Caffeine.newBuilder().executor(MoreExecutors.directExecutor()).build(address -> CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Hints_created-" + address.toString().replace(':', '.'))));

    public void incrCreatedHints(InetAddressAndPort address) {
        ((Counter)this.createdHintCounts.get((Object)address)).inc();
    }

    public void incrPastWindow(InetAddressAndPort address) {
        ((DifferencingCounter)this.notStored.get((Object)address)).mark();
    }

    public void log() {
        for (Map.Entry entry : this.notStored.asMap().entrySet()) {
            long difference = ((DifferencingCounter)entry.getValue()).difference();
            if (difference == 0L) continue;
            logger.warn("{} has {} dropped hints, because node is down past configured hint window.", entry.getKey(), (Object)difference);
            SystemKeyspace.updateHintsDropped((InetAddressAndPort)entry.getKey(), UUIDGen.getTimeUUID(), (int)difference);
        }
    }

    public static class DifferencingCounter {
        private final Counter meter;
        private long reported = 0L;

        public DifferencingCounter(InetAddressAndPort address) {
            this.meter = CassandraMetricsRegistry.Metrics.counter(factory.createMetricName("Hints_not_stored-" + address.toString().replace(':', '.')));
        }

        public long difference() {
            long current = this.meter.getCount();
            long difference = current - this.reported;
            this.reported = current;
            return difference;
        }

        public long count() {
            return this.meter.getCount();
        }

        public void mark() {
            this.meter.inc();
        }
    }
}

