/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.terafast;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.IPluginProperty;
import org.apache.hop.core.util.KeyValue;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.terafast.TeraFastMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.SimpleFileSelection;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.PluginWidgetFactory;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TeraFastDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = TeraFastMeta.class;
    private static final int FORM_ATTACHMENT_OFFSET = 100;
    private static final int FORM_ATTACHMENT_FACTOR = -15;
    private final TeraFastMeta meta;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private TextVar wTable;
    private TextVar wFastLoadPath;
    private Button wbFastLoadPath;
    private TextVar wControlFile;
    private Button wbControlFile;
    private TextVar wDataFile;
    private Button wbDataFile;
    private Button wbLogFile;
    private TextVar wLogFile;
    private TextVar wErrLimit;
    private TextVar wSessions;
    private Button wUseControlFile;
    private Button wVariableSubstitution;
    private Button wbTruncateTable;
    private TableView wReturn;
    private Button wGetLU;
    private Button wDoMapping;
    private ColumnInfo[] ciReturn;
    private final Map<String, Integer> inputFields = new HashMap<String, Integer>();
    private final List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public TeraFastDialog(Shell parent, IVariables variables, Object baseTransformMeta, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)baseTransformMeta, pipelineMeta, transformName);
        this.meta = (TeraFastMeta)((Object)baseTransformMeta);
    }

    public static void setTextIfPropertyValue(IPluginProperty property, TextVar textVar) {
        if (property.evaluate()) {
            textVar.setText(((KeyValue)property).stringValue());
        }
    }

    public static void setTextIfPropertyValue(IPluginProperty property, CCombo combo) {
        if (property.evaluate()) {
            combo.setText(((KeyValue)property).stringValue());
        }
    }

    public String open() {
        this.changed = this.meta.hasChanged();
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TeraFastDialog.Shell.Title", (String[])new String[0]));
        this.buildUi();
        this.listeners();
        Runnable runnable = () -> {
            TransformMeta transformMetaSearchFields = this.pipelineMeta.findTransform(this.transformName);
            if (transformMetaSearchFields == null) {
                return;
            }
            try {
                IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMetaSearchFields);
                for (int i = 0; i < row.size(); ++i) {
                    this.inputFields.put(row.getValueMeta(i).getName(), i);
                }
                this.setComboBoxes();
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
            }
        };
        new Thread(runnable).start();
        this.getData();
        this.meta.setChanged(this.changed);
        this.disableInputs();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void getData() {
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getFastloadPath(), this.wFastLoadPath);
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getControlFile(), this.wControlFile);
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getDataFile(), this.wDataFile);
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getLogFile(), this.wLogFile);
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getTargetTable(), this.wTable);
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getErrorLimit(), this.wErrLimit);
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getSessions(), this.wSessions);
        TeraFastDialog.setTextIfPropertyValue((IPluginProperty)this.meta.getConnectionName(), this.wConnection.getComboWidget());
        this.wbTruncateTable.setSelection(((Boolean)this.meta.getTruncateTable().getValue()).booleanValue());
        this.wUseControlFile.setSelection(((Boolean)this.meta.getUseControlFile().getValue()).booleanValue());
        this.wVariableSubstitution.setSelection(((Boolean)this.meta.getVariableSubstitution().getValue()).booleanValue());
        if (((List)this.meta.getTableFieldList().getValue()).size() == ((List)this.meta.getStreamFieldList().getValue()).size()) {
            for (int i = 0; i < ((List)this.meta.getTableFieldList().getValue()).size(); ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(1, (String)((List)this.meta.getTableFieldList().getValue()).get(i));
                item.setText(2, (String)((List)this.meta.getStreamFieldList().getValue()).get(i));
            }
        }
        if (this.meta.getDbMeta() != null) {
            this.wConnection.setText((String)this.meta.getConnectionName().getValue());
        }
        this.setTableFieldCombo();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void listeners() {
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, event -> this.ok());
        this.wGetLU.addListener(13, event -> this.getUpdate());
        String allFileTypes = BaseMessages.getString(PKG, (String)"TeraFastDialog.Filetype.All", (String[])new String[0]);
        this.wbControlFile.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wControlFile, new String[]{allFileTypes}));
        this.wbDataFile.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wDataFile, new String[]{allFileTypes}));
        this.wbFastLoadPath.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wFastLoadPath, new String[]{allFileTypes}));
        this.wbLogFile.addSelectionListener((SelectionListener)new SimpleFileSelection(this.shell, this.wLogFile, new String[]{allFileTypes}));
        this.wDoMapping.addListener(13, event -> this.generateMappings());
    }

    public void generateMappings() {
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.meta.getTargetTable().setValue((Object)this.wTable.getText());
        try {
            targetFields = this.meta.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraFastDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuilder missingSourceFields = new StringBuilder();
        StringBuilder missingTargetFields = new StringBuilder();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        EnterMappingDialog d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings);
        mappings = d.open();
        if (mappings != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    public void getUpdate() {
        try {
            IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (row != null) {
                ITableItemInsertListener listener = (tableItem, value) -> true;
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)row, (TableView)this.wReturn, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"TeraFastDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TeraFastDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    public void ok() {
        this.transformName = this.wTransformName.getText();
        this.meta.getUseControlFile().setValue((Object)this.wUseControlFile.getSelection());
        this.meta.getVariableSubstitution().setValue((Object)this.wVariableSubstitution.getSelection());
        this.meta.getControlFile().setValue((Object)this.wControlFile.getText());
        this.meta.getFastloadPath().setValue((Object)this.wFastLoadPath.getText());
        this.meta.getDataFile().setValue((Object)this.wDataFile.getText());
        this.meta.getLogFile().setValue((Object)this.wLogFile.getText());
        this.meta.getErrorLimit().setValue((Object)Const.toInt((String)this.wErrLimit.getText(), (int)25));
        this.meta.getSessions().setValue((Object)Const.toInt((String)this.wSessions.getText(), (int)2));
        this.meta.getTargetTable().setValue((Object)this.wTable.getText());
        this.meta.getConnectionName().setValue((Object)this.wConnection.getText());
        this.meta.getTruncateTable().setValue((Object)(this.wbTruncateTable.getSelection() && this.wbTruncateTable.getEnabled() ? 1 : 0));
        this.meta.setDbMeta(this.pipelineMeta.findDatabase(this.wConnection.getText()));
        ((List)this.meta.getTableFieldList().getValue()).clear();
        ((List)this.meta.getStreamFieldList().getValue()).clear();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            ((List)this.meta.getTableFieldList().getValue()).add(item.getText(1));
            ((List)this.meta.getStreamFieldList().getValue()).add(item.getText(2));
        }
        this.dispose();
    }

    protected void buildUi() {
        PluginWidgetFactory factory = new PluginWidgetFactory(this.shell, this.variables);
        factory.setMiddle(this.props.getMiddlePct());
        this.wOk = factory.createPushButton(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = factory.createPushButton(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, factory.getMargin(), null);
        ModifyListener lsMod = event -> this.getMeta().setChanged();
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeraFastDialog.this.getMeta().setChanged();
            }
        };
        this.buildTransformNameLine(factory);
        this.buildUseControlFileLine(factory);
        this.buildControlFileLine(factory);
        this.buildVariableSubstitutionLine(factory);
        this.buildFastloadLine(factory);
        this.buildLogFileLine(factory);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wLogFile, this.meta.getDbMeta(), lsMod);
        this.buildTableLine(factory);
        this.buildTruncateTableLine(factory);
        this.buildDataFileLine(factory);
        this.buildSessionsLine(factory);
        this.buildErrorLimitLine(factory);
        this.buildFieldTable(factory);
        this.buildAscLink(factory);
        this.wTransformName.addModifyListener(lsMod);
        this.wControlFile.addModifyListener(lsMod);
        this.wFastLoadPath.addModifyListener(lsMod);
        this.wLogFile.addModifyListener(lsMod);
        this.wConnection.addModifyListener(lsMod);
        this.wTable.addModifyListener(lsMod);
        this.wDataFile.addModifyListener(lsMod);
        this.wSessions.addModifyListener(lsMod);
        this.wErrLimit.addModifyListener(lsMod);
        this.wbTruncateTable.addSelectionListener((SelectionListener)lsSel);
        this.wUseControlFile.addSelectionListener((SelectionListener)lsSel);
        this.wVariableSubstitution.addSelectionListener((SelectionListener)lsSel);
        this.wReturn.addModifyListener(lsMod);
    }

    protected void buildControlFileLine(PluginWidgetFactory factory) {
        Button topControl = this.wUseControlFile;
        Label wlControlFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.ControlFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlControlFile);
        wlControlFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbControlFile = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wbControlFile);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbControlFile.setLayoutData((Object)formData);
        this.wControlFile = factory.createSingleTextVarLeft();
        PropsUi.setLook((Widget)this.wControlFile);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbControlFile, -factory.getMargin());
        this.wControlFile.setLayoutData((Object)formData);
    }

    protected void buildFastloadLine(PluginWidgetFactory factory) {
        Button topControl = this.wVariableSubstitution;
        Label wlFastLoadPath = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.FastloadPath.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFastLoadPath);
        wlFastLoadPath.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbFastLoadPath = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wbFastLoadPath);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbFastLoadPath.setLayoutData((Object)formData);
        this.wFastLoadPath = factory.createSingleTextVarLeft();
        PropsUi.setLook((Widget)this.wFastLoadPath);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbFastLoadPath, -factory.getMargin());
        this.wFastLoadPath.setLayoutData((Object)formData);
    }

    protected void buildUseControlFileLine(PluginWidgetFactory factory) {
        Text topControl = this.wTransformName;
        Label wlUseControlFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.UseControlFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlUseControlFile);
        wlUseControlFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wUseControlFile = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wUseControlFile);
        this.wUseControlFile.setLayoutData((Object)factory.createButtonLayoutData((Control)wlUseControlFile));
        this.wUseControlFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TeraFastDialog.this.disableInputs();
            }
        });
    }

    protected void buildVariableSubstitutionLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wControlFile;
        Label wlVariableSubstitution = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.VariableSubstitution.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlVariableSubstitution);
        wlVariableSubstitution.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wVariableSubstitution = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wVariableSubstitution);
        this.wVariableSubstitution.setLayoutData((Object)factory.createButtonLayoutData((Control)wlVariableSubstitution));
    }

    protected void buildLogFileLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wFastLoadPath;
        Label wlLogFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.LogFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLogFile);
        wlLogFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbLogFile = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wbLogFile);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbLogFile.setLayoutData((Object)formData);
        this.wLogFile = factory.createSingleTextVarLeft();
        PropsUi.setLook((Widget)this.wLogFile);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbLogFile, -factory.getMargin());
        this.wLogFile.setLayoutData((Object)formData);
    }

    protected void buildTransformNameLine(PluginWidgetFactory factory) {
        this.wlTransformName = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = factory.createLabelLayoutData(null);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = factory.createSingleTextLeft(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = factory.createControlLayoutData(null);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
    }

    protected void buildTableLine(PluginWidgetFactory factory) {
        MetaSelectionLine<DatabaseMeta> topControl = this.wConnection;
        Label wlTable = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        wlTable.setLayoutData((Object)factory.createLabelLayoutData(topControl));
        this.wTable = factory.createSingleTextVarLeft();
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.setLayoutData((Object)factory.createControlLayoutData(topControl));
        this.wTable.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                TeraFastDialog.this.setTableFieldCombo();
            }
        });
    }

    protected void buildTruncateTableLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wTable;
        Label wlTruncateTable = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.TruncateTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTruncateTable);
        wlTruncateTable.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbTruncateTable = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wbTruncateTable);
        this.wbTruncateTable.setLayoutData((Object)factory.createButtonLayoutData((Control)wlTruncateTable));
    }

    protected void buildDataFileLine(PluginWidgetFactory factory) {
        Button topControl = this.wbTruncateTable;
        Label wlDataFile = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.DataFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataFile);
        wlDataFile.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wbDataFile = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.Browse.Button", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wbDataFile);
        FormData formData = factory.createControlLayoutData((Control)topControl);
        formData.left = null;
        this.wbDataFile.setLayoutData((Object)formData);
        this.wDataFile = factory.createSingleTextVarLeft();
        PropsUi.setLook((Widget)this.wDataFile);
        formData = factory.createControlLayoutData((Control)topControl);
        formData.right = new FormAttachment((Control)this.wbDataFile, -factory.getMargin());
        this.wDataFile.setLayoutData((Object)formData);
    }

    protected void buildSessionsLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wDataFile;
        Label wlSessions = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.Sessions.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSessions);
        wlSessions.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wSessions = factory.createSingleTextVarLeft();
        PropsUi.setLook((Widget)this.wSessions);
        this.wSessions.setLayoutData((Object)factory.createControlLayoutData((Control)topControl));
    }

    protected void buildErrorLimitLine(PluginWidgetFactory factory) {
        TextVar topControl = this.wSessions;
        Label wlErrLimit = factory.createRightLabel(BaseMessages.getString(PKG, (String)"TeraFastDialog.ErrLimit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlErrLimit);
        wlErrLimit.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        this.wErrLimit = factory.createSingleTextVarLeft();
        PropsUi.setLook((Widget)this.wErrLimit);
        this.wErrLimit.setLayoutData((Object)factory.createControlLayoutData((Control)topControl));
    }

    protected void buildAscLink(PluginWidgetFactory factory) {
        TableView topControl = this.wReturn;
        FormData formData = factory.createLabelLayoutData((Control)topControl);
        formData.right = null;
    }

    protected void buildFieldTable(PluginWidgetFactory factory) {
        TextVar topControl = this.wErrLimit;
        Label wlReturn = factory.createLabel(0, BaseMessages.getString(PKG, (String)"TeraFastDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlReturn);
        wlReturn.setLayoutData((Object)factory.createLabelLayoutData((Control)topControl));
        int upInsCols = 2;
        int upInsRows = this.meta.getTableFieldList().isEmpty() ? 1 : this.meta.getTableFieldList().size();
        this.ciReturn = new ColumnInfo[2];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraFastDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"TeraFastDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciReturn[0]);
        this.wReturn = new TableView(this.variables, (Composite)this.shell, 68354, this.ciReturn, upInsRows, null, this.props);
        this.wGetLU = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.GetFields.Label", (String[])new String[0]));
        FormData fdGetLU = new FormData();
        fdGetLU.top = new FormAttachment((Control)wlReturn, factory.getMargin());
        fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)fdGetLU);
        this.wDoMapping = factory.createPushButton(BaseMessages.getString(PKG, (String)"TeraFastDialog.EditMapping.Label", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)this.wGetLU, factory.getMargin());
        fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdDoMapping);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.top = new FormAttachment((Control)wlReturn, factory.getMargin());
        formData.right = new FormAttachment((Control)this.wGetLU, -factory.getMargin());
        TeraFastDialog teraFastDialog = this;
        formData.bottom = new FormAttachment((Control)this.wOk, -2 * teraFastDialog.props.getMargin());
        this.wReturn.setLayoutData((Object)formData);
    }

    public void disableInputs() {
        boolean useControlFile = this.wUseControlFile.getSelection();
        this.wbControlFile.setEnabled(useControlFile);
        this.wControlFile.setEnabled(useControlFile);
        this.wDataFile.setEnabled(!useControlFile);
        this.wbDataFile.setEnabled(!useControlFile);
        this.wSessions.setEnabled(!useControlFile);
        this.wErrLimit.setEnabled(!useControlFile);
        this.wReturn.setEnabled(!useControlFile);
        this.wGetLU.setEnabled(!useControlFile);
        this.wDoMapping.setEnabled(!useControlFile);
        this.wTable.setEnabled(!useControlFile);
        this.wbTruncateTable.setEnabled(!useControlFile);
        this.wConnection.setEnabled(!useControlFile);
        this.wVariableSubstitution.setEnabled(useControlFile);
    }

    public void setTableFieldCombo() {
        this.clearColInfo();
        new FieldLoader(this.variables, this).start();
    }

    private void clearColInfo() {
        for (ColumnInfo colInfo : this.tableFieldColumns) {
            colInfo.setComboValues(new String[0]);
        }
    }

    public TeraFastMeta getMeta() {
        return this.meta;
    }

    private static final class FieldLoader
    extends Thread {
        private final IVariables variables;
        private final TeraFastDialog dialog;

        public FieldLoader(IVariables variables, TeraFastDialog dialog) {
            this.variables = variables;
            this.dialog = dialog;
        }

        @Override
        public void run() {
            try {
                IRowMeta rowMeta = this.dialog.meta.getRequiredFields(this.variables);
                if (rowMeta == null) {
                    return;
                }
                String[] fieldNames = rowMeta.getFieldNames();
                if (fieldNames == null) {
                    return;
                }
                for (int i = 0; i < this.dialog.tableFieldColumns.size(); ++i) {
                    ColumnInfo colInfo = this.dialog.tableFieldColumns.get(i);
                    if (this.dialog.shell.isDisposed()) {
                        return;
                    }
                    this.dialog.shell.getDisplay().asyncExec(() -> {
                        if (this.dialog.shell.isDisposed()) {
                            return;
                        }
                        colInfo.setComboValues(fieldNames);
                    });
                }
            }
            catch (HopException e) {
                this.dialog.logError(this.toString(), new Object[]{"Error while reading fields", e});
            }
        }
    }
}

