/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage;

import com.microsoft.azure.storage.UserDelegationKey;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UserDelegationKeyHandler
extends DefaultHandler {
    private final Stack<String> elementStack = new Stack();
    private final UserDelegationKey key = new UserDelegationKey();
    private StringBuilder sb = new StringBuilder();

    public static UserDelegationKey readUserDelegationKeyFromStream(InputStream stream) throws SAXException, IOException, ParserConfigurationException {
        SAXParser saxParser = Utility.getSAXParser();
        UserDelegationKeyHandler handler = new UserDelegationKeyHandler();
        saxParser.parse(stream, (DefaultHandler)handler);
        return handler.key;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elementStack.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String currentNode = this.elementStack.pop();
        if (!localName.equals(currentNode)) {
            throw new SAXException("The response received is invalid or improperly formatted.");
        }
        String value = this.sb.toString();
        this.sb = new StringBuilder();
        if (value.isEmpty()) {
            value = null;
        }
        switch (localName) {
            case "SignedOid": {
                try {
                    this.key.setSignedOid(UUID.fromString(value));
                }
                catch (Exception exception) {}
                break;
            }
            case "SignedTid": {
                try {
                    this.key.setSignedTid(UUID.fromString(value));
                }
                catch (Exception exception) {}
                break;
            }
            case "SignedStart": {
                try {
                    this.key.setSignedStart(Utility.parseDate(value));
                }
                catch (Exception exception) {}
                break;
            }
            case "SignedExpiry": {
                try {
                    this.key.setSignedExpiry(Utility.parseDate(value));
                }
                catch (Exception exception) {}
                break;
            }
            case "SignedVersion": {
                this.key.setSignedVersion(value);
                break;
            }
            case "SignedService": {
                this.key.setSignedService(value);
                break;
            }
            case "Value": {
                this.key.setValue(value);
                break;
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.sb.append(ch, start, length);
    }
}

