/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.Session;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class SCPClient {
    Connection conn;

    public SCPClient(Connection conn) {
        if (conn == null) {
            throw new IllegalArgumentException("Cannot accept null argument!");
        }
        this.conn = conn;
    }

    private void readResponse(InputStream is) throws IOException {
        int c = is.read();
        if (c == 0) {
            return;
        }
        if (c == -1) {
            throw new IOException("Remote scp terminated unexpectedly.");
        }
        if (c != 1 && c != 2) {
            throw new IOException("Remote scp sent illegal error code.");
        }
        if (c == 2) {
            throw new IOException("Remote scp terminated with error.");
        }
        String err = this.receiveLine(is);
        throw new IOException("Remote scp terminated with error (" + err + ").");
    }

    private String receiveLine(InputStream is) throws IOException {
        StringBuffer sb = new StringBuffer(30);
        while (true) {
            if (sb.length() > 8192) {
                throw new IOException("Remote scp sent a too long line");
            }
            int c = is.read();
            if (c < 0) {
                throw new IOException("Remote scp terminated unexpectedly.");
            }
            if (c == 10) break;
            sb.append((char)c);
        }
        return sb.toString();
    }

    private LenNamePair parseCLine(String line) throws IOException {
        long len;
        if (line.length() < 8) {
            throw new IOException("Malformed C line sent by remote SCP binary, line too short.");
        }
        if (line.charAt(4) != ' ' || line.charAt(5) == ' ') {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        int length_name_sep = line.indexOf(32, 5);
        if (length_name_sep == -1) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        String length_substring = line.substring(5, length_name_sep);
        String name_substring = line.substring(length_name_sep + 1);
        if (length_substring.length() <= 0 || name_substring.length() <= 0) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        if (6 + length_substring.length() + name_substring.length() != line.length()) {
            throw new IOException("Malformed C line sent by remote SCP binary.");
        }
        try {
            len = Long.parseLong(length_substring);
        }
        catch (NumberFormatException e) {
            throw new IOException("Malformed C line sent by remote SCP binary, cannot parse file length.");
        }
        if (len < 0L) {
            throw new IOException("Malformed C line sent by remote SCP binary, illegal file length.");
        }
        LenNamePair lnp = new LenNamePair();
        lnp.length = len;
        lnp.filename = name_substring;
        return lnp;
    }

    private void sendBytes(Session sess, byte[] data, String fileName, String mode) throws IOException {
        OutputStream os = sess.getStdin();
        BufferedInputStream is = new BufferedInputStream(sess.getStdout(), 512);
        this.readResponse(is);
        String cline = "C" + mode + " " + data.length + " " + fileName + "\n";
        try {
            os.write(cline.getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            os.write(cline.getBytes());
        }
        os.flush();
        this.readResponse(is);
        os.write(data, 0, data.length);
        os.write(0);
        os.flush();
        this.readResponse(is);
        try {
            os.write("E\n".getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            os.write("E\n".getBytes());
        }
        os.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFiles(Session sess, String[] files, String[] remoteFiles, String mode) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedOutputStream os = new BufferedOutputStream(sess.getStdin(), 40000);
        BufferedInputStream is = new BufferedInputStream(sess.getStdout(), 512);
        this.readResponse(is);
        for (int i = 0; i < files.length; ++i) {
            File f = new File(files[i]);
            long remain = f.length();
            String remoteName = remoteFiles != null && remoteFiles.length > i && remoteFiles[i] != null ? remoteFiles[i] : f.getName();
            String cline = "C" + mode + " " + remain + " " + remoteName + "\n";
            try {
                ((OutputStream)os).write(cline.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                ((OutputStream)os).write(cline.getBytes());
            }
            ((OutputStream)os).flush();
            this.readResponse(is);
            try (FileInputStream fis = null;){
                fis = new FileInputStream(f);
                while (remain > 0L) {
                    int trans = remain > (long)buffer.length ? buffer.length : (int)remain;
                    if (fis.read(buffer, 0, trans) != trans) {
                        throw new IOException("Cannot read enough from local file " + files[i]);
                    }
                    ((OutputStream)os).write(buffer, 0, trans);
                    remain -= (long)trans;
                }
            }
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
            this.readResponse(is);
        }
        try {
            ((OutputStream)os).write("E\n".getBytes("ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            ((OutputStream)os).write("E\n".getBytes("ISO-8859-1"));
        }
        ((OutputStream)os).flush();
    }

    private void receiveFiles(Session sess, OutputStream[] targets) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedOutputStream os = new BufferedOutputStream(sess.getStdin(), 512);
        BufferedInputStream is = new BufferedInputStream(sess.getStdout(), 40000);
        ((OutputStream)os).write(0);
        ((OutputStream)os).flush();
        for (int i = 0; i < targets.length; ++i) {
            int this_time_received;
            String line;
            int c;
            LenNamePair lnp = null;
            do {
                if ((c = ((InputStream)is).read()) < 0) {
                    throw new IOException("Remote scp terminated unexpectedly.");
                }
                line = this.receiveLine(is);
            } while (c == 84);
            if (c == 1 || c == 2) {
                throw new IOException("Remote SCP error: " + line);
            }
            if (c != 67) {
                throw new IOException("Remote SCP error: " + (char)c + line);
            }
            lnp = this.parseCLine(line);
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
            for (long remain = lnp.length; remain > 0L; remain -= (long)this_time_received) {
                int trans = remain > (long)buffer.length ? buffer.length : (int)remain;
                this_time_received = ((InputStream)is).read(buffer, 0, trans);
                if (this_time_received < 0) {
                    throw new IOException("Remote scp terminated connection unexpectedly");
                }
                targets[i].write(buffer, 0, this_time_received);
            }
            this.readResponse(is);
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFiles(Session sess, String[] files, String target) throws IOException {
        byte[] buffer = new byte[8192];
        BufferedOutputStream os = new BufferedOutputStream(sess.getStdin(), 512);
        BufferedInputStream is = new BufferedInputStream(sess.getStdout(), 40000);
        ((OutputStream)os).write(0);
        ((OutputStream)os).flush();
        for (int i = 0; i < files.length; ++i) {
            String line;
            int c;
            LenNamePair lnp = null;
            do {
                if ((c = ((InputStream)is).read()) < 0) {
                    throw new IOException("Remote scp terminated unexpectedly.");
                }
                line = this.receiveLine(is);
            } while (c == 84);
            if (c == 1 || c == 2) {
                throw new IOException("Remote SCP error: " + line);
            }
            if (c != 67) {
                throw new IOException("Remote SCP error: " + (char)c + line);
            }
            lnp = this.parseCLine(line);
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
            File f = new File(target + File.separatorChar + lnp.filename);
            try (FileOutputStream fop = null;){
                int this_time_received;
                fop = new FileOutputStream(f);
                for (long remain = lnp.length; remain > 0L; remain -= (long)this_time_received) {
                    int trans = remain > (long)buffer.length ? buffer.length : (int)remain;
                    this_time_received = ((InputStream)is).read(buffer, 0, trans);
                    if (this_time_received < 0) {
                        throw new IOException("Remote scp terminated connection unexpectedly");
                    }
                    fop.write(buffer, 0, this_time_received);
                }
            }
            this.readResponse(is);
            ((OutputStream)os).write(0);
            ((OutputStream)os).flush();
        }
    }

    public void put(String localFile, String remoteTargetDirectory) throws IOException {
        this.put(new String[]{localFile}, remoteTargetDirectory, "0600");
    }

    public void put(String[] localFiles, String remoteTargetDirectory) throws IOException {
        this.put(localFiles, remoteTargetDirectory, "0600");
    }

    public void put(String localFile, String remoteTargetDirectory, String mode) throws IOException {
        this.put(new String[]{localFile}, remoteTargetDirectory, mode);
    }

    public void put(String localFile, String remoteFileName, String remoteTargetDirectory, String mode) throws IOException {
        this.put(new String[]{localFile}, new String[]{remoteFileName}, remoteTargetDirectory, mode);
    }

    public void put(byte[] data, String remoteFileName, String remoteTargetDirectory) throws IOException {
        this.put(data, remoteFileName, remoteTargetDirectory, "0600");
    }

    public void put(byte[] data, String remoteFileName, String remoteTargetDirectory, String mode) throws IOException {
        Session sess = null;
        if (remoteFileName == null || remoteTargetDirectory == null || mode == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (mode.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i = 0; i < mode.length(); ++i) {
            if (Character.isDigit(mode.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        remoteTargetDirectory = (remoteTargetDirectory = remoteTargetDirectory.trim()).length() > 0 ? remoteTargetDirectory : ".";
        String cmd = "scp -t -d " + remoteTargetDirectory;
        try {
            sess = this.conn.openSession();
            sess.execCommand(cmd);
            this.sendBytes(sess, data, remoteFileName, mode);
        }
        catch (IOException e) {
            throw new IOException("Error during SCP transfer.", e);
        }
        finally {
            if (sess != null) {
                sess.close();
            }
        }
    }

    public void put(String[] localFiles, String remoteTargetDirectory, String mode) throws IOException {
        this.put(localFiles, null, remoteTargetDirectory, mode);
    }

    public void put(String[] localFiles, String[] remoteFiles, String remoteTargetDirectory, String mode) throws IOException {
        Session sess = null;
        if (localFiles == null || remoteTargetDirectory == null || mode == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (mode.length() != 4) {
            throw new IllegalArgumentException("Invalid mode.");
        }
        for (int i = 0; i < mode.length(); ++i) {
            if (Character.isDigit(mode.charAt(i))) continue;
            throw new IllegalArgumentException("Invalid mode.");
        }
        if (localFiles.length == 0) {
            return;
        }
        remoteTargetDirectory = (remoteTargetDirectory = remoteTargetDirectory.trim()).length() > 0 ? remoteTargetDirectory : ".";
        String cmd = "scp -t -d " + remoteTargetDirectory;
        for (int i = 0; i < localFiles.length; ++i) {
            if (localFiles[i] != null) continue;
            throw new IllegalArgumentException("Cannot accept null filename.");
        }
        try {
            sess = this.conn.openSession();
            sess.execCommand(cmd);
            this.sendFiles(sess, localFiles, remoteFiles, mode);
        }
        catch (IOException e) {
            throw new IOException("Error during SCP transfer.", e);
        }
        finally {
            if (sess != null) {
                sess.close();
            }
        }
    }

    public void get(String remoteFile, String localTargetDirectory) throws IOException {
        this.get(new String[]{remoteFile}, localTargetDirectory);
    }

    public void get(String remoteFile, OutputStream target) throws IOException {
        this.get(new String[]{remoteFile}, new OutputStream[]{target});
    }

    private void get(String[] remoteFiles, OutputStream[] targets) throws IOException {
        Session sess = null;
        if (remoteFiles == null || targets == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (remoteFiles.length != targets.length) {
            throw new IllegalArgumentException("Length of arguments does not match.");
        }
        if (remoteFiles.length == 0) {
            return;
        }
        String cmd = "scp -f";
        for (int i = 0; i < remoteFiles.length; ++i) {
            if (remoteFiles[i] == null) {
                throw new IllegalArgumentException("Cannot accept null filename.");
            }
            String tmp = remoteFiles[i].trim();
            if (tmp.length() == 0) {
                throw new IllegalArgumentException("Cannot accept empty filename.");
            }
            cmd = cmd + " " + tmp;
        }
        try {
            sess = this.conn.openSession();
            sess.execCommand(cmd);
            this.receiveFiles(sess, targets);
        }
        catch (IOException e) {
            throw new IOException("Error during SCP transfer.", e);
        }
        finally {
            if (sess != null) {
                sess.close();
            }
        }
    }

    public void get(String[] remoteFiles, String localTargetDirectory) throws IOException {
        Session sess = null;
        if (remoteFiles == null || localTargetDirectory == null) {
            throw new IllegalArgumentException("Null argument.");
        }
        if (remoteFiles.length == 0) {
            return;
        }
        String cmd = "scp -f";
        for (int i = 0; i < remoteFiles.length; ++i) {
            if (remoteFiles[i] == null) {
                throw new IllegalArgumentException("Cannot accept null filename.");
            }
            String tmp = remoteFiles[i].trim();
            if (tmp.length() == 0) {
                throw new IllegalArgumentException("Cannot accept empty filename.");
            }
            cmd = cmd + " " + tmp;
        }
        try {
            sess = this.conn.openSession();
            sess.execCommand(cmd);
            this.receiveFiles(sess, remoteFiles, localTargetDirectory);
        }
        catch (IOException e) {
            throw new IOException("Error during SCP transfer.", e);
        }
        finally {
            if (sess != null) {
                sess.close();
            }
        }
    }

    class LenNamePair {
        long length;
        String filename;

        LenNamePair() {
        }
    }
}

