/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stringcut;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stringcut.StringCutField;
import org.apache.hop.pipeline.transforms.stringcut.StringCutMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ITableItemInsertListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class StringCutDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = StringCutMeta.class;
    private TableView wFields;
    private final StringCutMeta input;
    private final Map<String, Integer> inputFields;
    private ColumnInfo[] ciKey;

    public StringCutDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (StringCutMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StringCutDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        StringCutDialog stringCutDialog = this;
        int margin = stringCutDialog.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"StringCutDialog.GetFields.Button", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.get());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"StringCutDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlKey = new Label((Composite)this.shell, 0);
        wlKey.setText(BaseMessages.getString(PKG, (String)"StringCutDialog.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlKey);
        FormData fdlKey = new FormData();
        fdlKey.left = new FormAttachment(0, 0);
        fdlKey.top = new FormAttachment((Control)this.wTransformName, 2 * margin);
        wlKey.setLayoutData((Object)fdlKey);
        int nrFieldCols = 4;
        int nrFieldRows = this.input.getFields() != null && !this.input.getFields().isEmpty() ? this.input.getFields().size() : 1;
        this.ciKey = new ColumnInfo[nrFieldCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringCutDialog.ColumnInfo.InStreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringCutDialog.ColumnInfo.OutStreamField", (String[])new String[0]), 1, false);
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringCutDialog.ColumnInfo.CutFrom", (String[])new String[0]), 1, false);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringCutDialog.ColumnInfo.CutTo", (String[])new String[0]), 1, false);
        this.ciKey[2].setUsingVariables(true);
        this.ciKey[1].setToolTip(BaseMessages.getString(PKG, (String)"StringCutDialog.ColumnInfo.OutStreamField.Tooltip", (String[])new String[0]));
        this.ciKey[3].setUsingVariables(true);
        this.wFields = new TableView(this.variables, (Composite)this.shell, 68354, this.ciKey, nrFieldRows, lsMod, this.props);
        FormData fdKey = new FormData();
        fdKey.left = new FormAttachment(0, 0);
        fdKey.top = new FormAttachment((Control)wlKey, margin);
        fdKey.right = new FormAttachment(100, -margin);
        fdKey.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdKey);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError("It was not possible to get the fields from the previous transform(s).");
                }
            }
        };
        new Thread(runnable).start();
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getFields() != null && !this.input.getFields().isEmpty()) {
            int i = 0;
            for (StringCutField scf : this.input.getFields()) {
                TableItem item = this.wFields.table.getItem(i);
                if (scf.getFieldInStream() != null) {
                    item.setText(1, scf.getFieldInStream());
                }
                if (scf.getFieldOutStream() != null) {
                    item.setText(2, scf.getFieldOutStream());
                }
                if (scf.getCutFrom() != null) {
                    item.setText(3, scf.getCutFrom());
                }
                if (scf.getCutTo() != null) {
                    item.setText(4, scf.getCutTo());
                }
                ++i;
            }
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(StringCutMeta inf) {
        int nrkeys = this.wFields.nrNonEmpty();
        inf.getFields().clear();
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StringCutDialog.Log.FoundFields", (String[])new String[]{String.valueOf(nrkeys)}));
        }
        for (int i = 0; i < nrkeys; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            StringCutField scf = new StringCutField(item.getText(1), item.getText(2), item.getText(3), item.getText(4));
            inf.getFields().add(scf);
        }
        this.transformName = this.wTransformName.getText();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null) {
                ITableItemInsertListener listener = (tableItem, v) -> v.getType() == 2;
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, (ITableItemInsertListener)listener);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StringCutDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringCutDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

