/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.triggers;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.repackaged.direct_java.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class AfterEachStateMachine
extends TriggerStateMachine {
    private AfterEachStateMachine(List<TriggerStateMachine> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument((subTriggers.size() > 1 ? 1 : 0) != 0);
    }

    @Override
    public void prefetchOnElement(TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnElement(c.forTrigger(subTrigger));
        }
    }

    @SafeVarargs
    public static TriggerStateMachine inOrder(TriggerStateMachine ... triggers) {
        return new AfterEachStateMachine(Arrays.asList(triggers));
    }

    public static TriggerStateMachine inOrder(Iterable<? extends TriggerStateMachine> triggers) {
        return new AfterEachStateMachine((List<TriggerStateMachine>)ImmutableList.copyOf(triggers));
    }

    @Override
    public void onElement(TriggerStateMachine.OnElementContext c) throws Exception {
        if (!c.trigger().isMerging()) {
            c.trigger().firstUnfinishedSubTrigger().invokeOnElement(c);
        } else {
            for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
                subTrigger.invokeOnElement(c);
            }
        }
    }

    @Override
    public void prefetchOnMerge(TriggerStateMachine.MergingPrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchOnMerge(c.forTrigger(subTrigger));
        }
    }

    @Override
    public void onMerge(TriggerStateMachine.OnMergeContext context) throws Exception {
        boolean priorTriggersAllFinished = true;
        for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
            if (priorTriggersAllFinished) {
                subTrigger.invokeOnMerge(context);
                priorTriggersAllFinished &= context.forTrigger(subTrigger).trigger().isFinished();
                continue;
            }
            subTrigger.invokeClear(context);
        }
        this.updateFinishedState(context);
    }

    @Override
    public void prefetchShouldFire(TriggerStateMachine.PrefetchContext c) {
        for (ExecutableTriggerStateMachine subTrigger : c.trigger().subTriggers()) {
            subTrigger.invokePrefetchShouldFire(c.forTrigger(subTrigger));
        }
    }

    @Override
    public boolean shouldFire(TriggerStateMachine.TriggerContext context) throws Exception {
        ExecutableTriggerStateMachine firstUnfinished = context.trigger().firstUnfinishedSubTrigger();
        return firstUnfinished.invokeShouldFire(context);
    }

    @Override
    public void onFire(TriggerStateMachine.TriggerContext context) throws Exception {
        context.trigger().firstUnfinishedSubTrigger().invokeOnFire(context);
        if (context.trigger().isMerging()) {
            for (ExecutableTriggerStateMachine subTrigger : context.trigger().subTriggers()) {
                subTrigger.invokeClear(context);
            }
        }
        this.updateFinishedState(context);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterEach.inOrder(");
        Joiner.on((String)", ").appendTo(builder, (Iterable)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }

    private void updateFinishedState(TriggerStateMachine.TriggerContext context) {
        context.trigger().setFinished(context.trigger().firstUnfinishedSubTrigger() == null);
    }
}

