/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.mongo.metadata;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.HopMetadataBase;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.mongo.MongoDbException;
import org.apache.hop.mongo.MongoProp;
import org.apache.hop.mongo.MongoProperties;
import org.apache.hop.mongo.NamedReadPreference;
import org.apache.hop.mongo.metadata.MongoDbAuthenticationMechanism;
import org.apache.hop.mongo.wrapper.HopMongoUtilLogger;
import org.apache.hop.mongo.wrapper.MongoClientWrapper;
import org.apache.hop.mongo.wrapper.MongoClientWrapperFactory;
import org.apache.hop.mongo.wrapper.MongoWrapperClientFactory;

@GuiPlugin
@HopMetadata(key="mongodb-connection", name="MongoDB Connection", description="Describes a MongoDB connection", image="MongoDB_Leaf_FullColor_RGB.svg", documentationUrl="/metadata-types/mongodb-connection.html")
public class MongoDbConnection
extends HopMetadataBase
implements IHopMetadata {
    public static final String WIDGET_ID_HOSTNAME = "10000-hostname";
    public static final String WIDGET_ID_PORT = "10100-port";
    public static final String WIDGET_ID_DB_NAME = "10200-database-name";
    public static final String WIDGET_ID_COLLECTION = "10300-collection";
    public static final String WIDGET_ID_AUTH_DB_NAME = "10400-auth-database-name";
    public static final String WIDGET_ID_AUTH_USER = "10500-auth-user";
    public static final String WIDGET_ID_AUTH_PASSWORD = "10600-auth-password";
    public static final String WIDGET_ID_AUTH_MECHANISM = "10700-auth-mechanism";
    public static final String WIDGET_ID_USE_KERBEROS = "10800-use-kerberos";
    public static final String WIDGET_ID_CONNECTION_TIMEOUT_MS = "10900-connection-timeout-ms";
    public static final String WIDGET_ID_SOCKET_TIMEOUT_MS = "11000-socket-timeout-ms";
    public static final String WIDGET_ID_READ_PREFERENCE = "11100-read-preference";
    public static final String WIDGET_ID_USE_ALL_REPLICA_SET_MEMBERS = "11200-use-all-replica-set-members";
    public static final String WIDGET_ID_READ_PREF_TAG_SETS = "11300-read-pref-tag-sets";
    public static final String WIDGET_ID_USE_SSL_SOCKET_FACTORY = "11400-use-ssl-socket-factory";
    public static final String WIDGET_ID_WRITE_CONCERN = "11500-write-concern";
    public static final String WIDGET_ID_TIMEOUT_MS = "11600-timeout-ms";
    public static final String WIDGET_ID_JOURNALED = "11700-journaled";
    @HopMetadataProperty
    @GuiWidgetElement(id="10000-hostname", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Hostname", toolTip="Specify the hostname of your MongoDB server")
    private String hostname = "localhost";
    @HopMetadataProperty
    @GuiWidgetElement(id="10100-port", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Port", toolTip="The default port of a MongoDB server is 27017")
    private String port = "27017";
    @HopMetadataProperty
    @GuiWidgetElement(id="10200-database-name", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Database name", toolTip="The MongoDB database name to use")
    private String dbName;
    @HopMetadataProperty
    @GuiWidgetElement(id="10400-auth-database-name", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Authentication database", toolTip="The MongoDB database to authenticate against")
    private String authenticationDatabaseName;
    @HopMetadataProperty
    @GuiWidgetElement(id="10500-auth-user", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Username", toolTip="The username to authenticate with")
    private String authenticationUser;
    @HopMetadataProperty(password=true)
    @GuiWidgetElement(id="10600-auth-password", type=GuiElementType.TEXT, password=true, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Password", toolTip="The password to authenticate with")
    private String authenticationPassword;
    @HopMetadataProperty
    @GuiWidgetElement(id="10700-auth-mechanism", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Authentication mechanism", toolTip="The authentication mechanism to use", variables=false)
    private MongoDbAuthenticationMechanism authenticationMechanism = MongoDbAuthenticationMechanism.PLAIN;
    @HopMetadataProperty
    @GuiWidgetElement(id="10800-use-kerberos", type=GuiElementType.CHECKBOX, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Use Kerberos?", toolTip="Check this option if you want to use Kerberos to authenticate")
    private boolean usingKerberos;
    @HopMetadataProperty
    @GuiWidgetElement(id="10900-connection-timeout-ms", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Connection timeout (ms)", toolTip="Specify the connection timeout in milliseconds. Leave blank for the default.")
    private String connectTimeoutMs = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11000-socket-timeout-ms", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Socket timeout (ms)", toolTip="Specify the socket timeout in milliseconds. Leave blank for the default.")
    private String socketTimeoutMs = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11100-read-preference", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Read preference", toolTip="Select the read preference: primary, primaryPreferred, secondary, secondaryPreferred, nearest", variables=false)
    private NamedReadPreference readPreference = NamedReadPreference.PRIMARY;
    @HopMetadataProperty
    @GuiWidgetElement(id="11200-use-all-replica-set-members", type=GuiElementType.CHECKBOX, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Use all replica set members?", toolTip="Select this option to discover and use all replica set members (if not already specified in the hosts field")
    private boolean usingAllReplicaSetMembers;
    @HopMetadataProperty
    @GuiWidgetElement(id="11300-read-pref-tag-sets", type=GuiElementType.COMBO, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Specify the read preference tag sets", toolTip="optional tag sets to use with read preference settings (JSON String).  See the MongoDB documentation on 'Replica Set Tag Sets'")
    private String readPrefTagSets;
    @HopMetadataProperty
    @GuiWidgetElement(id="11400-use-ssl-socket-factory", type=GuiElementType.CHECKBOX, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Use an SSL socket factory?", toolTip="Check this option if you want to use use an SSL socket factory")
    private boolean usingSslSocketFactory;
    @HopMetadataProperty
    @GuiWidgetElement(id="11500-write-concern", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Write concern", toolTip="default = 1 (standalone or primary acknowledges writes; -1 no acknowledgement and all errors suppressed; 0 no acknowledgement, but socket/network errors passed to client; \"majority\" returns after a majority of the replica set members have acknowledged; n (>1) returns after n replica set members have acknowledged; tags (string) specific replica set members with the tags need to acknowledge")
    private String writeConcern = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11600-timeout-ms", type=GuiElementType.TEXT, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Replication Timeout (ms)", toolTip="The time in milliseconds to wait for replication to succeed, as specified in the w option, before timing out")
    private String replicationTimeoutMs = "";
    @HopMetadataProperty
    @GuiWidgetElement(id="11700-journaled", type=GuiElementType.CHECKBOX, parentId="MongoDbConnectionEditor.Widgets.ParentId", label="Journaled?", toolTip="Select for write operations to wait until MongoDB acknowledges the write operations and commits the data to the journal on disk")
    private boolean journaled = true;
    private static MongoWrapperClientFactory mongoWrapperClientFactory = (props, log) -> MongoClientWrapperFactory.createMongoClientWrapper(props, log);

    public MongoDbConnection() {
    }

    public MongoDbConnection(MongoDbConnection m) {
        super(m.name);
        this.hostname = m.hostname;
        this.port = m.port;
        this.dbName = m.dbName;
        this.authenticationDatabaseName = m.authenticationDatabaseName;
        this.authenticationUser = m.authenticationUser;
        this.authenticationPassword = m.authenticationPassword;
        this.authenticationMechanism = m.authenticationMechanism;
        this.usingKerberos = m.usingKerberos;
        this.connectTimeoutMs = m.connectTimeoutMs;
        this.socketTimeoutMs = m.socketTimeoutMs;
        this.readPreference = m.readPreference;
        this.usingAllReplicaSetMembers = m.usingAllReplicaSetMembers;
        this.readPrefTagSets = m.readPrefTagSets;
        this.usingSslSocketFactory = m.usingSslSocketFactory;
        this.writeConcern = m.writeConcern;
        this.replicationTimeoutMs = m.replicationTimeoutMs;
        this.journaled = m.journaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test(IVariables variables, ILogChannel log) throws MongoDbException {
        MongoClientWrapper wrapper = this.createWrapper(variables, log);
        try {
            wrapper.test();
        }
        finally {
            wrapper.dispose();
        }
    }

    public MongoClientWrapper createWrapper(IVariables variables, ILogChannel log) throws MongoDbException {
        return mongoWrapperClientFactory.createMongoClientWrapper(this.createPropertiesBuilder(variables).build(), new HopMongoUtilLogger(log));
    }

    public MongoProperties.Builder createPropertiesBuilder(IVariables variables) {
        MongoProperties.Builder propertiesBuilder = new MongoProperties.Builder();
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.HOST, this.hostname);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.PORT, this.port);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.DBNAME, this.dbName);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.connectTimeout, this.connectTimeoutMs);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.socketTimeout, this.socketTimeoutMs);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.readPreference, this.readPreference.getName());
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.writeConcern, this.writeConcern);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.wTimeout, this.replicationTimeoutMs);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.JOURNALED, Boolean.toString(this.journaled));
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.USE_ALL_REPLICA_SET_MEMBERS, Boolean.toString(this.usingAllReplicaSetMembers));
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.AUTH_DATABASE, this.authenticationDatabaseName);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.USERNAME, this.authenticationUser);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.PASSWORD, this.authenticationPassword);
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.AUTH_MECHA, this.authenticationMechanism.name());
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.USE_KERBEROS, Boolean.toString(this.usingKerberos));
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.useSSL, Boolean.toString(this.usingSslSocketFactory));
        MongoDbConnection.setIfNotNullOrEmpty(variables, propertiesBuilder, MongoProp.tagSet, this.readPrefTagSets);
        return propertiesBuilder;
    }

    private static void setIfNotNullOrEmpty(IVariables variables, MongoProperties.Builder builder, MongoProp prop, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            builder.set(prop, variables.resolve(value));
        }
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public String getAuthenticationDatabaseName() {
        return this.authenticationDatabaseName;
    }

    public void setAuthenticationDatabaseName(String authenticationDatabaseName) {
        this.authenticationDatabaseName = authenticationDatabaseName;
    }

    public String getAuthenticationUser() {
        return this.authenticationUser;
    }

    public void setAuthenticationUser(String authenticationUser) {
        this.authenticationUser = authenticationUser;
    }

    public String getAuthenticationPassword() {
        return this.authenticationPassword;
    }

    public void setAuthenticationPassword(String authenticationPassword) {
        this.authenticationPassword = authenticationPassword;
    }

    public MongoDbAuthenticationMechanism getAuthenticationMechanism() {
        return this.authenticationMechanism;
    }

    public void setAuthenticationMechanism(MongoDbAuthenticationMechanism authenticationMechanism) {
        this.authenticationMechanism = authenticationMechanism;
    }

    public boolean isUsingKerberos() {
        return this.usingKerberos;
    }

    public void setUsingKerberos(boolean usingKerberos) {
        this.usingKerberos = usingKerberos;
    }

    public String getConnectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    public void setConnectTimeoutMs(String connectTimeoutMs) {
        this.connectTimeoutMs = connectTimeoutMs;
    }

    public String getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public void setSocketTimeoutMs(String socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public NamedReadPreference getReadPreference() {
        return this.readPreference;
    }

    public void setReadPreference(NamedReadPreference readPreference) {
        this.readPreference = readPreference;
    }

    public boolean isUsingAllReplicaSetMembers() {
        return this.usingAllReplicaSetMembers;
    }

    public void setUsingAllReplicaSetMembers(boolean usingAllReplicaSetMembers) {
        this.usingAllReplicaSetMembers = usingAllReplicaSetMembers;
    }

    public String getReadPrefTagSets() {
        return this.readPrefTagSets;
    }

    public void setReadPrefTagSets(String readPrefTagSets) {
        this.readPrefTagSets = readPrefTagSets;
    }

    public boolean isUsingSslSocketFactory() {
        return this.usingSslSocketFactory;
    }

    public void setUsingSslSocketFactory(boolean usingSslSocketFactory) {
        this.usingSslSocketFactory = usingSslSocketFactory;
    }

    public String getWriteConcern() {
        return this.writeConcern;
    }

    public void setWriteConcern(String writeConcern) {
        this.writeConcern = writeConcern;
    }

    public String getReplicationTimeoutMs() {
        return this.replicationTimeoutMs;
    }

    public void setReplicationTimeoutMs(String replicationTimeoutMs) {
        this.replicationTimeoutMs = replicationTimeoutMs;
    }

    public boolean isJournaled() {
        return this.journaled;
    }

    public void setJournaled(boolean journaled) {
        this.journaled = journaled;
    }
}

