/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.welcome;

import org.apache.hop.core.config.HopConfig;
import org.apache.hop.core.config.plugin.ConfigPlugin;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.IGuiPluginCompositeWidgetsListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import picocli.CommandLine;

@ConfigPlugin(id="WelcomeDialogOption", description="Enable or disable the welcome dialog")
@GuiPlugin(description="Welcome dialog")
public class WelcomeDialogOptions
implements IConfigOptions,
IGuiPluginCompositeWidgetsListener {
    @CommandLine.Option(names={"-wd", "--welcome-dialog-disabled"}, description={"Disable the welcome dialog at startup of the Hop GUI"})
    private boolean welcomeDialogDisabled;
    @CommandLine.Option(names={"-we", "--welcome-dialog-enabled"}, description={"Show the welcome dialog at startup of the Hop GUI"})
    private boolean welcomeDialogEnabled;
    @GuiWidgetElement(id="NoWelcomeDialog", parentId="EnterOptionsDialog-GuiWidgetsParent", type=GuiElementType.CHECKBOX, label="Present the welcome dialog at the startup of the Hop GUI")
    private boolean welcomeDialogShowAtStartup = HopConfig.readOptionBoolean((String)"doNotShowWelcomeDialog", (boolean)false);
    private static WelcomeDialogOptions instance;

    public static WelcomeDialogOptions getInstance() {
        if (instance == null) {
            instance = new WelcomeDialogOptions();
        }
        return instance;
    }

    public boolean handleOption(ILogChannel log, IHasHopMetadataProvider hasHopMetadataProvider, IVariables variables) throws HopException {
        try {
            if (this.welcomeDialogDisabled || this.welcomeDialogEnabled) {
                boolean disabled = this.welcomeDialogDisabled && !this.welcomeDialogEnabled;
                HopConfig.getInstance().saveOption("doNotShowWelcomeDialog", (Object)disabled);
                log.logBasic("The welcome dialog is now " + (disabled ? "disabled" : "enabled"));
                log.logBasic("Note: you can also set variable HOP_NO_WELCOME_DIALOG to prevent the welcome dialog of showing itself at the start of Hop GUI.");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new HopException("Error handling welcome dialog option", (Throwable)e);
        }
    }

    public boolean isWelcomeDialogDisabled() {
        return this.welcomeDialogDisabled;
    }

    public void setWelcomeDialogDisabled(boolean welcomeDialogDisabled) {
        this.welcomeDialogDisabled = welcomeDialogDisabled;
    }

    public boolean isWelcomeDialogEnabled() {
        return this.welcomeDialogEnabled;
    }

    public void setWelcomeDialogEnabled(boolean welcomeDialogEnabled) {
        this.welcomeDialogEnabled = welcomeDialogEnabled;
    }

    public boolean isWelcomeDialogShowAtStartup() {
        return this.welcomeDialogShowAtStartup;
    }

    public void setWelcomeDialogShowAtStartup(boolean welcomeDialogShowAtStartup) {
        this.welcomeDialogShowAtStartup = welcomeDialogShowAtStartup;
    }

    @Override
    public void widgetsCreated(GuiCompositeWidgets compositeWidgets) {
    }

    @Override
    public void widgetsPopulated(GuiCompositeWidgets compositeWidgets) {
    }

    @Override
    public void widgetModified(GuiCompositeWidgets compositeWidgets, Control changedWidget, String widgetId) {
        this.welcomeDialogShowAtStartup = ((Button)changedWidget).getSelection();
        this.persistContents(compositeWidgets);
    }

    @Override
    public void persistContents(GuiCompositeWidgets compositeWidgets) {
        HopConfig.getInstance().saveOption("doNotShowWelcomeDialog", (Object)this.welcomeDialogShowAtStartup);
    }
}

