/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConnectionDroppedException;
import com.ibm.as400.access.DDMDataStream;
import com.ibm.as400.access.Trace;
import java.io.IOException;
import java.io.InputStream;

class DDMACCSECReplyDataStream
extends DDMDataStream {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";

    DDMACCSECReplyDataStream() {
    }

    boolean checkReply(int n) {
        if (this.getCodePoint() != 5292) {
            Trace.log(2, "DDM ACCSEC failed with code point:", this.data_, 8, 2);
            return false;
        }
        if (n == 0) {
            if (this.data_.length < 19) {
                Trace.log(2, "DDM ACCSEC failed: system may be set to *KERBEROS while client is not.", this.data_);
                return false;
            }
            int n2 = this.get16bit(18);
            if (n2 == 4516) {
                Trace.log(2, "DDM ACCSEC SECCHKCD failed:", this.data_, 18, 2);
                return false;
            }
            if (n2 != 4572) {
                Trace.log(2, "DDM ACCSEC SECTKN failed:", this.data_, 18, 2);
                return false;
            }
        }
        return true;
    }

    boolean checkReplyForEUSRIDPWD(int n) {
        if (this.getCodePoint() != 5292) {
            Trace.log(2, "DDM ACCSEC failed with code point:", this.data_, 8, 2);
            return false;
        }
        if (n == 0) {
            if (this.data_.length < 17) {
                Trace.log(2, "DDM ACCSEC failed: system may be set to *KERBEROS while client is not.", this.data_);
                return false;
            }
            int n2 = this.get16bit(12);
            if (n2 == 4516) {
                Trace.log(2, "DDM ACCSEC SECCHKCD failed:", this.data_, 12, 2);
                return false;
            }
            if (n2 != 4514) {
                Trace.log(2, "DDM ACCSEC SECMECH failed:", this.data_, 12, 2);
                return false;
            }
            n2 = this.get16bit(14);
            if (n2 != 9) {
                Trace.log(2, "DDM ACCSEC EUSRIDPWD failed:", this.data_, 14, 2);
                return false;
            }
        }
        return true;
    }

    byte[] getServerSeed() {
        int n = this.get16bit(14);
        if (n != 9) {
            byte[] byArray = new byte[8];
            System.arraycopy(this.data_, 20, byArray, 0, 8);
            return byArray;
        }
        if (this.data_.length >= 84) {
            byte[] byArray = new byte[64];
            System.arraycopy(this.data_, 20, byArray, 0, 64);
            return byArray;
        }
        byte[] byArray = new byte[32];
        System.arraycopy(this.data_, 20, byArray, 0, 32);
        return byArray;
    }

    void read(InputStream inputStream) throws IOException {
        byte[] byArray;
        if (Trace.traceOn_) {
            Trace.log(1, "Receiving DDM ACCSEC reply...");
        }
        if (this.readFromStream(inputStream, byArray = new byte[6], 0, 6) < 6) {
            Trace.log(2, "Failed to read all of the DDM EXCSAT Reply header.");
            throw new ConnectionDroppedException(2);
        }
        this.data_ = new byte[BinaryConverter.byteArrayToUnsignedShort(byArray, 0)];
        System.arraycopy(byArray, 0, this.data_, 0, 6);
        this.readAfterHeader(inputStream);
    }

    public boolean aesUpgrade() {
        int n;
        int n2;
        int n3 = this.get16bit(14);
        return n3 == 9 && (n2 = this.get16bit(18)) == 6409 && (n = this.get16bit(20)) == 2;
    }
}

