/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopConfigException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.neo4j.core.data.GraphData;
import org.apache.hop.neo4j.core.data.GraphPropertyDataType;
import org.apache.hop.neo4j.model.GraphPropertyType;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.shared.NeoHopData;
import org.apache.hop.neo4j.transforms.cypher.CypherData;
import org.apache.hop.neo4j.transforms.cypher.CypherMeta;
import org.apache.hop.neo4j.transforms.cypher.CypherStatement;
import org.apache.hop.neo4j.transforms.cypher.CypherTransactionWork;
import org.apache.hop.neo4j.transforms.cypher.ParameterMapping;
import org.apache.hop.neo4j.transforms.cypher.ReturnValue;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.json.simple.JSONValue;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.ResultSummary;

public class Cypher
extends BaseTransform<CypherMeta, CypherData> {
    public Cypher(TransformMeta transformMeta, CypherMeta meta, CypherData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean init() {
        List transform = this.getPipelineMeta().findPreviousTransforms(this.getTransformMeta());
        boolean bl = ((CypherData)this.data).hasInput = transform != null && transform.size() > 0;
        if (StringUtils.isEmpty((String)this.resolve(((CypherMeta)this.meta).getConnectionName()))) {
            this.log.logError("You need to specify a Neo4j connection to use in this transform");
            return false;
        }
        try {
            ((CypherData)this.data).neoConnection = (NeoConnection)this.metadataProvider.getSerializer(NeoConnection.class).load(this.resolve(((CypherMeta)this.meta).getConnectionName()));
            if (((CypherData)this.data).neoConnection == null) {
                this.log.logError("Connection '" + this.resolve(((CypherMeta)this.meta).getConnectionName()) + "' could not be found in the metadata: " + this.metadataProvider.getDescription());
                return false;
            }
        }
        catch (HopException e) {
            this.log.logError("Could not gencsv Neo4j connection '" + this.resolve(((CypherMeta)this.meta).getConnectionName()) + "' from the metastore", (Throwable)e);
            return false;
        }
        ((CypherData)this.data).batchSize = Const.toLong((String)this.resolve(((CypherMeta)this.meta).getBatchSize()), (long)1L);
        int retries = Const.toInt((String)this.resolve(((CypherMeta)this.meta).getNrRetriesOnError()), (int)0);
        if (retries < 0) {
            this.log.logError("The number of retries on an error should be larger than 0, not " + retries);
            return false;
        }
        ((CypherData)this.data).attempts = 1 + retries;
        try {
            this.createDriverSession();
        }
        catch (Exception e) {
            this.log.logError("Unable to get or create Neo4j database driver for database '" + ((CypherData)this.data).neoConnection.getName() + "'", (Throwable)e);
            return false;
        }
        return super.init();
    }

    public void dispose() {
        this.wrapUpTransaction();
        this.closeSessionDriver();
        super.dispose();
    }

    private void closeSessionDriver() {
        if (((CypherData)this.data).session != null) {
            ((CypherData)this.data).session.close();
        }
        if (((CypherData)this.data).driver != null) {
            ((CypherData)this.data).driver.close();
        }
    }

    private void createDriverSession() throws HopConfigException {
        ((CypherData)this.data).driver = ((CypherData)this.data).neoConnection.getDriver(this.log, (IVariables)this);
        ((CypherData)this.data).session = ((CypherData)this.data).neoConnection.getSession(this.log, ((CypherData)this.data).driver, (IVariables)this);
    }

    private void reconnect() throws HopConfigException {
        this.closeSessionDriver();
        this.log.logBasic("RECONNECTING to database");
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.createDriverSession();
    }

    public boolean processRow() throws HopException {
        Object[] row = new Object[]{};
        if (((CypherData)this.data).hasInput && (row = this.getRow()) == null) {
            this.wrapUpTransaction();
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((CypherData)this.data).outputRowMeta = ((CypherData)this.data).hasInput ? this.getInputRowMeta().clone() : new RowMeta();
            ((CypherMeta)this.meta).getFields(((CypherData)this.data).outputRowMeta, this.getTransformName(), null, this.getTransformMeta(), (IVariables)this, this.metadataProvider);
            if (!((CypherMeta)this.meta).getParameterMappings().isEmpty() && this.getInputRowMeta() == null) {
                throw new HopException("Please provide this transform with input if you want to set parameters");
            }
            ((CypherData)this.data).fieldIndexes = new int[((CypherMeta)this.meta).getParameterMappings().size()];
            for (int i = 0; i < ((CypherMeta)this.meta).getParameterMappings().size(); ++i) {
                String field = ((CypherMeta)this.meta).getParameterMappings().get(i).getField();
                ((CypherData)this.data).fieldIndexes[i] = this.getInputRowMeta().indexOfValue(field);
                if (((CypherData)this.data).fieldIndexes[i] >= 0) continue;
                throw new HopTransformException("Unable to find parameter field '" + field);
            }
            ((CypherData)this.data).cypherFieldIndex = -1;
            if (((CypherData)this.data).hasInput) {
                ((CypherData)this.data).cypherFieldIndex = this.getInputRowMeta().indexOfValue(((CypherMeta)this.meta).getCypherField());
                if (((CypherMeta)this.meta).isCypherFromField() && ((CypherData)this.data).cypherFieldIndex < 0) {
                    throw new HopTransformException("Unable to find cypher field '" + ((CypherMeta)this.meta).getCypherField() + "'");
                }
            }
            ((CypherData)this.data).cypher = this.resolve(((CypherMeta)this.meta).getCypher());
            ((CypherData)this.data).unwindList = new ArrayList<Map<String, Object>>();
            ((CypherData)this.data).unwindMapName = this.resolve(((CypherMeta)this.meta).getUnwindMapName());
            ((CypherData)this.data).cypherStatements = new ArrayList<CypherStatement>();
        }
        if (((CypherMeta)this.meta).isCypherFromField()) {
            ((CypherData)this.data).cypher = this.getInputRowMeta().getString(row, ((CypherData)this.data).cypherFieldIndex);
            this.log.logDetailed("Cypher statement from field is: " + ((CypherData)this.data).cypher);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < ((CypherMeta)this.meta).getParameterMappings().size(); ++i) {
            ParameterMapping mapping = ((CypherMeta)this.meta).getParameterMappings().get(i);
            IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(((CypherData)this.data).fieldIndexes[i]);
            Object valueData = row[((CypherData)this.data).fieldIndexes[i]];
            GraphPropertyType propertyType = GraphPropertyType.parseCode(mapping.getNeoType());
            if (propertyType == null) {
                throw new HopException("Unable to convert to unknown property type for field '" + valueMeta.toStringMeta() + "'");
            }
            Object neoValue = propertyType.convertFromHop(valueMeta, valueData);
            parameters.put(mapping.getParameter(), neoValue);
        }
        ((CypherData)this.data).returnSourceTypeMap = new HashMap<String, GraphPropertyDataType>();
        for (ReturnValue returnValue : ((CypherMeta)this.meta).getReturnValues()) {
            if (!StringUtils.isNotEmpty((String)returnValue.getSourceType())) continue;
            String name = returnValue.getName();
            GraphPropertyDataType type = GraphPropertyDataType.parseCode(returnValue.getSourceType());
            ((CypherData)this.data).returnSourceTypeMap.put(name, type);
        }
        if (((CypherMeta)this.meta).isUsingUnwind()) {
            ((CypherData)this.data).unwindList.add(parameters);
            ++((CypherData)this.data).outputCount;
            if (((CypherData)this.data).outputCount >= ((CypherData)this.data).batchSize) {
                this.writeUnwindList();
            }
        } else {
            try {
                this.runCypherStatement(row, ((CypherData)this.data).cypher, parameters);
            }
            catch (ServiceUnavailableException e) {
                if (((CypherMeta)this.meta).isRetryingOnDisconnect()) {
                    this.reconnect();
                    this.runCypherStatement(row, ((CypherData)this.data).cypher, parameters);
                }
                throw e;
            }
            catch (HopException e) {
                this.setErrors(1L);
                this.stopAll();
                throw e;
            }
        }
        if (((CypherData)this.data).hasInput) {
            return true;
        }
        this.setOutputDone();
        return false;
    }

    private void runCypherStatement(Object[] row, String cypher, Map<String, Object> parameters) throws HopException {
        ((CypherData)this.data).cypherStatements.add(new CypherStatement(row, cypher, parameters));
        if ((long)((CypherData)this.data).cypherStatements.size() >= ((CypherData)this.data).batchSize || !((CypherData)this.data).hasInput) {
            this.runCypherStatementsBatch();
        }
    }

    private void runCypherStatementsBatch() throws HopException {
        if (((CypherData)this.data).cypherStatements == null || ((CypherData)this.data).cypherStatements.isEmpty()) {
            return;
        }
        TransactionWork transactionWork = transaction -> {
            for (CypherStatement cypherStatement : ((CypherData)this.data).cypherStatements) {
                Result result = transaction.run(cypherStatement.getCypher(), cypherStatement.getParameters());
                try {
                    this.getResultRows(result, cypherStatement.getRow(), false);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error parsing result of cypher statement '" + cypherStatement.getCypher() + "'", e);
                }
            }
            return ((CypherData)this.data).cypherStatements.size();
        };
        try {
            int nrProcessed = 0;
            for (int attempt = 0; attempt < ((CypherData)this.data).attempts; ++attempt) {
                try {
                    if (((CypherMeta)this.meta).isReadOnly()) {
                        nrProcessed = (Integer)((CypherData)this.data).session.readTransaction(transactionWork);
                        this.setLinesInput(this.getLinesInput() + (long)((CypherData)this.data).cypherStatements.size());
                        break;
                    }
                    nrProcessed = (Integer)((CypherData)this.data).session.writeTransaction(transactionWork);
                    this.setLinesOutput(this.getLinesOutput() + (long)((CypherData)this.data).cypherStatements.size());
                    break;
                }
                catch (Exception e) {
                    if (attempt + 1 >= ((CypherData)this.data).attempts) {
                        throw e;
                    }
                    this.logBasic("Retrying unwind after error: " + e.getMessage());
                    continue;
                }
            }
            if (this.log.isDebug()) {
                this.logDebug("Processed " + nrProcessed + " statements");
            }
            ((CypherData)this.data).cypherStatements.clear();
        }
        catch (Exception e) {
            throw new HopException("Unable to execute batch of cypher statements (" + ((CypherData)this.data).cypherStatements.size() + ")", (Throwable)e);
        }
    }

    private List<Object[]> writeUnwindList() throws HopException {
        HashMap<String, Object> unwindMap = new HashMap<String, Object>();
        unwindMap.put(((CypherData)this.data).unwindMapName, ((CypherData)this.data).unwindList);
        List<Object[]> resultRows = null;
        CypherTransactionWork cypherTransactionWork = new CypherTransactionWork(this, new Object[0], true, ((CypherData)this.data).cypher, unwindMap);
        try {
            for (int attempt = 0; attempt < ((CypherData)this.data).attempts; ++attempt) {
                if (attempt > 0) {
                    this.log.logBasic("Attempt #" + (attempt + 1) + "/" + ((CypherData)this.data).attempts + " on Neo4j transaction");
                }
                try {
                    if (((CypherMeta)this.meta).isReadOnly()) {
                        ((CypherData)this.data).session.readTransaction((TransactionWork)cypherTransactionWork);
                    } else {
                        ((CypherData)this.data).session.writeTransaction((TransactionWork)cypherTransactionWork);
                    }
                    break;
                }
                catch (Exception e) {
                    if (attempt + 1 >= ((CypherData)this.data).attempts) {
                        throw e;
                    }
                    this.log.logBasic("Retrying transaction after attempt #" + (attempt + 1) + " with error : " + e.getMessage());
                    continue;
                }
            }
        }
        catch (ServiceUnavailableException e) {
            if (((CypherMeta)this.meta).isRetryingOnDisconnect()) {
                this.reconnect();
                if (((CypherMeta)this.meta).isReadOnly()) {
                    ((CypherData)this.data).session.readTransaction((TransactionWork)cypherTransactionWork);
                } else {
                    ((CypherData)this.data).session.writeTransaction((TransactionWork)cypherTransactionWork);
                }
            }
            throw e;
        }
        catch (Exception e) {
            ((CypherData)this.data).session.close();
            this.stopAll();
            this.setErrors(1L);
            this.setOutputDone();
            throw new HopException("Unexpected error writing unwind list to Neo4j", (Throwable)e);
        }
        this.setLinesOutput(this.getLinesOutput() + (long)((CypherData)this.data).unwindList.size());
        ((CypherData)this.data).unwindList.clear();
        ((CypherData)this.data).outputCount = 0L;
        return resultRows;
    }

    public void getResultRows(Result result, Object[] row, boolean unwind) throws HopException {
        if (result != null) {
            if (((CypherMeta)this.meta).isReturningGraph()) {
                GraphData graphData = new GraphData(result);
                graphData.setSourcePipelineName(this.getPipelineMeta().getName());
                graphData.setSourceTransformName(this.getTransformName());
                Object[] outputRowData = unwind ? RowDataUtil.allocateRowData((int)((CypherData)this.data).outputRowMeta.size()) : RowDataUtil.createResizedCopy((Object[])row, (int)((CypherData)this.data).outputRowMeta.size());
                int index = ((CypherData)this.data).hasInput && !unwind ? this.getInputRowMeta().size() : 0;
                outputRowData[index] = graphData;
                this.putRow(((CypherData)this.data).outputRowMeta, outputRowData);
            } else if (((CypherMeta)this.meta).getReturnValues().isEmpty()) {
                this.putRow(((CypherData)this.data).outputRowMeta, row);
            } else {
                while (result.hasNext()) {
                    Record record = result.next();
                    Object[] outputRow = unwind ? RowDataUtil.allocateRowData((int)((CypherData)this.data).outputRowMeta.size()) : RowDataUtil.createResizedCopy((Object[])row, (int)((CypherData)this.data).outputRowMeta.size());
                    int index = ((CypherData)this.data).hasInput && !unwind ? this.getInputRowMeta().size() : 0;
                    for (ReturnValue returnValue : ((CypherMeta)this.meta).getReturnValues()) {
                        Value recordValue = record.get(returnValue.getName());
                        IValueMeta targetValueMeta = ((CypherData)this.data).outputRowMeta.getValueMeta(index);
                        GraphPropertyDataType neoType = ((CypherData)this.data).returnSourceTypeMap.get(returnValue.getName());
                        Object value = NeoHopData.convertNeoToHopValue(returnValue.getName(), recordValue, neoType, targetValueMeta);
                        outputRow[index++] = value;
                    }
                    this.putRow(((CypherData)this.data).outputRowMeta, outputRow);
                }
            }
            if (this.processSummary(result)) {
                this.setErrors(1L);
                this.stopAll();
                this.setOutputDone();
                throw new HopException("Error found in executing cypher statement");
            }
        }
    }

    private String convertToString(Value recordValue, GraphPropertyDataType sourceType) {
        if (recordValue == null) {
            return null;
        }
        if (sourceType == null) {
            return JSONValue.toJSONString((Object)recordValue.asObject());
        }
        switch (sourceType) {
            case String: {
                return recordValue.asString();
            }
            case List: {
                return JSONValue.toJSONString((Object)recordValue.asList());
            }
            case Map: {
                return JSONValue.toJSONString((Object)recordValue.asMap());
            }
            case Node: {
                GraphData graphData = new GraphData();
                graphData.update(recordValue.asNode());
                return graphData.toJson().toJSONString();
            }
            case Path: {
                GraphData graphData = new GraphData();
                graphData.update(recordValue.asPath());
                return graphData.toJson().toJSONString();
            }
        }
        return JSONValue.toJSONString((Object)recordValue.asObject());
    }

    private GraphData convertToGraphData(Value recordValue, GraphPropertyDataType sourceType) throws HopException {
        GraphData graphData;
        if (recordValue == null) {
            return null;
        }
        if (sourceType == null) {
            throw new HopException("Please specify a Neo4j source data type to convert to Graph.  NODE, RELATIONSHIP and PATH are supported.");
        }
        switch (sourceType) {
            case Node: {
                graphData = new GraphData();
                graphData.update(recordValue.asNode());
                break;
            }
            case Path: {
                graphData = new GraphData();
                graphData.update(recordValue.asPath());
                break;
            }
            default: {
                throw new HopException("We can only convert NODE, PATH and RELATIONSHIP source values to a Graph data type, not " + sourceType.name());
            }
        }
        return graphData;
    }

    private boolean processSummary(Result result) {
        if (((CypherMeta)this.meta).isUsingUnwind()) {
            return false;
        }
        boolean error = false;
        ResultSummary summary = result.consume();
        for (Notification notification : summary.notifications()) {
            if ("WARNING".equalsIgnoreCase(notification.severity())) {
                this.log.logBasic(notification.severity() + " : " + notification.title() + " : " + notification.code() + " : " + notification.description() + ", position " + String.valueOf(notification.position()));
                continue;
            }
            this.log.logError(notification.severity() + " : " + notification.title());
            this.log.logError(notification.code() + " : " + notification.description() + ", position " + String.valueOf(notification.position()));
            error = true;
        }
        return error;
    }

    public void batchComplete() throws HopException {
        try {
            this.wrapUpTransaction();
        }
        catch (Exception e) {
            this.setErrors(this.getErrors() + 1L);
            this.stopAll();
            throw new HopException("Unable to complete batch of records", (Throwable)e);
        }
    }

    private void wrapUpTransaction() {
        if (!this.isStopped()) {
            try {
                if (((CypherMeta)this.meta).isUsingUnwind() && ((CypherData)this.data).unwindList != null) {
                    if (((CypherData)this.data).unwindList.size() > 0) {
                        this.writeUnwindList();
                    }
                } else if (((CypherData)this.data).cypherStatements != null && ((CypherData)this.data).cypherStatements.size() > 0) {
                    this.runCypherStatementsBatch();
                }
            }
            catch (Exception e) {
                this.setErrors(this.getErrors() + 1L);
                this.stopAll();
                throw new RuntimeException("Unable to run batch of cypher statements", e);
            }
        }
        if (((CypherData)this.data).outputCount > 0L) {
            if (((CypherData)this.data).transaction != null) {
                if (this.getErrors() == 0L) {
                    ((CypherData)this.data).transaction.commit();
                } else {
                    ((CypherData)this.data).transaction.rollback();
                }
                ((CypherData)this.data).transaction.close();
            }
            ((CypherData)this.data).outputCount = 0L;
        }
    }
}

