/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.avro;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeDeserializerBase;
import com.fasterxml.jackson.dataformat.avro.schema.AvroSchemaHelper;
import java.io.IOException;

public class AvroTypeDeserializer
extends TypeDeserializerBase {
    private static final long serialVersionUID = 1L;

    protected AvroTypeDeserializer(JavaType baseType, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(baseType, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    protected AvroTypeDeserializer(TypeDeserializerBase src, BeanProperty property) {
        super(src, property);
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return new AvroTypeDeserializer(this, prop);
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.EXISTING_PROPERTY;
    }

    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserializeTypedFromAny(p, ctxt);
    }

    public Object deserializeTypedFromArray(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserializeTypedFromAny(p, ctxt);
    }

    public Object deserializeTypedFromScalar(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserializeTypedFromAny(p, ctxt);
    }

    public Object deserializeTypedFromAny(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.getTypeId() == null && this.getDefaultImpl() == null) {
            JsonDeserializer deser = this._findDeserializer(ctxt, AvroSchemaHelper.getTypeId(this._baseType));
            if (deser == null) {
                ctxt.reportInputMismatch(this._baseType, "No (native) type id found when one was expected for polymorphic type handling", new Object[0]);
                return null;
            }
            return deser.deserialize(p, ctxt);
        }
        return this._deserializeWithNativeTypeId(p, ctxt, p.getTypeId());
    }

    protected JavaType _handleUnknownTypeId(DeserializationContext ctxt, String typeId) throws IOException {
        if (ctxt.hasValueDeserializerFor(this._baseType, null)) {
            return this._baseType;
        }
        return super._handleUnknownTypeId(ctxt, typeId);
    }
}

