/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.vertica.bulkloader.nativebinary;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.pipeline.transforms.vertica.bulkloader.nativebinary.ColumnType;

public class ColumnSpec {
    private static final byte BYTE_ZERO = 0;
    private static final byte BYTE_ONE = 1;
    private static final byte BYTE_SPACE = 32;
    public final ColumnType type;
    public int bytes;
    public final int scale;
    private final int maxLength;
    private CharBuffer charBuffer;
    private CharsetEncoder charEncoder;
    private ByteBuffer mainBuffer;
    private final GregorianCalendar calendarLocalTZ = new GregorianCalendar();
    private final Calendar calendarUTC = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final int BASE_DATE_JDN = ColumnSpec.computeJdn(2000, 1, 1);
    private static final long BASE_DATE_UTC_MILLIS;

    public ColumnSpec(PrecisionScaleWidthType precisionScaleWidthType, int precision, int scale) {
        this.type = precisionScaleWidthType.type;
        this.bytes = -1;
        this.scale = scale;
        this.maxLength = precision;
    }

    public ColumnSpec(UserDefinedWidthType userDefinedWidthType, int bytes) {
        this.type = userDefinedWidthType.type;
        this.bytes = bytes;
        this.scale = 0;
        this.maxLength = bytes;
    }

    public ColumnSpec(ConstantWidthType constantWidthType) {
        this.type = constantWidthType.type;
        this.bytes = constantWidthType.bytes;
        this.scale = 0;
        this.maxLength = constantWidthType.bytes;
    }

    public ColumnSpec(VariableWidthType variableWidthType, int maxlenght) {
        this.type = variableWidthType.type;
        this.bytes = variableWidthType.bytes;
        this.scale = 0;
        this.maxLength = maxlenght;
    }

    public void setCharBuffer(CharBuffer charBuffer) {
        this.charBuffer = charBuffer;
    }

    public void setCharEncoder(CharsetEncoder charEncoder) {
        this.charEncoder = charEncoder;
    }

    public void setMainBuffer(ByteBuffer buffer) {
        this.mainBuffer = buffer;
    }

    public void encode(IValueMeta valueMeta, Object value) throws CharacterCodingException, UnsupportedEncodingException, HopValueException {
        if (value == null || valueMeta == null || valueMeta.getNativeDataType(value) == null) {
            return;
        }
        block0 : switch (this.type) {
            case BINARY: {
                byte[] inputBinary = valueMeta.getBinaryString(value);
                int length = inputBinary.length;
                this.mainBuffer.put(inputBinary);
                for (int i = 0; i < this.bytes - length; ++i) {
                    this.mainBuffer.put((byte)0);
                }
                break;
            }
            case BOOLEAN: {
                this.mainBuffer.put(valueMeta.getBoolean(value) != false ? (byte)1 : 0);
                break;
            }
            case CHAR: {
                this.charBuffer.clear();
                this.charEncoder.reset();
                this.charBuffer.put(valueMeta.getString(value));
                this.charBuffer.flip();
                int prevPosition = this.mainBuffer.position();
                this.charEncoder.encode(this.charBuffer, this.mainBuffer, true);
                int encodedLength = this.mainBuffer.position() - prevPosition;
                for (int i = 0; i < this.bytes - encodedLength; ++i) {
                    this.mainBuffer.put((byte)32);
                }
                break;
            }
            case DATE: {
                this.calendarLocalTZ.setTime(valueMeta.getDate(value));
                int julianEnd = ColumnSpec.computeJdn(this.calendarLocalTZ);
                this.mainBuffer.putLong(julianEnd - BASE_DATE_JDN);
                break;
            }
            case FLOAT: {
                this.mainBuffer.putDouble(valueMeta.getNumber(value));
                break;
            }
            case INTEGER: {
                switch (this.bytes) {
                    case 1: {
                        this.mainBuffer.put(valueMeta.getInteger(value).byteValue());
                        break block0;
                    }
                    case 2: {
                        this.mainBuffer.putShort(valueMeta.getInteger(value).shortValue());
                        break block0;
                    }
                    case 4: {
                        this.mainBuffer.putInt(valueMeta.getInteger(value).intValue());
                        break block0;
                    }
                    case 8: {
                        this.mainBuffer.putLong(valueMeta.getInteger(value));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Invalid byte size for Integer type");
            }
            case INTERVAL: {
                this.mainBuffer.putLong(valueMeta.getInteger(value));
                break;
            }
            case TIME: {
                this.calendarLocalTZ.setTime(valueMeta.getDate(value));
                long milliSeconds = TimeUnit.HOURS.toMillis(this.calendarLocalTZ.get(11)) + TimeUnit.MINUTES.toMillis(this.calendarLocalTZ.get(12)) + TimeUnit.SECONDS.toMillis(this.calendarLocalTZ.get(13)) + (long)this.calendarLocalTZ.get(14);
                this.mainBuffer.putLong(TimeUnit.MILLISECONDS.toMicros(milliSeconds));
                break;
            }
            case TIMETZ: {
                this.calendarUTC.setTime(valueMeta.getDate(value));
                long milliSeconds = TimeUnit.HOURS.toMillis(this.calendarUTC.get(11)) + TimeUnit.MINUTES.toMillis(this.calendarUTC.get(12)) + TimeUnit.SECONDS.toMillis(this.calendarUTC.get(13)) + (long)this.calendarUTC.get(14);
                long utcOffsetInSeconds = 86400L;
                this.mainBuffer.putLong((TimeUnit.MILLISECONDS.toMicros(milliSeconds) << 24) + 86400L);
                break;
            }
            case TIMESTAMP: {
                this.calendarLocalTZ.setTime(valueMeta.getDate(value));
                long milliSeconds = ColumnSpec.computeDiffInMillisDisrespectingDst(this.calendarLocalTZ);
                this.mainBuffer.putLong(TimeUnit.MILLISECONDS.toMicros(milliSeconds));
                break;
            }
            case TIMESTAMPTZ: {
                this.calendarUTC.setTime(valueMeta.getDate(value));
                long milliSeconds = this.calendarUTC.getTimeInMillis() - BASE_DATE_UTC_MILLIS;
                this.mainBuffer.putLong(TimeUnit.MILLISECONDS.toMicros(milliSeconds));
                break;
            }
            case VARBINARY: {
                int sizePosition = this.mainBuffer.position();
                this.mainBuffer.putInt(0);
                int prevPosition = this.mainBuffer.position();
                this.mainBuffer.put(valueMeta.getBinaryString(value));
                this.mainBuffer.putInt(sizePosition, this.mainBuffer.position() - prevPosition);
                this.bytes = this.mainBuffer.position() - sizePosition;
                break;
            }
            case NUMERIC: 
            case VARCHAR: {
                this.charBuffer.clear();
                this.charEncoder.reset();
                this.charBuffer.put(valueMeta.getString(value));
                this.charBuffer.flip();
                int sizePosition = this.mainBuffer.position();
                this.mainBuffer.putInt(0);
                int prevPosition = this.mainBuffer.position();
                this.charEncoder.encode(this.charBuffer, this.mainBuffer, true);
                int dataLength = this.mainBuffer.position() - prevPosition;
                this.mainBuffer.putInt(sizePosition, dataLength);
                this.bytes = this.mainBuffer.position() - sizePosition;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ColumnType");
            }
        }
    }

    private static int computeJdn(GregorianCalendar calendar) {
        return ColumnSpec.computeJdn(calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    private static int computeJdn(int year, int month, int day) {
        int a = (14 - month) / 12;
        int y = year + 4800 - a;
        int m = month + 12 * a - 3;
        int jdn = day + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
        return jdn;
    }

    private static long computeDiffInMillisDisrespectingDst(GregorianCalendar calendar) {
        int days = ColumnSpec.computeJdn(calendar) - BASE_DATE_JDN;
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int seconds = calendar.get(13);
        long millis = calendar.get(14);
        return TimeUnit.DAYS.toMillis(days) + TimeUnit.HOURS.toMillis(hours) + TimeUnit.MINUTES.toMillis(minutes) + TimeUnit.SECONDS.toMillis(seconds) + millis;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    static {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(2000, 0, 1, 0, 0, 0);
        BASE_DATE_UTC_MILLIS = calendar.getTimeInMillis();
    }

    public static enum PrecisionScaleWidthType {
        NUMERIC(ColumnType.NUMERIC);

        private final ColumnType type;

        private PrecisionScaleWidthType(ColumnType type) {
            this.type = type;
        }
    }

    public static enum UserDefinedWidthType {
        CHAR(ColumnType.CHAR),
        BINARY(ColumnType.BINARY);

        private final ColumnType type;

        private UserDefinedWidthType(ColumnType type) {
            this.type = type;
        }
    }

    public static enum ConstantWidthType {
        INTEGER_8(ColumnType.INTEGER, 1),
        INTEGER_16(ColumnType.INTEGER, 2),
        INTEGER_32(ColumnType.INTEGER, 4),
        INTEGER_64(ColumnType.INTEGER, 8),
        BOOLEAN(ColumnType.BOOLEAN, 1),
        FLOAT(ColumnType.FLOAT, 8),
        DATE(ColumnType.DATE, 8),
        TIME(ColumnType.TIME, 8),
        TIMETZ(ColumnType.TIMETZ, 8),
        TIMESTAMP(ColumnType.TIMESTAMP, 8),
        TIMESTAMPTZ(ColumnType.TIMESTAMPTZ, 8),
        INTERVAL(ColumnType.INTERVAL, 8);

        private final ColumnType type;
        private final int bytes;

        private ConstantWidthType(ColumnType type, int bytes) {
            this.type = type;
            this.bytes = bytes;
        }
    }

    public static enum VariableWidthType {
        VARCHAR(ColumnType.VARCHAR),
        VARBINARY(ColumnType.VARBINARY);

        private final ColumnType type;
        private final int bytes = -1;

        private VariableWidthType(ColumnType type) {
            this.type = type;
        }
    }
}

