/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.events;

import com.datastax.oss.driver.api.core.metadata.schema.FunctionMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.SchemaChangeType;
import java.util.Objects;
import net.jcip.annotations.Immutable;

@Immutable
public class FunctionChangeEvent {
    public final SchemaChangeType changeType;
    public final FunctionMetadata oldFunction;
    public final FunctionMetadata newFunction;

    public static FunctionChangeEvent dropped(FunctionMetadata oldFunction) {
        return new FunctionChangeEvent(SchemaChangeType.DROPPED, oldFunction, null);
    }

    public static FunctionChangeEvent created(FunctionMetadata newFunction) {
        return new FunctionChangeEvent(SchemaChangeType.CREATED, null, newFunction);
    }

    public static FunctionChangeEvent updated(FunctionMetadata oldFunction, FunctionMetadata newFunction) {
        return new FunctionChangeEvent(SchemaChangeType.UPDATED, oldFunction, newFunction);
    }

    private FunctionChangeEvent(SchemaChangeType changeType, FunctionMetadata oldFunction, FunctionMetadata newFunction) {
        this.changeType = changeType;
        this.oldFunction = oldFunction;
        this.newFunction = newFunction;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof FunctionChangeEvent) {
            FunctionChangeEvent that = (FunctionChangeEvent)other;
            return this.changeType == that.changeType && Objects.equals(this.oldFunction, that.oldFunction) && Objects.equals(this.newFunction, that.newFunction);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.changeType, this.oldFunction, this.newFunction});
    }

    public String toString() {
        switch (this.changeType) {
            case CREATED: {
                return String.format("FunctionChangeEvent(CREATED %s)", this.newFunction.getSignature());
            }
            case UPDATED: {
                return String.format("FunctionChangeEvent(UPDATED %s=>%s)", this.oldFunction.getSignature(), this.newFunction.getSignature());
            }
            case DROPPED: {
                return String.format("FunctionChangeEvent(DROPPED %s)", this.oldFunction.getSignature());
            }
        }
        throw new IllegalStateException("Unsupported change type " + (Object)((Object)this.changeType));
    }
}

