/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.bus;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.ui.core.bus.HopGuiEvent;
import org.apache.hop.ui.core.bus.IHopGuiEventListener;

public class HopGuiEventsHandler {
    private Map<String, Map<String, IHopGuiEventListener>> guiEventListenerMap = new HashMap<String, Map<String, IHopGuiEventListener>>();

    public <T> void addEventListener(String guiId, IHopGuiEventListener<T> listener, String ... eventIds) {
        if (StringUtils.isEmpty((String)guiId)) {
            throw new RuntimeException("Please provide a GUI id to allow you to remove the listener when you're no longer need it");
        }
        if (eventIds == null || eventIds.length == 0) {
            throw new RuntimeException("Please provide an event ID so we know what to be on the lookout for");
        }
        for (String eventId : eventIds) {
            if (!StringUtils.isEmpty((String)eventId)) continue;
            throw new RuntimeException("Please only use event IDs which are not null or empty");
        }
        Map<String, IHopGuiEventListener> eventListenerMap = this.guiEventListenerMap.get(guiId);
        if (eventListenerMap == null) {
            eventListenerMap = new HashMap<String, IHopGuiEventListener>();
            this.guiEventListenerMap.put(guiId, eventListenerMap);
        }
        for (String eventId : eventIds) {
            eventListenerMap.put(eventId, listener);
        }
    }

    public void removeEventListener(String guiId, String ... eventIds) {
        if (StringUtils.isEmpty((String)guiId)) {
            throw new RuntimeException("Please provide a GUI ID of the component you're done with being informed about.");
        }
        if (eventIds == null || eventIds.length == 0) {
            throw new RuntimeException("Please provide the event IDs of the listeners to remove.");
        }
        for (String eventId : eventIds) {
            if (!StringUtils.isEmpty((String)eventId)) continue;
            throw new RuntimeException("Please only use event IDs which are not null or empty");
        }
        Map<String, IHopGuiEventListener> eventListenerMap = this.guiEventListenerMap.get(guiId);
        if (eventListenerMap == null) {
            return;
        }
        for (String eventId : eventIds) {
            eventListenerMap.remove(eventId);
        }
        if (eventListenerMap.isEmpty()) {
            this.guiEventListenerMap.remove(guiId);
        }
    }

    public void removeEventListeners(String guiId) {
        if (StringUtils.isEmpty((String)guiId)) {
            throw new RuntimeException("Please provide a GUI ID of the component you're done with being informed about.");
        }
        this.guiEventListenerMap.remove(guiId);
    }

    public <T> void fire(T eventSubject, boolean all, String ... eventIds) throws HopException {
        if (eventIds == null || eventIds.length == 0) {
            throw new RuntimeException("Please provide the IDs of the events you want to fire");
        }
        for (String eventId : eventIds) {
            if (!StringUtils.isEmpty((String)eventId)) continue;
            throw new RuntimeException("Please only use event IDs which are not null or empty");
        }
        block1: for (Map map : this.guiEventListenerMap.values()) {
            for (String eventId : eventIds) {
                IHopGuiEventListener listener = (IHopGuiEventListener)map.get(eventId);
                if (listener == null) continue;
                listener.event(new HopGuiEvent<T>(eventId, eventSubject));
                if (!all) continue block1;
            }
        }
    }

    public void fire(boolean all, String ... eventIds) throws HopException {
        this.fire(null, all, eventIds);
    }

    public <T> void fire(T eventSubject, String ... eventIds) throws HopException {
        this.fire(eventSubject, false, eventIds);
    }

    public void fire(String ... eventIds) throws HopException {
        this.fire(false, eventIds);
    }

    public Map<String, Map<String, IHopGuiEventListener>> getGuiEventListenerMap() {
        return this.guiEventListenerMap;
    }

    public void setGuiEventListenerMap(Map<String, Map<String, IHopGuiEventListener>> guiEventListenerMap) {
        this.guiEventListenerMap = guiEventListenerMap;
    }
}

