/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.SearchMatchV2;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SearchV2Result {
    protected final List<SearchMatchV2> matches;
    protected final boolean hasMore;
    protected final String cursor;

    public SearchV2Result(List<SearchMatchV2> matches, boolean hasMore, String cursor) {
        if (matches == null) {
            throw new IllegalArgumentException("Required value for 'matches' is null");
        }
        for (SearchMatchV2 x : matches) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'matches' is null");
        }
        this.matches = matches;
        this.hasMore = hasMore;
        if (cursor != null && cursor.length() < 1) {
            throw new IllegalArgumentException("String 'cursor' is shorter than 1");
        }
        this.cursor = cursor;
    }

    public SearchV2Result(List<SearchMatchV2> matches, boolean hasMore) {
        this(matches, hasMore, null);
    }

    public List<SearchMatchV2> getMatches() {
        return this.matches;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public String getCursor() {
        return this.cursor;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.matches, this.hasMore, this.cursor});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchV2Result other = (SearchV2Result)obj;
            return (this.matches == other.matches || this.matches.equals(other.matches)) && this.hasMore == other.hasMore && (this.cursor == other.cursor || this.cursor != null && this.cursor.equals(other.cursor));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SearchV2Result> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchV2Result value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("matches");
            StoneSerializers.list(SearchMatchV2.Serializer.INSTANCE).serialize(value.matches, g);
            g.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g);
            if (value.cursor != null) {
                g.writeFieldName("cursor");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.cursor, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SearchV2Result deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_cursor;
            Boolean f_hasMore;
            List<SearchMatchV2> f_matches;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_matches = null;
                f_hasMore = null;
                f_cursor = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("matches".equals(field)) {
                        f_matches = StoneSerializers.list(SearchMatchV2.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_matches == null) {
                    throw new JsonParseException(p, "Required field \"matches\" missing.");
                }
                if (f_hasMore == null) {
                    throw new JsonParseException(p, "Required field \"has_more\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SearchV2Result value = new SearchV2Result(f_matches, f_hasMore, f_cursor);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

