/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.conf;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.yarn.conf.ConfigurationProvider;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ConfigurationProviderFactory {
    public static ConfigurationProvider getConfigurationProvider(Configuration bootstrapConf) {
        Class<?> defaultProviderClass;
        try {
            defaultProviderClass = Class.forName("org.apache.hadoop.yarn.LocalConfigurationProvider");
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Invalid default configuration provider classorg.apache.hadoop.yarn.LocalConfigurationProvider", e);
        }
        ConfigurationProvider configurationProvider = ReflectionUtils.newInstance(bootstrapConf.getClass("yarn.resourcemanager.configuration.provider-class", defaultProviderClass, ConfigurationProvider.class), bootstrapConf);
        return configurationProvider;
    }
}

