/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.lang.reflect.Method;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class InferableFunction<InputT, OutputT>
implements ProcessFunction<InputT, OutputT>,
HasDisplayData {
    private final @Nullable ProcessFunction<InputT, OutputT> fn;

    protected InferableFunction() {
        this.fn = null;
        try {
            Method methodThatMustBeOverridden = InferableFunction.class.getDeclaredMethod("apply", Object.class);
            Method methodOnSubclass = this.getClass().getMethod("apply", Object.class);
            if (methodOnSubclass.equals(methodThatMustBeOverridden)) {
                throw new IllegalStateException("Subclass of InferableFunction must override 'apply' method or pass a ProcessFunction to the constructor, usually via a lambda or method reference.");
            }
        }
        catch (NoSuchMethodException exc) {
            throw new RuntimeException("Impossible state: missing 'apply' method entirely", exc);
        }
    }

    protected InferableFunction(ProcessFunction<InputT, OutputT> fn) {
        this.fn = fn;
    }

    @Override
    public OutputT apply(InputT input) throws Exception {
        return this.fn.apply(input);
    }

    public static <InputT, OutputT> InferableFunction<InputT, OutputT> fromProcessFunctionWithOutputType(ProcessFunction<InputT, OutputT> fn, TypeDescriptor<OutputT> outputType) {
        return new InferableFunctionWithOutputType<InputT, OutputT>(fn, outputType);
    }

    public TypeDescriptor<InputT> getInputTypeDescriptor() {
        return new TypeDescriptor<InputT>(this){};
    }

    public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
        return new TypeDescriptor<OutputT>(this){};
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
    }

    private static class InferableFunctionWithOutputType<InputT, OutputT>
    extends InferableFunction<InputT, OutputT> {
        private final TypeDescriptor<OutputT> outputType;

        public InferableFunctionWithOutputType(ProcessFunction<InputT, OutputT> fn, TypeDescriptor<OutputT> outputType) {
            super(fn);
            this.outputType = outputType;
        }

        @Override
        public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            return this.outputType;
        }
    }
}

