/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.util.Weighted;

@Internal
public final class WeightedValue<T>
implements Weighted {
    private final T value;
    private final long weight;

    private WeightedValue(T value, long weight) {
        this.value = value;
        this.weight = weight;
    }

    public static <T> WeightedValue<T> of(T value, long weight) {
        return new WeightedValue<T>(value, weight);
    }

    @Override
    public long getWeight() {
        return this.weight;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WeightedValue)) {
            return false;
        }
        WeightedValue that = (WeightedValue)o;
        return this.weight == that.weight && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.weight);
    }

    public String toString() {
        return "WeightedValue{value=" + this.value + ", weight=" + this.weight + "}";
    }
}

